#include "..\..\..\script_macros.hpp"
#include "poltich_blackjack_macros.hpp"
private["_display", "_gameIsFinished", "_playerHasWon", "_message", "_bet", "_reward", "_scorePlayer", "_scoreDealer"];
params[["_noMoreRound", false, [false]]];
_gameIsFinished = _noMoreRound;
_playerHasWon = false;
_message = "";
_display = findDisplay 5900;
_bet = uiNameSpace getVariable[BLACKJACK_INIT_BET, 0];
_reward = uiNamespace getVariable[BLACKJACK_WIN_REWARD, 0];
_scorePlayer = uiNameSpace getVariable[BLACKJACK_SCORE_PLAYER, 0];
_scoreDealer = uiNamespace getVariable[BLACKJACK_SCORE_DEALER, 0];
if (_bet < 1 || _reward < 1) exitWith {
    _gameIsFinished = true;
    [localize "STR_Blackjack_Err_Undefined", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    life_action_inUse = false;
    _gameIsFinished;
};
if (_scorePlayer isEqualTo 21) then {
    _gameIsFinished = true;
    _message = (localize "STR_SlotsMachine_YouWin_With21") + (format[localize "STR_SlotsMachine_YouWin_YouBeatTheDealer", [_reward] call life_fnc_numberText]);
    _playerHasWon = true;
};
if (_scorePlayer > 21) then {
    _gameIsFinished = true;
    _message = (localize "STR_SlotsMachine_YouLoose_Exceeded21") + (localize "STR_SlotsMachine_YouLoose_TheDealerBeatYou");
};
if (_scoreDealer isEqualTo 21) then {
    _gameIsFinished = true;
    _message = (localize "STR_SlotsMachine_YouLoose_DealerHasReached21") + (localize "STR_SlotsMachine_YouLoose_TheDealerBeatYou");
};
if (_scoreDealer > 21) then {
    _gameIsFinished = true;
    _message = (localize "STR_SlotsMachine_YouWin_DealerHasExceeded21") + (format[localize "STR_SlotsMachine_YouWin_YouBeatTheDealer", [_reward] call life_fnc_numberText]);
    _playerHasWon = true;
};
if (_noMoreRound) then {
    if (_scorePlayer isEqualTo _scoreDealer) then {
        _message = localize "STR_SlotsMachine_Draw_SameScore";
        _playerHasWon = true;
        _reward = _bet;
    };
    if (_scorePlayer > _scoreDealer) then {
        _message = (localize "STR_SlotsMachine_YouWin_WithBetterScore") + (format[localize "STR_SlotsMachine_YouWin_YouBeatTheDealer", [_reward] call life_fnc_numberText]);
        _playerHasWon = true;
    };
    if (_scorePlayer < _scoreDealer) then {
        _message = (localize "STR_SlotsMachine_YouLoose_DealerHasBetterScore") + (localize "STR_SlotsMachine_YouLoose_TheDealerBeatYou");
    };
};
if (_gameIsFinished) then {
    (_display displayCtrl 5902) ctrlShow false;
    (_display displayCtrl 5903) ctrlShow false;
    [_playerHasWon, _reward, _message] spawn {
        params[["_playerHasWon", false, [false]], ["_reward", 0, [0]], ["_message", "", [""]]];
        sleep 2;
        closeDialog 0;
        [_message, "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
        life_action_inUse = false;
        if (_playerHasWon) then {
            CASH = CASH + _reward;
            [0] call SOCK_fnc_updatePartial;
        };
    };
};
_gameIsFinished;