#include "..\..\..\script_macros.hpp"
A4L_braquage_object = param[0, ObjNull, [ObjNull]];
A4L_braquage_args = param[3, [], [
    []
]];
if (A4L_braquage_object isEqualTo objNull) exitWith {
    [localize "STR_ISTR_NotUsable", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (A4L_braquage_args isEqualTo[]) exitWith {
    [localize "STR_ISTR_NotUsable", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
A4L_braquage_type = A4L_braquage_args # 0;
if (!isClass(missionConfigFile >> "Rosenbach_Config_Braquages" >> A4L_braquage_type)) exitWith {
    [localize "STR_NOTF_ConfigDoesNotExist", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if !(life_use_atm) exitWith {
    [localize "STR_Braquage_HasRobCash", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (side player != civilian) exitWith {
    [localize "STR_Braquage_NeedToBeCivilian", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (vehicle player != player) exitWith {
    [localize "STR_Braquage_NeedToBeOutsideCar", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if !(alive player) exitWith {};
if (currentWeapon player isEqualTo "") exitWith {
    [localize "STR_Braquage_NoWeapon", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((currentWeapon player) in (getArray(missionConfigFile >> "Rosenbach_Config_Braquages" >> "blacklistWeapons"))) exitWith {
    [localize "STR_Braquage_WeaponNotAllow", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
A4L_braquage_config = (missionConfigFile >> "Rosenbach_Config_Braquages" >> A4L_braquage_type);
_listSides = [civilian, west, independent];
_countPlayers = []; {
    _countPlayers pushBack(_x countSide playableUnits)
}
forEach _listSides; {
    _countPlayers pushBack(_x countSide switchableUnits)
}
forEach _listSides;
_minimumPlayers = getArray(A4L_braquage_config >> "minimumPlayers");
if ((_countPlayers select 0) < (_minimumPlayers select 0)) exitWith {
    [localize "STR_Braquage_NeedMoreCivilians", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_countPlayers select 1) < (_minimumPlayers select 1)) exitWith {
    [localize "STR_Braquage_NeedMoreCops", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_countPlayers select 2) < (_minimumPlayers select 2)) exitWith {
    [localize "STR_Braquage_NeedMoreMedics", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_lastTimeBraquage = serverTime - (A4L_braquage_object getVariable["Rosenbach_lastTimeBraquage", 0]);
_Rosenbach_TimeLockBraquage = getNumber(A4L_braquage_config >> "timeBeforeRelaunch");
if (_lastTimeBraquage < _Rosenbach_TimeLockBraquage) exitWith {
    [localize "STR_Braquage_NeedMoreTime", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_multi_cop_value = 1;
_multi_cop_array = getArray(A4L_braquage_config >> "multi");
_copConnected = (_countPlayers select 1); {
    if (count(_x select 0) == 2) then {
        if (_copConnected >= ((_x select 0) select 0) && _copConnected <= ((_x select 0) select 1)) then {
            _multi_cop_value = (_x select 1);
        };
    } else {
        if (_copConnected >= ((_x select 0) select 0)) then {
            _multi_cop_value = (_x select 1);
        };
    };
}
forEach _multi_cop_array;
A4L_braquage_multi = _multi_cop_value;
_boundingBox = boundingBoxReal A4L_braquage_object;
_p1 = _boundingBox select 0;
_p2 = _boundingBox select 1;
A4L_braquage_object_lenght = (abs((_p2 select 1) - (_p1 select 1)));
A4L_braquage_object_width = (abs((_p2 select 0) - (_p1 select 0)));
A4L_braquage_object_height = abs((_p2 select 2) - (_p1 select 2));
_p1 = _p1 vectorAdd[0, 0, 0.04];
_tailleZone = getNumber(missionConfigFile >> "Rosenbach_Config_Braquages" >> "areaSize");
_angle1 = _p1 vectorAdd[(_tailleZone / 2) * -1, (_tailleZone / 2) * -1, 0];
_angle2 = _p1 vectorAdd[A4L_braquage_object_width + (_tailleZone / 2), (_tailleZone / 2) * -1, 0];
_angle3 = _p1 vectorAdd[A4L_braquage_object_width + (_tailleZone / 2), A4L_braquage_object_lenght + (_tailleZone / 2), 0];
_angle4 = _p1 vectorAdd[(_tailleZone / 2) * -1, A4L_braquage_object_lenght - ((_tailleZone / 2) * -1), 0];
A4L_braquage_object_bouding = [_angle1, _angle2, _angle3, _angle4];
A4L_braquage_timeStart = time;
A4L_braquage_time = time;
A4L_braquage_timeLimit = getNumber(A4L_braquage_config >> "maxTime");
A4L_braquage_interval = getNumber(A4L_braquage_config >> "interval");
A4L_braquage_beforeStart = getNumber(A4L_braquage_config >> "timeBeforeStart");
A4L_braquage_gain = 0;
A4L_braquage_gainLimit = getNumber(A4L_braquage_config >> "maxGain");
if (A4L_braquage_gainLimit > -1) then {
    A4L_braquage_gainLimit = A4L_braquage_gainLimit * _multi_cop_value;
};
A4L_braquage_randomMin = getNumber(A4L_braquage_config >> "randomMin") * _multi_cop_value;
A4L_braquage_randomMax = getNumber(A4L_braquage_config >> "randomMax") * _multi_cop_value;
A4L_braquage_randomMid = A4L_braquage_randomMin + ((A4L_braquage_randomMax - A4L_braquage_randomMin) / 2);
[] spawn {
    A4L_braquage_layer = ("A4L_braquage"
    call BIS_fnc_rscLayer);
    A4L_braquage_layer cutRsc["braquageHUD", "PLAIN"];
};
A4L_braquage_object setVariable["Rosenbach_lastTimeBraquage", serverTime, true];
_callPos = [position A4L_braquage_object, 1, 150, 3, 0, 20, 0] call BIS_fnc_findSafePos;
_caller = selectRandom(getArray(missionConfigFile >> "Rosenbach_Config_Braquages" >> "witnessesName"));
_msgDispatch = selectRandom(getArray(missionConfigFile >> "Rosenbach_Config_Braquages" >> "dispactchMsg"));
_city = text([getPos A4L_braquage_object] call life_fnc_nearestCity);
_placeName = getText(A4L_braquage_config >> "name");
_placeNameMsg = getText(A4L_braquage_config >> "nameMsg");
_message = format[_msgDispatch, _placeNameMsg, _city];
private _fromNum = getText(missionConfigFile >> "Max_Settings_Phone" >> "phone_number_prefix");
for "_i"
from 1 to getNumber(missionConfigFile >> "Max_Settings_Phone" >> "number_of_random_numbers") do {
    _fromNum = format["%1%2", _fromNum, round(random 9)]
}; uiSleep 2;
maxence_waiting_cop_calls pushBack[format["%1", _caller], _callPos, _message, servertime, "", objNull, 0];
publicVariable "maxence_waiting_cop_calls";
[3, "STR_Braquage_MessageOnDispatch", true, [], "Dispatch"] remoteExecCall["life_fnc_broadcast", west];
[format["[BRAQUAGE_SCRIPT] Lancement script par %1;Pos=%2;City=%3;Type=%4", profileName, str(position A4L_braquage_object), _city, A4L_braquage_type], 1] call life_fnc_logs;
playSound3D["A3\Sounds_F\sfx\alarm_independent.wss", A4L_braquage_object];
A4L_braquage_loader = 0;
A4L_braquage_loaderTime = time;
A4L_braquage_handler = addMissionEventHandler["draw3D", {
    if (([A4L_braquage_object, A4L_braquage_object_bouding] call life_fnc_isPlayerInPolygon) == true) then {
        [A4L_braquage_object, A4L_braquage_object_bouding, [0, 1, 0, 1]] call life_fnc_objectDrawBoundingBox;
    } else {
        [A4L_braquage_object, A4L_braquage_object_bouding, [1, 0, 0, 1]] call life_fnc_objectDrawBoundingBox;
    };
    if (time >= (A4L_braquage_timeStart + A4L_braquage_beforeStart)) then {
        if (A4L_braquage_gain <= 0) then {
            ((uiNamespace getVariable "braquageHUD") displayCtrl 98200) ctrlSetStructuredText parseText format["<t size='1.25' align='center' valign='middle'><img size='1.75' image='a3\ui_f\data\igui\cfg\simpletasks\types\move_ca.paa'/>  Retourner dans la zone pour ramasser de l'argent.</t>"];
        };
        if (time >= (A4L_braquage_time + A4L_braquage_interval)) then {
            if (([A4L_braquage_object, A4L_braquage_object_bouding] call life_fnc_isPlayerInPolygon) == true) then {
                _random = ceil(random[A4L_braquage_randomMin, A4L_braquage_randomMid, A4L_braquage_randomMax]);
                A4L_braquage_gain = A4L_braquage_gain + _random;
                _text = format["+ %1 €", [_random] call life_fnc_numberText];
                [A4L_braquage_object, _text, [0.1451, 0.2431, 0.0941, 1], "a3\ui_f_oldman\data\igui\cfg\holdactions\holdaction_market_ca.paa", A4L_braquage_object_height] call life_fnc_3DAnimateText;
                ((uiNamespace getVariable "braquageHUD") displayCtrl 98200) ctrlSetStructuredText parseText format["<t size='1.25' align='center' valign='middle'><img size='1.75' image='a3\ui_f_oldman\data\igui\cfg\holdactions\holdaction_market_ca.paa'/> %1 €</t>", [A4L_braquage_gain] call life_fnc_numberText];
                if (A4L_braquage_gainLimit > -1 && A4L_braquage_gain >= A4L_braquage_gainLimit) then {
                    ["Money"] spawn Rosenbach_fnc_Braquage_Finish;
                };
            };
            if (A4L_braquage_timeLimit > -1 && time >= (A4L_braquage_timeStart + A4L_braquage_timeLimit)) then {
                ["Time"] spawn Rosenbach_fnc_Braquage_Finish;
            };
            A4L_braquage_time = time;
        };
    } else {
        if (time >= A4L_braquage_loaderTime + 0.05) then {
            if (A4L_braquage_loader == 11) then {
                A4L_braquage_loader = 0;
            } else {
                A4L_braquage_loader = A4L_braquage_loader + 1;
            };
            A4L_braquage_loaderTime = time;
        };
        ((uiNamespace getVariable "braquageHUD") displayCtrl 98200) ctrlSetStructuredText parseText format["<t size='1.25' align='center' valign='middle'><img size='1.75' image='a3\ui_f\data\igui\cfg\holdactions\idle\idle_%1_ca.paa'/> Ouverture en cours ...</t>", A4L_braquage_loader];
    };
    if !(player call life_fnc_playerInHouse) then {
        ["Exit"] spawn Rosenbach_fnc_Braquage_Finish;
    };
    if (player getVariable["restrained", false]) exitWith {
        ["Cuffed"] spawn Rosenbach_fnc_Braquage_Finish;
    };
    if (life_istazed) exitWith {
        ["Tazed"] spawn Rosenbach_fnc_Braquage_Finish;
    };
    if !(alive player) exitWith {
        ["Killed"] spawn Rosenbach_fnc_Braquage_Finish;
    };
}];
A4L_braquage_gain = A4L_braquage_gain + ceil(random[1, 500, 1000]);
sleep 15;
[3, "STR_Braquage_AlertMessage", true, [_city], "Dispatch"] remoteExec["life_fnc_broadcast", west];
[format["%1_%2", toUpper A4L_braquage_type, random 999999], position A4L_braquage_object, "mil_warning", "ColorRed", format["ATTENTION : BRAQUAGE %1 EN COURS !", toUpper _placeName], 120] remoteExec["life_fnc_createMarkerLocal", west];