#include "..\..\..\script_macros.hpp"
A4L_cambriolage_object = param[0, ObjNull, [ObjNull]];
A4L_cambriolage_args = param[3, [], [
    []
]];
if (A4L_cambriolage_object isEqualTo objNull) exitWith {
    [localize "STR_ISTR_NotUsable", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (A4L_cambriolage_args isEqualTo[]) exitWith {
    [localize "STR_ISTR_NotUsable", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
A4L_cambriolage_type = A4L_cambriolage_args # 0;
if (!isClass(missionConfigFile >> "Poltich_Config_Cambriolage" >> A4L_cambriolage_type)) exitWith {
    [localize "STR_NOTF_ConfigDoesNotExist", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (side player != civilian) exitWith {
    [localize "STR_Cambriolage_NeedToBeCivilian", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (vehicle player != player) exitWith {
    [localize "STR_Cambriolage_NeedToBeOutsideCar", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (life_inv_lockpick < 1) exitWith {
    [localize "STR_Cambriolage_NeedToHaveLockpick", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if !(alive player) exitWith {};
A4L_cambriolage_config = (missionConfigFile >> "Poltich_Config_Cambriolage" >> A4L_cambriolage_type);
if ((serverTime - (player getVariable["Poltich_lastTimeCambriolage", 0])) < (getNumber(missionConfigFile >> "Poltich_Config_Cambriolage" >> "timePlayerCanRelaunch"))) exitWith {
    [localize "STR_Cambriolage_NeedMoreTimePlayer", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((serverTime - (A4L_cambriolage_object getVariable["Poltich_lastTimeCambriolage", 0])) < (getNumber(A4L_cambriolage_config >> "timeBeforeRelaunch"))) exitWith {
    [localize "STR_Cambriolage_NeedMoreTime", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (A4L_cambriolage_object getVariable["safe_open", false]) exitWith {
    [localize "STR_Cambriolage_ObjectAlreadyOpen", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
};
_listSides = [civilian, west, independent];
_countPlayers = []; {
    _countPlayers pushBack(_x countSide playableUnits)
}
forEach _listSides; {
    _countPlayers pushBack(_x countSide switchableUnits)
}
forEach _listSides;
_minimumPlayers = getArray(A4L_cambriolage_config >> "minimumPlayers");
if ((_countPlayers select 0) < (_minimumPlayers select 0)) exitWith {
    [localize "STR_Cambriolage_NeedMoreCivilians", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_countPlayers select 1) < (_minimumPlayers select 1)) exitWith {
    [localize "STR_Cambriolage_NeedMoreCops", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_countPlayers select 2) < (_minimumPlayers select 2)) exitWith {
    [localize "STR_Cambriolage_NeedMoreMedics", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_multi_cop_value = 1;
_multi_cop_array = getArray(A4L_cambriolage_config >> "multi");
_copConnected = (_countPlayers select 1); {
    if (count(_x select 0) == 2) then {
        if (_copConnected >= ((_x select 0) select 0) && _copConnected <= ((_x select 0) select 1)) then {
            _multi_cop_value = (_x select 1);
        };
    } else {
        if (_copConnected >= ((_x select 0) select 0)) then {
            _multi_cop_value = (_x select 1);
        };
    };
}
forEach _multi_cop_array;
A4L_cambriolage_multi = _multi_cop_value;
_boundingBox = boundingBoxReal A4L_cambriolage_object;
_p1 = _boundingBox select 0;
_p2 = _boundingBox select 1;
A4L_cambriolage_object_lenght = (abs((_p2 select 1) - (_p1 select 1)));
A4L_cambriolage_object_width = (abs((_p2 select 0) - (_p1 select 0)));
A4L_cambriolage_object_height = abs((_p2 select 2) - (_p1 select 2));
_p1 = _p1 vectorAdd[0, 0, 0.04];
_tailleZone = getNumber(missionConfigFile >> "Poltich_Config_Cambriolage" >> "areaSize");
_angle1 = _p1 vectorAdd[(_tailleZone / 2) * -1, (_tailleZone / 2) * -1, 0];
_angle2 = _p1 vectorAdd[A4L_cambriolage_object_width + (_tailleZone / 2), (_tailleZone / 2) * -1, 0];
_angle3 = _p1 vectorAdd[A4L_cambriolage_object_width + (_tailleZone / 2), A4L_cambriolage_object_lenght + (_tailleZone / 2), 0];
_angle4 = _p1 vectorAdd[(_tailleZone / 2) * -1, A4L_cambriolage_object_lenght - ((_tailleZone / 2) * -1), 0];
A4L_cambriolage_object_bouding = [_angle1, _angle2, _angle3, _angle4];
A4L_cambriolage_timeStart = time;
A4L_cambriolage_time = time;
A4L_cambriolage_timeLimit = getNumber(A4L_cambriolage_config >> "maxTime");
A4L_cambriolage_interval = getArray(A4L_cambriolage_config >> "interval");
A4L_cambriolage_beforeStart = getNumber(A4L_cambriolage_config >> "timeBeforeStart");
A4L_cambriolage_timeStartRecolte = A4L_cambriolage_timeStart + A4L_cambriolage_beforeStart;
if (A4L_cambriolage_timeLimit isNotEqualTo - 1) then {
    A4L_cambriolage_timeLimit = A4L_cambriolage_timeLimit + A4L_cambriolage_timeStartRecolte;
};
A4L_cambriolage_userActionStop = -1;
A4L_cambriolage_gain = 0;
A4L_cambriolage_inventaire_coffre = createHashMap;
A4L_cambriolage_gainLimit = getNumber(A4L_cambriolage_config >> "maxItems");
if (A4L_cambriolage_gainLimit > -1) then {
    A4L_cambriolage_gainLimit = A4L_cambriolage_gainLimit * _multi_cop_value;
};
A4L_cambriolage_items = getArray(A4L_cambriolage_config >> "items");
[] spawn {
    A4L_cambriolage_layer = ("A4L_cambriolage"
    call BIS_fnc_rscLayer);
    A4L_cambriolage_layer cutRsc["cambriolageHUD", "PLAIN"];
};
A4L_cambriolage_object setVariable["Poltich_lastTimeCambriolage", serverTime, true];
player setVariable["Poltich_lastTimeCambriolage", serverTime, true];
_callPos = [position A4L_cambriolage_object, 1, 150, 3, 0, 20, 0] call BIS_fnc_findSafePos;
_caller = selectRandom(getArray(missionConfigFile >> "Poltich_Config_Cambriolage" >> "witnessesName"));
_msgDispatch = selectRandom(getArray(missionConfigFile >> "Poltich_Config_Cambriolage" >> "dispactchMsg"));
_city = text([getPos A4L_cambriolage_object] call life_fnc_nearestCity);
_placeName = getText(A4L_cambriolage_config >> "name");
_placeNameMsg = getText(A4L_cambriolage_config >> "nameMsg");
_message = format[_msgDispatch, _city];
private _fromNum = getText(missionConfigFile >> "Max_Settings_Phone" >> "phone_number_prefix");
for "_i"
from 1 to getNumber(missionConfigFile >> "Max_Settings_Phone" >> "number_of_random_numbers") do {
    _fromNum = format["%1%2", _fromNum, round(random 9)]
}; uiSleep 2;
_newNumber = getText(missionConfigFile >> "Max_Settings_Phone" >> "phone_number_prefix");
for "_i"
from 1 to getNumber(missionConfigFile >> "Max_Settings_Phone" >> "number_of_random_numbers") do {
    _newNumber = format["%1%2", _newNumber, round(random 9)];
}; maxence_waiting_cop_calls pushBack[format["%1", _caller], _callPos, _message, servertime, "", objNull, 0, _newNumber];
publicVariable "maxence_waiting_cop_calls";
[3, "STR_Cambriolage_MessageOnDispatch", true, [], "Dispatch", true] remoteExecCall["life_fnc_broadcast", west];
[format["[CAMBRIOLAGE_SCRIPT] Lancement script par %1;Pos=%2;City=%3;Type=%4", profileName, str(position A4L_cambriolage_object), _city, A4L_cambriolage_type], 1] call life_fnc_logs;
A4L_cambriolage_loaderSound = [A4L_cambriolage_object, "alarme", 200, 1] remoteExec["life_fnc_say3D", 0];
A4L_cambriolage_loader = 0;
A4L_cambriolage_loaderTime = time;
A4L_cambriolage_lastTimePick = round(random A4L_cambriolage_interval);
[false, "lockpick", 1] call life_fnc_handleInv;
A4L_cambriolage_handler = addMissionEventHandler["draw3D", {
    if (([A4L_cambriolage_object, A4L_cambriolage_object_bouding] call life_fnc_isPlayerInPolygon) == true) then {
        [A4L_cambriolage_object, A4L_cambriolage_object_bouding, [0, 1, 0, 1]] call life_fnc_objectDrawBoundingBox;
    } else {
        [A4L_cambriolage_object, A4L_cambriolage_object_bouding, [0, 1, 0, 1]] call life_fnc_objectDrawBoundingBox;
    };
    if (time >= A4L_cambriolage_timeStartRecolte) then {
        if (A4L_cambriolage_gain <= 0) then {
            ((uiNamespace getVariable "cambriolageHUD") displayCtrl 99200) ctrlSetStructuredText parseText format["<t size='1.25' align='center' valign='middle'><img size='1.75' image='a3\ui_f\data\igui\cfg\simpletasks\types\move_ca.paa'/>  Retourner dans la zone pour ramasser des objets.</t>"];
        };
        if (A4L_cambriolage_userActionStop isEqualTo - 1) then {
            if ((random 100) >= (getNumber(missionConfigFile >> "Poltich_Config_Cambriolage" >> "ratioToNotBrokeTool"))) then {
                ["Tool_Broken"] spawn Poltich_fnc_Cambriolage_Finish;
            };
            A4L_cambriolage_userActionStop = A4L_cambriolage_object addAction[localize 'STR_MAR_Open_Vault', {
                ["Buttin"] spawn Poltich_fnc_Cambriolage_Finish;
            }, nil, 0, false, false, "", "true", 3];
            [true, getText(A4L_cambriolage_config >> "itemToAddAtBegin"), 1] call life_fnc_handleInv;
        };
        if (time >= (A4L_cambriolage_time + A4L_cambriolage_lastTimePick)) then {
            if (([A4L_cambriolage_object, A4L_cambriolage_object_bouding] call life_fnc_isPlayerInPolygon) == true) then {
                _idTirage = -1; {
                    if ((_x # 0) > (time - A4L_cambriolage_timeStartRecolte)) exitWith {};
                    _idTirage = _idTirage + 1;
                }
                forEach A4L_cambriolage_items;
                _itemSelected = selectRandomWeighted((A4L_cambriolage_items # _idTirage) # 1);
                _itemsMap = createHashMapFromArray((A4L_cambriolage_items # _idTirage) # 2);
                _itemCount = selectRandomWeighted(_itemsMap get _itemSelected);
                if (_itemSelected in A4L_cambriolage_inventaire_coffre) then {
                    A4L_cambriolage_inventaire_coffre set[_itemSelected, ((A4L_cambriolage_inventaire_coffre getOrDefault[_itemSelected, 0]) + _itemCount)];
                } else {
                    A4L_cambriolage_inventaire_coffre insert[[_itemSelected, _itemCount]];
                };
                _text = format["+ %1 %2", _itemCount, localize ITEM_NAME(_itemSelected)];
                [A4L_cambriolage_object, _text, [1, 1, 1, 1], "", A4L_cambriolage_object_height] call life_fnc_3DAnimateText;
                ((uiNamespace getVariable "cambriolageHUD") displayCtrl 99200) ctrlSetStructuredText parseText "<t size='1.25' align='center' valign='middle'><img size='1.75' image='a3\ui_f_oldman\data\igui\cfg\holdactions\holdaction_market_ca.paa'/> Collecte en cours...</t>";
                A4L_cambriolage_lastTimePick = round(random A4L_cambriolage_interval);
                A4L_cambriolage_gain = A4L_cambriolage_gain + _itemCount;
                if (A4L_cambriolage_gainLimit > -1 && A4L_cambriolage_gain >= A4L_cambriolage_gainLimit) then {
                    ["Items"] spawn Poltich_fnc_Cambriolage_Finish;
                };
            };
            if (A4L_cambriolage_timeLimit > -1 && time >= A4L_cambriolage_timeLimit) then {
                ["Time"] spawn Poltich_fnc_Cambriolage_Finish;
            };
            A4L_cambriolage_time = time;
        };
    } else {
        if (time >= A4L_cambriolage_loaderTime + 0.05) then {
            if (A4L_cambriolage_loader == 11) then {
                A4L_cambriolage_loader = 0;
            } else {
                A4L_cambriolage_loader = A4L_cambriolage_loader + 1;
            };
            A4L_cambriolage_loaderTime = time;
        };
        ((uiNamespace getVariable "cambriolageHUD") displayCtrl 99200) ctrlSetStructuredText parseText format["<t size='1.25' align='center' valign='middle'><img size='1.75' image='a3\ui_f\data\igui\cfg\holdactions\idle\idle_%1_ca.paa'/> Ouverture en cours ...</t>", A4L_cambriolage_loader];
    };
    if !(player call life_fnc_playerInHouse) then {
        ["Exit"] spawn Poltich_fnc_Cambriolage_Finish;
    };
    if (player getVariable["restrained", false]) exitWith {
        ["Cuffed"] spawn Poltich_fnc_Cambriolage_Finish;
    };
    if (life_istazed) exitWith {
        ["Tazed"] spawn Poltich_fnc_Cambriolage_Finish;
    };
    if !(alive player) exitWith {
        ["Killed"] spawn Poltich_fnc_Cambriolage_Finish;
    };
    if (A4L_cambriolage_loaderSound isEqualTo objNull) then {
        A4L_cambriolage_loaderSound = [A4L_cambriolage_object, "alarme", 200, 1] remoteExec["life_fnc_say3D", 0];
    };
}];
sleep 15;
[3, "STR_Cambriolage_AlertMessage", true, [_city], "Dispatch", true] remoteExec["life_fnc_broadcast", west];
[format["%1_%2", toUpper A4L_cambriolage_type, random 999999], position A4L_cambriolage_object, "mil_warning", "ColorRed", format["ATTENTION : Cambriolage %1 EN COURS !", toUpper _placeName], 60] remoteExec["life_fnc_createMarkerLocal", west];