#include "..\..\..\script_macros.hpp"
_display = findDisplay 457100;
_config = (missionConfigFile >> "JL_CraftSystem");
_canCraft = _display displayCtrl 457105;
lbClear _canCraft; {
    _craft = configName _x;
    _condition = getText(_config >> _craft >> "condition");
    _condition_result =
    if (_condition isEqualTo "") then {
        true
    } else {
        call compile _condition
    };
    if (isNil "_condition_result" || !(_condition_result isEqualType true) || (_condition_result isEqualTo false)) then {
        continue;
    };
    _requiredItems = getArray(_config >> _craft >> "requiredItems");
    _nbRequiredItems = count _requiredItems;
    if !(_nbRequiredItems isEqualTo(count JL_CRAFT_allMyFusionItems)) then {
        continue;
    };
    _pass = 0; {
        _requiredItem = _x # 0;
        _requiredQuantity = _x # 1;
        _quantityItem = missionNamespace getVariable[format["JL_CRAFT_%1", _requiredItem], 0];
        if (_quantityItem isEqualTo _requiredQuantity) then {
            _pass = _pass + 1;
        };
    }
    forEach _requiredItems;
    if !(_pass isEqualTo _nbRequiredItems) then {
        continue;
    };
    _isPhysicalItem = (getText(_config >> _craft >> "item_type")) isEqualTo "physical";
    _giveItem = getText(_config >> _craft >> "giveItem");
    _displayName = "";
    _picture = "";
    if (_isPhysicalItem) then {
        _configType = "";
        if (isClass(configFile >> "CfgMagazines" >> _giveItem)) then {
            _configType = "CfgMagazines";
        };
        if (isClass(configFile >> "CfgWeapons" >> _giveItem)) then {
            _configType = "CfgWeapons";
        };
        if (isClass(configFile >> "CfgVehicles" >> _giveItem)) then {
            _configType = "CfgVehicles";
        };
        if (isClass(configFile >> "CfgGlasses" >> _giveItem)) then {
            _configType = "CfgGlasses";
        };
        _displayName = getText(configFile >> _configType >> _giveItem >> "displayName");
        _picture = getText(configFile >> _configType >> _giveItem >> "picture");
    } else {
        _displayName = localize(getText(missionConfigFile >> "VirtualItems" >> _giveItem >> "displayName"));
        _picture = getText(missionConfigFile >> "VirtualItems" >> _giveItem >> "icon");
    };
    if (_displayName isNotEqualTo "") then {
        _canCraft lbAdd format["%1", _displayName];
        _canCraft lbSetPicture[(lbSize _canCraft) - 1, _picture];
        _canCraft lbSetPictureColor[(lbSize _canCraft) - 1, [1, 1, 1, 1]];
        _canCraft lbSetData[(lbSize _canCraft) - 1, _craft];
    };
}
forEach("true"
configClasses _config);
_canCraft ctrlEnable(lbSize _canCraft > 0);
(_display displayCtrl 457106) ctrlEnable(lbSize _canCraft > 0);