#include "..\..\..\script_macros.hpp"
_craftListId = 457105;
if ((lbCurSel _craftListId) isEqualTo - 1) exitWith {
    [localize "STR_Craft_Script_NoSelectCraft", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_craft = lbData[_craftListId, lbCurSel _craftListId];
if (_craft isEqualTo "") exitWith {
    [localize "STR_Craft_Script_NoSelectCraft", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_config = missionConfigFile >> "JL_CraftSystem";
_isPhysicalItem = (getText(_config >> _craft >> "item_type")) isEqualTo "physical";
_giveItem = getText(_config >> _craft >> "giveItem");
_timeToCraft = getNumber(_config >> _craft >> "craftTime");
JL_isCrafted = true;
life_action_inUse = true;
_isFar = false;
_isDead = false;
closeDialog 0;
[format["vient de lancer le craft d'un %1", _giveItem]] call life_fnc_logs;
_validPos = position player;
disableSerialization;
"progressBar"
cutRsc["life_progress", "PLAIN"];
_upp = "Craft en cours ! Ne pas bouger !";
_ui = uiNamespace getVariable "life_progress";
_progress = _ui displayCtrl 38201;
_pgText = _ui displayCtrl 38202;
_pgText ctrlSetText format["%2 (1%1)...", "%", _upp];
_progress progressSetPosition 0.01;
_cP = 0.01;
for "_i"
from 0 to 1 step 0 do {
    _cP = _cP + 0.01;
    _progress progressSetPosition _cP;
    _pgText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _upp];
    if (_cP >= 1) exitWith {};
    if (player distance _validPos > 6) exitWith {
        _isFar = true
    };
    if (!alive player) exitWith {
        _isDead = true;
    };
    uiSleep(_timeToCraft / 100);
};
"progressBar" cutText ["", "PLAIN"];
JL_isCrafted = false;
life_action_inUse = false;
if (_isFar) exitWith {
    [] call JL_fnc_Craft_ClearDataScript;
    [localize "STR_Craft_Script_CraftCanceled_DoNotMove", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_isDead) exitWith {
    [] call JL_fnc_Craft_ClearDataScript;
};
_exit = false;
if (_isPhysicalItem) then {
    _configType = "";
    if (isClass(configFile >> "CfgWeapons" >> _giveItem)) then {
        _configType = "CfgWeapons";
    };
    if (_configType isNotEqualTo "CfgWeapons" && !(player canAdd _giveItem)) exitWith {
        _exit = true;
        [] call JL_fnc_Craft_ClearDataScript;
        [localize "STR_Craft_Script_CraftCanceled_MoreSpace", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    _physical_item_type = getNumber(_config >> _craft >> "physical_item_type");
    switch (_physical_item_type) do {
        case (0):
            {
                player addWeapon _giveItem;
            };
        case (1):
            {
                player addMagazine _giveItem;
            };
        case (2):
            {
                player addItem _giveItem;
            };
        case (3):
            {
                player addVest _giveItem;
            };
        case (4):
            {
                player addGoggles _giveItem;
            };
    };
} else {
    _diff = [_giveItem, 1, life_carryWeight, life_maxWeight] call life_fnc_calWeightDiff;
    if (_diff <= 0) exitWith {
        _exit = true;
        [] call JL_fnc_Craft_ClearDataScript;
        [format[localize "STR_Craft_Script_CraftCanceled_MoreSpace_VItem", [_giveItem] call life_fnc_itemWeight], "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    if !([true, _giveItem, 1] call life_fnc_handleInv) exitWith {
        _exit = true;
        [] call JL_fnc_Craft_ClearDataScript;
        [format[localize "STR_Craft_Script_CraftCanceled_MoreSpace_VItem", [_giveItem] call life_fnc_itemWeight], "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
};
if (_exit) exitWith {}; {
    _item = _x;
    _var = format["JL_CRAFT_%1", _item];
    missionNamespace setVariable[_var, 0];
}
forEach JL_CRAFT_allMyFusionItems;
JL_CRAFT_allMyFusionItems = [];
[localize "STR_Craft_Script_CraftSucess", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;