#include "..\..\..\script_macros.hpp"
private["_display", "_texturePath", "_pName", "_pLicenses", "_pUid", "_pSide", "_pPicture", "_pWlLevel", "_pJobClass", "_imgPath", "_identity", "_customText", "_colorText", "_statusText"];
params[["_data", [],
    [
        []
    ]
], ["_cardType", "identity", [""]]];
if (_data isEqualTo[]) exitWith {};
_texturePath = "\A4L_Textures\mission\ArmaForLife\IdentityCard\textures";
switch (_cardType) do {
    case "identity":
        {
            _data params[["_pName", "", [""]], ["_pUid", "", [""]], ["_pSide", sideUnknown, [sideUnknown]], ["_pPicture", "", [""]], ["_pWlLevel", 0, [0]], ["_pJobClass", "", [""]]];
            disableSerialization;
            9100 cutRsc["Poltich_CardIdentity_Civilian", "PLAIN"];
            _display = uiNamespace getVariable["Poltich_CardIdentity_Civilian", displayNull];
            if (isNull _display) exitWith {};
            _identity = _pName splitString " ";
            _imgPath = format["%1\civilian\faces\%2.paa", _texturePath, _pPicture];
            _imgPath =
            if !(fileExists(_imgPath)) then {
                format["%1\civilian\faces\ERR_NO_HEAD.paa", _texturePath]
            } else {
                _imgPath
            };
            (_display displayCtrl 4531) ctrlSetText _imgPath;
            (_display displayCtrl 4532) ctrlSetStructuredText parseText((_identity select[1, ((count _identity) - 1)]) joinString "-");
            (_display displayCtrl 4533) ctrlSetStructuredText parseText(_identity # 0);
            (_display displayCtrl 4534) ctrlSetStructuredText parseText _pUid;
        }; case "job":
            {
                _data params[["_pName", "", [""]], ["_pUid", "", [""]], ["_pSide", sideUnknown, [sideUnknown]], ["_pPicture", "", [""]], ["_pWlLevel", 0, [0]], ["_pJobClass", "", [""]]];
                switch (_pSide) do {
                    case independent:
                        {
                            disableSerialization;
                            9100 cutRsc["Poltich_CardJob_Independent", "PLAIN"];
                            _display = uiNamespace getVariable["Poltich_CardJob_Independent", displayNull];
                            if (isNull _display) exitWith {};
                            _customText = format["%1<br/><t size='1.4' font='RobotoCondensedBold'>%2</t><br/><t size='0.8'>%3</t><br/><br/><t size='0.8'>18 - pompiers@a4l.fr</t>", ((LIFE_SETTINGS(getArray, "rank_med") select _pWlLevel) select 0), _pName, _pUid];
                            (_display displayCtrl 4511) ctrlSetText format["%1\independent\%2.paa", _texturePath, _pWlLevel];
                            (_display displayCtrl 4512) ctrlSetStructuredText parseText _customText;
                        };
                    case west:
                        {
                            disableSerialization;
                            9100 cutRsc["Poltich_CardJob_West", "PLAIN"];
                            _display = uiNamespace getVariable["Poltich_CardJob_West", displayNull];
                            if (isNull _display) exitWith {};
                            _customText = format["<t size='1.4' font='RobotoCondensedLight'>%2</t><br/>%1<br/><t size='0.8'>%3</t><br/><t size='0.8'>17 - police@a4l.fr</t>", ((LIFE_SETTINGS(getArray, "rank_cop") select _pWlLevel) select 0), _pName, _pUid];
                            (_display displayCtrl 4521) ctrlSetText format["%1\west\%2.paa", _texturePath, _pWlLevel];
                            (_display displayCtrl 4522) ctrlSetStructuredText parseText _customText;
                        };
                    case civilian:
                        {
                            _jobName = M_CONFIG(getText, "Licenses", _pJobClass, "displayName");
                            if (_jobName isEqualTo "") exitWith {};
                            disableSerialization;
                            9100 cutRsc["Poltich_CardJob_Civilian", "PLAIN"];
                            _display = uiNamespace getVariable["Poltich_CardJob_Civilian", displayNull];
                            if (isNull _display) exitWith {};
                            _identity = _pName splitString " ";
                            _imgPath = format["%1\civilian\faces\%2.paa", _texturePath, _pPicture];
                            _imgPath =
                            if !(fileExists(_imgPath)) then {
                                format["%1\civilian\faces\ERR_NO_HEAD.paa", _texturePath]
                            } else {
                                _imgPath
                            };
                            (_display displayCtrl 4541) ctrlSetText _imgPath;
                            (_display displayCtrl 4542) ctrlSetStructuredText parseText((_identity select[1, ((count _identity) - 1)]) joinString "-");
                            (_display displayCtrl 4543) ctrlSetStructuredText parseText(_identity # 0);
                            (_display displayCtrl 4544) ctrlSetStructuredText parseText _pUid;
                            (_display displayCtrl 4545) ctrlSetStructuredText parseText(localize _jobName);
                            _imgPath = format["%1\civilian\pro_card_%2.paa", _texturePath, _pJobClass];
                            (_display displayCtrl 4546) ctrlSetText _imgPath;
                        };
                    default {};
                };
            };
        case "playerLicense":
            {
                _data params[["_pName", "", [""]], ["_pLicenses", [],
                    [
                        []
                    ]
                ]];
                disableSerialization;
                9100 cutRsc["Poltich_CardLicenses_Civilian", "PLAIN"];
                _display = uiNamespace getVariable["Poltich_CardLicenses_Civilian", displayNull];
                if (isNull _display) exitWith {};
                _identity = _pName splitString " ";
                (_display displayCtrl 4551) ctrlSetStructuredText parseText((_identity select[1, ((count _identity) - 1)]) joinString "-");
                (_display displayCtrl 4552) ctrlSetStructuredText parseText(_identity # 0);
                _startIdc = 4553; {
                    _x params[["_pLicenseIsActive", false, [false]], ["_pLicenseRemainPts", -1, [0]]];
                    _colorText = ["B00000", "008C00"] select _pLicenseIsActive;
                    _statusText =
                    if (_pLicenseRemainPts > 0) then {
                        format["%1pts", _pLicenseRemainPts];
                    } else {
                        ["NON", "OUI"] select _pLicenseIsActive;
                    };
                    _customText = format["<t color='#%1'>%2</t>", _colorText, _statusText];
                    (_display displayCtrl(_startIdc + _forEachIndex)) ctrlSetStructuredText parseText _customText;
                }
                forEach _pLicenses;
            };
        default {};
};