private _target = param[0, objNull, [objNull]];
private _cardType = param[1, "identity", [""]];
private _deadBody = param[2, player, [objNull]];
private _data = [];
if (isNull _target) then {
    _target = cursorObject;
};
if (isNull _target) then {
    _target = player;
};
if !(_target isKindOf "CAManBase") then {
    _target = player;
};
if !(alive _target) then {
    _target = player;
};
if (_cardType isEqualTo "playerLicense") then {
    private _licenses = [];
    private _pointsCfg = (missionConfigFile >> "Max_Settings_PermisPoints" >> "permis_type");
    private _points = missionNamespace getVariable[(getText(_pointsCfg >> "driver" >> "points_variable")), 0];
    _licenses pushBack[(license_civ_driver || playerSide isEqualTo west), ([_points, getNumber(_pointsCfg >> "driver" >> "maximum_points")] select((_points isEqualTo 0) && (playerSide isEqualTo west)))];
    _points = missionNamespace getVariable[(getText(_pointsCfg >> "trucking" >> "points_variable")), 0];
    _licenses pushBack[(license_civ_trucking || playerSide isEqualTo west), ([_points, getNumber(_pointsCfg >> "trucking" >> "maximum_points")] select((_points isEqualTo 0) && (playerSide isEqualTo west)))];
    _points = missionNamespace getVariable[(getText(_pointsCfg >> "moto" >> "points_variable")), 0];
    _licenses pushBack[(license_civ_moto || ((playerSide isEqualTo west) && (_points > 0))), _points];
    _points = missionNamespace getVariable[(getText(_pointsCfg >> "boat" >> "points_variable")), 0];
    _licenses pushBack[(license_civ_boat || ((playerSide isEqualTo west) && (_points > 0))), _points];
    _licenses pushBack[license_civ_dive, -1];
    _licenses pushBack[(license_civ_gun || playerSide isEqualTo west), -1];
    _points = missionNamespace getVariable[(getText(_pointsCfg >> "pilot" >> "points_variable")), 0];
    _licenses pushBack[(license_civ_pilot || ((playerSide isEqualTo west) && (_points > 0))), _points];
    _licenses pushBack[license_civ_home, -1];
    _licenses pushBack[(player getVariable['inService_global', false]), -1];
    _data pushBack(name player);
    _data pushBack _licenses;
} else {
    if (_deadBody isEqualTo player) then {
        _data pushBack(name player);
        _data pushBack(getPlayerUID player);
        _data pushBack(playerSide);
        _data pushBack(face player);
        switch (playerSide) do {
            case independent:
                {
                    _data pushBack(call life_medicLevel);
                };
            case west:
                {
                    _data pushBack(call life_coplevel);
                };
            default {
                _data pushBack 0;
            };
        }; _data pushBack(player getVariable["inService_name", ""]);
        if (_cardType isEqualTo "identity") then {
            _data set[2, civilian];
        };
    } else {
        _data pushBack(_deadBody getVariable["realname", "Nom inconnu"]);
        _data pushBack(_deadBody getVariable["steam64id", "7656000000000000"]);
        _data pushBack(civilian);
        _data pushBack(face _deadBody);
        _data pushBack(0);
        _data pushBack("");
    };
};
if (_target isEqualTo player) then {
    [_data, _cardType] spawn Poltich_fnc_displayIdentityCard;
} else {
    [_data, _cardType] remoteExec["Poltich_fnc_displayIdentityCard", _target];
};