#include "..\..\..\script_macros.hpp"
# define MACRO_CONFIG missionConfigFile >> "Poltich_Config_Leboncoin"
# define MACRO_CREATE_CONFIG MACRO_CONFIG >> "create"
private["_display", "_categoriesList", "_i", "_price", "_title", "_message", "_customName"];
params[["_obj", objNull, [objNull]]];
if !(isNull findDisplay 71300) exitWith {};
disableSerialization;
createDialog "Poltich_Leboncoin_CreateAnnonce";
waitUntil {
    !isNull findDisplay 71300
};
_display = findDisplay 71300;
(_display displayCtrl 260120) ctrlSetText(call the_programmer_iphone_xi_fnc_functions_getIphoneColor);
(_display displayCtrl 260121) ctrlSetText "\IphoneXI_Assets\menus\apps\leboncoin.paa";
[_display, (_display displayCtrl 260122)] spawn the_programmer_iphone_xi_fnc_functions_displayCurrentHour;
_categoriesList = _display displayCtrl 71133; {
    _i = _categoriesList lbAdd(_x # 1);
    _categoriesList lbSetValue[_i, (_x # 0)];
}
forEach(getArray(MACRO_CONFIG >> "categories"));
_categoriesList lbSetCurSel 0;
_price = getNumber(MACRO_CREATE_CONFIG >> "price");
(_display displayCtrl 71141) ctrlShow false;
if !(getText((configOf _obj) >> "editorPreview") isEqualTo "") then {
    (_display displayCtrl 71141) ctrlSetText(typeOf _obj);
    _price = _price + getNumber(MACRO_CREATE_CONFIG >> "extraPhoto");
    (_display displayCtrl 71105) ctrlSetStructuredText parseText format[localize "STR_Leboncoin_Txt_PublishAnnonce", "avec"];
} else {
    (_display displayCtrl 71105) ctrlSetStructuredText parseText format[localize "STR_Leboncoin_Txt_PublishAnnonce", "sans"];
};
_title = "";
_message = "";
if (_obj isKindOf "House_F") then {
    _customName = (text nearestLocation[(position _obj), "nameCity"]);
    _title = format[localize "STR_Leboncoin_DefaultTitle_House", _customName];
    if (isClass(missionConfigFile >> "Garages" >> worldName >> (typeOf _obj))) then {
        _categoriesList lbSetCurSel 1;
        _title = format[localize "STR_Leboncoin_DefaultTitle_Garage", _customName];
        _message = format[localize "STR_Leboncoin_DefaultMsg_Garage", _customName];
    } else {
        _categoriesList lbSetCurSel 0;
        _message = format[localize "STR_Leboncoin_DefaultMsg_House", _customName];
    };
};
if (_obj isKindOf "Car") then {
    _customName = getText(configFile >> "CfgVehicles" >> typeOf _obj >> "displayName");
    _customName =
    if ((count _customName) > 20) then[{
        _customName select[0, 20]
    }, {
        _customName
    }];
    _title = format[localize "STR_Leboncoin_DefaultTitle_Car", _customName];
    _message = format[localize "STR_Leboncoin_DefaultMsg_Car", _customName];
    _categoriesList lbSetCurSel 2;
};
if (_obj isKindOf "Ship") then {
    _customName = getText(configFile >> "CfgVehicles" >> typeOf _obj >> "displayName");
    _customName =
    if ((count _customName) > 20) then[{
        _customName select[0, 20]
    }, {
        _customName
    }];
    _title = format[localize "STR_Leboncoin_DefaultTitle_Ship", _customName];
    _message = format[localize "STR_Leboncoin_DefaultMsg_Ship", _customName];
    _categoriesList lbSetCurSel 3;
};
if (_obj isKindOf "Air") then {
    _customName = getText(configFile >> "CfgVehicles" >> typeOf _obj >> "displayName");
    _customName =
    if ((count _customName) > 20) then[{
        _customName select[0, 20]
    }, {
        _customName
    }];
    _title = format[localize "STR_Leboncoin_DefaultTitle_Airplane", _customName];
    _message = format[localize "STR_Leboncoin_DefaultMsg_Airplane", _customName];
    _categoriesList lbSetCurSel 4;
};
(_display displayCtrl 71131) ctrlSetText _title;
(_display displayCtrl 71139) ctrlSetText _message;
(_display displayCtrl 71137) ctrlSetTooltip format[localize "STR_Leboncoin_Txt_InfoUrgentCreateAnnonce", getNumber(MACRO_CONFIG >> "urgentDays"), getNumber(MACRO_CREATE_CONFIG >> "extraUrgent")];
(_display displayCtrl 71104) ctrlSetText format[localize "STR_Leboncoin_Btn_PublishAnnonce", [_price] call life_fnc_numberText];
(_display displayCtrl 71140) ctrlSetText([_price, 3, ""] call life_fnc_numberText);
(_display displayCtrl 71137) ctrlAddEventHandler["CheckedChanged", {
    private["_display", "_price"];
    _display = findDisplay 71300;
    _price = parseNumber(ctrlText((findDisplay 71300) displayCtrl 71140));
    if ((_this # 1) isEqualTo 1) then {
        _price = _price + getNumber(MACRO_CREATE_CONFIG >> "extraUrgent");
    } else {
        _price = _price - getNumber(MACRO_CREATE_CONFIG >> "extraUrgent");
    };
    (_display displayCtrl 71140) ctrlSetText([_price, 3, ""] call life_fnc_numberText);
    (_display displayCtrl 71104) ctrlSetText format[localize "STR_Leboncoin_Btn_PublishAnnonce", [_price] call life_fnc_numberText];
}];
(_display displayCtrl 71104) ctrlAddEventHandler["ButtonClick", {
    [] spawn {
        private["_display", "_title", "_description", "_price", "_priority"];
        _display = findDisplay 71300;
        if (_display isEqualTo displayNull) exitWith {};
        _title = ctrlText 71131;
        if ((count _title) < 3) exitWith {
            [localize "STR_Leboncoin_Err_TitleEmpty", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        _description = ctrlText 71139;
        if ((count _description) < 5) exitWith {
            [localize "STR_Leboncoin_Err_MsgEmpty", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        _price = (ctrlText 71135);
        if ((count _price) isEqualTo 0) exitWith {
            [localize "STR_Leboncoin_Err_PriceEmpty", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        if (!([_price] call TON_fnc_isnumber)) exitWith {
            [localize "STR_Leboncoin_Err_NaN", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        if ((parseNumber _price) > 100000000) exitWith {
            [localize "STR_Leboncoin_Err_NaN", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        if ((parseNumber(ctrlText 71140)) > BANK) exitWith {
            [localize "STR_Leboncoin_Err_DontHaveMoney", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        _priority =
        if (cbChecked(_display displayCtrl 71137)) then[{
            1
        }, {
            0
        }];
        ((findDisplay 71300) displayCtrl 71104) ctrlEnable false;
        if (life_HC_isActive) then {
            [player, getPlayerUID player, _title, ((_display displayCtrl 71133) lbValue(lbCurSel(_display displayCtrl 71133))), (ctrlText 71141), _description, (parseNumber _price), _priority] remoteExec["HC_Poltich_fnc_Leboncoin_CreateAnnonce", HC_Life];
        } else {
            [getPlayerUID player, _title, ((_display displayCtrl 71133) lbValue(lbCurSel(_display displayCtrl 71133))), (ctrlText 71141), _description, (parseNumber _price), _priority] remoteExec["SRV_Poltich_fnc_Leboncoin_CreateAnnonce", RSERV];
        };
    };
}];