#include "..\..\..\script_macros.hpp"
# define MACRO_CONFIG missionConfigFile >> "Poltich_Config_Leboncoin"
# define MACRO_EDIT_CONFIG MACRO_CONFIG >> "edit"
private["_display", "_categoriesList", "_categorySelected", "_i", "_price", "_withPhoto", "_title", "_message", "_customName"];
params[["_annonce", [],
    [
        []
    ]
]];
if !(isNull findDisplay 71400) exitWith {};
if !(isNull findDisplay 71200) then {
    closeDialog 0;
};
if !(isNull findDisplay 71000) then {
    closeDialog 0;
};
if (_annonce isEqualTo[]) exitWith {
    [localize "STR_Leboncoin_Err_SrvBadTransmission", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
disableSerialization;
createDialog "Poltich_Leboncoin_EditAnnonce";
waitUntil {
    !isNull findDisplay 71400
};
_display = findDisplay 71400;
(_display displayCtrl 260120) ctrlSetText(call the_programmer_iphone_xi_fnc_functions_getIphoneColor);
(_display displayCtrl 260121) ctrlSetText "\IphoneXI_Assets\menus\apps\leboncoin.paa";
[_display, (_display displayCtrl 260122)] spawn the_programmer_iphone_xi_fnc_functions_displayCurrentHour;
_annonce params[["_annonceId", -1, [0]], ["_annonceTitle", "", [""]], ["_annonceImg", "", [""]], ["_annonceCategory", -1, [0]], ["_annoncePrice", 0, [0]], ["_annoncePriority", 0, [0]], ["_annonceCreatedAt", [],
    [
        []
    ]
], ["_annonceUpdatedAt", [],
    [
        [], ""]
], ["_annonceDescription", "", [""]], ["_annonceAuthorName", "", [""]], ["_annonceAuthorPid", "", [""]], ["_annonceAuthorPhoneNumber", "", [""]], ["_annonceAuthorEmailBoxAddress", "", [""]]];
_categoriesList = _display displayCtrl 71133;
_categorySelected = 0; {
    _i = _categoriesList lbAdd(_x # 1);
    _categoriesList lbSetValue[_i, (_x # 0)];
    if ((_x # 0) isEqualTo _annonceCategory) then {
        _categorySelected = _i;
    };
}
forEach(getArray(MACRO_CONFIG >> "categories"));
_categoriesList lbSetCurSel _categorySelected;
_price = getNumber(MACRO_EDIT_CONFIG >> "price");
_withPhoto = "sans";
if (_annonceImg isNotEqualTo "") then {
    if (fileExists _annonceImg) then {
        _withPhoto = "avec";
    } else {
        if (getText(configFile >> "CfgVehicles" >> _annonceImg >> "editorPreview") isNotEqualTo "") then {
            _withPhoto = "avec";
        };
    };
};
(_display displayCtrl 71105) ctrlSetStructuredText parseText format[localize "STR_Leboncoin_Txt_EditAnnonce", _withPhoto];
(_display displayCtrl 71131) ctrlSetText _annonceTitle;
(_display displayCtrl 71139) ctrlSetText _annonceDescription;
(_display displayCtrl 71135) ctrlSetText([_annoncePrice, 3, ""] call life_fnc_numberText);
(_display displayCtrl 71137) cbSetChecked(_annoncePriority isEqualTo 1);
(_display displayCtrl 71137) ctrlSetTooltip format[localize "STR_Leboncoin_Txt_InfoUrgentCreateAnnonce", getNumber(MACRO_CONFIG >> "urgentDays"), getNumber(MACRO_EDIT_CONFIG >> "extraUrgent")];
(_display displayCtrl 71104) ctrlSetText format[localize "STR_Leboncoin_Btn_EditAnnonce", [_price] call life_fnc_numberText];
(_display displayCtrl 71140) ctrlSetText([_price, 3, ""] call life_fnc_numberText);
(_display displayCtrl 71141) ctrlSetText([_annonceId, 3, ""] call life_fnc_numberText);
(_display displayCtrl 71142) ctrlSetText str(_annoncePriority);
(_display displayCtrl 71137) ctrlAddEventHandler["CheckedChanged", {
    private["_display", "_price"];
    _display = findDisplay 71400;
    _price = parseNumber(ctrlText((findDisplay 71400) displayCtrl 71140));
    if ((_this # 1) isEqualTo 1) then {
        _price = _price + getNumber(MACRO_EDIT_CONFIG >> "extraUrgent");
    } else {
        if (parseNumber(ctrlText((findDisplay 71400) displayCtrl 71142)) isEqualTo - 1) then {
            _price = _price - getNumber(MACRO_EDIT_CONFIG >> "extraUrgent");
        };
    };
    (_display displayCtrl 71140) ctrlSetText([_price, 3, ""] call life_fnc_numberText);
    (_display displayCtrl 71142) ctrlSetText str(-1);
    (_display displayCtrl 71104) ctrlSetText format[localize "STR_Leboncoin_Btn_EditAnnonce", [_price] call life_fnc_numberText];
}];
(_display displayCtrl 71104) ctrlAddEventHandler["ButtonClick", {
    [] spawn {
        private["_display", "_title", "_description", "_price", "_priority"];
        _display = findDisplay 71400;
        if (_display isEqualTo displayNull) exitWith {};
        _title = ctrlText 71131;
        if ((count _title) < 3) exitWith {
            [localize "STR_Leboncoin_Err_TitleEmpty", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        _description = ctrlText 71139;
        if ((count _description) < 5) exitWith {
            [localize "STR_Leboncoin_Err_MsgEmpty", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        _price = (ctrlText 71135);
        if ((count _price) isEqualTo 0) exitWith {
            [localize "STR_Leboncoin_Err_PriceEmpty", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        if (!([_price] call TON_fnc_isnumber)) exitWith {
            [localize "STR_Leboncoin_Err_NaN", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        if ((parseNumber _price) > 100000000) exitWith {
            [localize "STR_Leboncoin_Err_NaN", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        if ((parseNumber(ctrlText 71140)) > BANK) exitWith {
            [localize "STR_Leboncoin_Err_DontHaveMoney", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        _priority =
        if (cbChecked(_display displayCtrl 71137)) then[{
            1
        }, {
            0
        }];
        ((findDisplay 71400) displayCtrl 71104) ctrlEnable false;
        if (life_HC_isActive) then {
            [player, getPlayerUID player, parseNumber(ctrlText 71141), _title, ((_display displayCtrl 71133) lbValue(lbCurSel(_display displayCtrl 71133))), _description, (parseNumber _price), _priority, parseNumber(ctrlText((findDisplay 71400) displayCtrl 71142)) isEqualTo - 1] remoteExec["HC_Poltich_fnc_Leboncoin_EditAnnonce", HC_Life];
        } else {
            [getPlayerUID player, parseNumber(ctrlText 71141), _title, ((_display displayCtrl 71133) lbValue(lbCurSel(_display displayCtrl 71133))), _description, (parseNumber _price), _priority, parseNumber(ctrlText((findDisplay 71400) displayCtrl 71142)) isEqualTo - 1] remoteExec["SRV_Poltich_fnc_Leboncoin_EditAnnonce", RSERV];
        };
    };
}];