#include "..\..\..\script_macros.hpp"
private["_display", "_btnLeave", "_btnJoin", "_hasLicense", "_listLicense", "_maxLicenses", "_inService"];
params[["_license", "", [""]]];
if (_license isEqualTo "" || isNull findDisplay 70100) exitWith {};
_display = findDisplay 70100;
_btnLeave = _display displayCtrl 70110;
_btnJoin = _display displayCtrl 70111;
_inService = player getVariable['inService_global', false];
if (_inService) exitWith {
    [localize "STR_PoleEmploi_Err_ActiveInService", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_hasLicense = missionNamespace getVariable[LICENSE_VARNAME(_license, "civ"), false];
if (_hasLicense) then {
    missionNamespace setVariable[LICENSE_VARNAME(_license, "civ"), false];
    [format[localize "STR_PoleEmploi_Notif_LeaveLicense", (localize M_CONFIG(getText, "Licenses", _license, "displayName"))], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
} else {
    _listLicense = [] call Poltich_fnc_PoleEmploi_getLicense;
    _maxLicenses =
    if (((call life_donorlevel) >= 3) || ((call life_adminlevel) >= 1)) then {
        getNumber(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "maximumLicensesAllowVip")
    } else {
        getNumber(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "maximumLicensesAllow")
    };
    if !((count _listLicense) < _maxLicenses) exitWith {
        [localize "STR_PoleEmploi_Btn_MaxLicenseReach", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    if ((CASH - M_CONFIG(getNumber, "Licenses", _license, "price")) < 0) exitWith {
        [localize "STR_PoleEmploi_Err_DontHaveMoney", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    CASH = CASH - M_CONFIG(getNumber, "Licenses", _license, "price");
    [0] call SOCK_fnc_updatePartial;
    missionNamespace setVariable[LICENSE_VARNAME(_license, "civ"), true];
    [format[localize "STR_PoleEmploi_Notif_JoinLicense", (localize M_CONFIG(getText, "Licenses", _license, "displayName"))], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
};
[2] call SOCK_fnc_updatePartial;
[format["vient %1 la license %2",
if (_hasLicense) then[{
    "de partir de"
}, {
    "d'acheter"
}], _license]] call life_fnc_logs;
_hasLicense = missionNamespace getVariable[LICENSE_VARNAME(_license, "civ"), false];
_btnLeave ctrlShow _hasLicense;
_btnJoin ctrlShow!(_hasLicense);
_btnLeave ctrlSetEventHandler["ButtonClick", format["['%1'] call Poltich_fnc_PoleEmploi_ChangeLicense;", _license]];
_listLicense = [] call Poltich_fnc_PoleEmploi_getLicense;
_maxLicenses =
if (((call life_donorlevel) >= 3) || ((call life_adminlevel) >= 1)) then {
    getNumber(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "maximumLicensesAllowVip")
} else {
    getNumber(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "maximumLicensesAllow")
};
if ((count _listLicense) < _maxLicenses) then {
    _btnJoin ctrlSetText format[localize "STR_PoleEmploi_Btn_JoinLicense", [M_CONFIG(getNumber, "Licenses", _license, "price")] call life_fnc_numberText];
    _btnJoin ctrlSetBackgroundColor[0.2, 0.4, 0.2, 1];
    _btnJoin ctrlEnable true;
    _btnJoin ctrlSetEventHandler["ButtonClick", format["['%1'] call Poltich_fnc_PoleEmploi_ChangeLicense;", _license]];
} else {
    _btnJoin ctrlSetText localize "STR_PoleEmploi_Btn_MaxLicenseReach";
    _btnJoin ctrlSetBackgroundColor[0.8, 0.502, 0.2, 1];
    _btnJoin ctrlEnable false;
    _btnJoin ctrlSetEventHandler["ButtonClick", ""];
};