#include "..\..\..\script_macros.hpp"
private["_display", "_control", "_btnLeave", "_btnJoin", "_data", "_list", "_index", "_id", "_hasLicense", "_listLicense", "_maxLicenses"];
if (isNull findDisplay 70100) exitWith {};
_display = findDisplay 70100;
_btnLeave = _display displayCtrl 70110;
_btnJoin = _display displayCtrl 70111;
_data = _this select 0;
_list = _data select 0;
_index = _data select 1;
_id = (_list lbData _index);
_hasLicense = missionNamespace getVariable[LICENSE_VARNAME(_id, "civ"), false];
_btnLeave ctrlShow _hasLicense;
_btnLeave ctrlSetEventHandler["ButtonClick", format["['%1'] call Poltich_fnc_PoleEmploi_ChangeLicense;", _id]];
_btnJoin ctrlShow!(_hasLicense);
_listLicense = [] call Poltich_fnc_PoleEmploi_getLicense;
_maxLicenses =
if (((call life_donorlevel) >= 3) || ((call life_adminlevel) >= 1)) then {
    getNumber(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "maximumLicensesAllowVip")
} else {
    getNumber(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "maximumLicensesAllow")
};
if ((count _listLicense) < _maxLicenses) then {
    _btnJoin ctrlSetText format[localize "STR_PoleEmploi_Btn_JoinLicense", [M_CONFIG(getNumber, "Licenses", _id, "price")] call life_fnc_numberText];
    _btnJoin ctrlSetBackgroundColor[0.2, 0.4, 0.2, 1];
    _btnJoin ctrlEnable true;
    _btnJoin ctrlSetEventHandler["ButtonClick", format["['%1'] call Poltich_fnc_PoleEmploi_ChangeLicense;", _id]];
} else {
    _btnJoin ctrlSetText localize "STR_PoleEmploi_Btn_MaxLicenseReach";
    _btnJoin ctrlSetBackgroundColor[0.8, 0.502, 0.2, 1];
    _btnJoin ctrlEnable false;
    _btnJoin ctrlSetEventHandler["ButtonClick", ""];
};
(_display displayCtrl 70102) ctrlSetStructuredText parseText((getText(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "Emplois" >> _id >> "description")) + "<br/><br/>" + format[localize "STR_PoleEmploi_LicensePrice", [M_CONFIG(getNumber, "Licenses", _id, "price")] call life_fnc_numberText]);
(_display displayCtrl 70103) ctrlSetText(getText(missionConfigFile >> "Poltich_Config_PoleEmploi" >> "Emplois" >> _id >> "imageBanner"));