#include "..\..\..\script_macros.hpp"
private["_display", "_ui", "_progressBar", "_titleText"];
private["_title", "_cP", "_cpRate", "_playerPos", "_sleepTime"];
private["_tmpMagazine", "_magazineIdx", "_allMagazines", "_magazineName", "_ammoCount", "_repackResumeMsg", "_magazineCfg", "_magazineAmmo", "_quantity"];
private["_repackInfo", "_repackClassname", "_repackNbAmmo", "_nbMagazines", "_hasMagNotFilled", "_magazinesSelected", "_magazinesAfterRepack", "_timeToRepack"];
_display = findDisplay 82000;
if (_display isEqualTo displayNull) exitWith {};
_repackInfo = [] call Davidovitch_fnc_RepackMagazine_GetRepackInfo;
_repackInfo params["_repackClassname", "_repackNbAmmo", "_nbMagazines", "_hasMagNotFilled", "_magazinesSelected", "_magazinesAfterRepack", "_timeToRepack"];
life_action_inUse = true;
closeDialog 0;
[player, localize "STR_Bubble_NOTF_RepackMagazines", "Action"] call Rosenbach_fnc_Bubble_Display;
disableSerialization;
_title = localize "STR_RepackMagazine_GUI_Progress_Title_Repack";
"progressBar"
cutRsc["life_progress", "PLAIN"];
_ui = uiNamespace getVariable "life_progress";
_progressBar = _ui displayCtrl 38201;
_titleText = _ui displayCtrl 38202;
_titleText ctrlSetText format["%2 (1%1)...", "%", _title];
_progressBar progressSetPosition 0.01;
_cP = 0.01;
_cpRate = 0.01;
_playerPos = getPos player;
_sleepTime = _timeToRepack / 100;
life_interrupted = false;
for "_i"
from 0 to 1 step 0 do {
    if (animationState player != "AinvPknlMstpSnonWnonDnon_medic_1") then {
        [player, "AinvPknlMstpSnonWnonDnon_medic_1", true] remoteExecCall["life_fnc_animSync", RCLIENT];
        player switchMove "AinvPknlMstpSnonWnonDnon_medic_1";
        player playMoveNow "AinvPknlMstpSnonWnonDnon_medic_1";
    };
    uiSleep _sleepTime;
    if (isNull _ui) then {
        "progressBar"
        cutRsc["life_progress", "PLAIN"];
        _ui = uiNamespace getVariable "life_progress";
    };
    _cP = _cP + _cpRate;
    _progressBar progressSetPosition _cP;
    _titleText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _title];
    if (_cP >= 1 || !alive player) exitWith {};
    if !(isNull objectParent player) exitWith {
        life_interrupted = true;
    };
    if (player distance _playerPos > 2) exitWith {
        life_interrupted = true
    };
    if (life_istazed) exitWith {};
    if (life_isknocked) exitWith {};
    if (player getVariable["restrained", false]) exitWith {};
    if (life_interrupted) exitWith {};
};
"progressBar" cutText ["", "PLAIN"];
player playActionNow "stop";
life_action_inUse = false;
if (!alive player || life_istazed || life_isknocked) exitWith {
    titleText[localize "STR_NOTF_ActionCancel", "PLAIN"];
};
if (player getVariable["restrained", false]) exitWith {
    titleText[localize "STR_NOTF_ActionCancel", "PLAIN"];
};
if (life_interrupted) exitWith {
    life_interrupted = false;
    titleText[localize "STR_NOTF_ActionCancel", "PLAIN"];
};
_tmpMagazine = [];
_magazineIdx = -1;
_allMagazines = (magazinesAmmo player) select {
    (_x select 0) isEqualTo _repackClassname
}; {
    _tmpMagazine = _x;
    _magazineIdx = _allMagazines findIf {
        _x isEqualTo _tmpMagazine
    };
    if (_magazineIdx isEqualTo - 1) then {
        continue;
    };
    _allMagazines deleteAt _magazineIdx;
}
forEach _magazinesSelected;
player removeMagazines _repackClassname;
_allMagazines append _magazinesAfterRepack; {
    _x params["_magazineName", "_ammoCount"];
    player addMagazine[_magazineName, _ammoCount];
}
forEach _allMagazines;
_repackResumeMsg = [localize "STR_RepackMagazine_SuccessRepack"];
_magazineCfg = configFile >> "CfgMagazines" >> _repackClassname; {
    _x params["_magazineAmmo", "_quantity"];
    _magazineAmmo params["", "_ammoCount"];
    _repackResumeMsg pushBack "<br/>";
    _repackResumeMsg pushBack format["%4x %1 (%2/%3)", getText(_magazineCfg >> "displayName"), _ammoCount, getNumber(_magazineCfg >> "count"), _quantity];
}
forEach(_magazinesAfterRepack call BIS_fnc_consolidateArray);
[(_repackResumeMsg joinString ""), "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;