private["_display", "_lbSelectedIdx", "_magazinesToRepackLb", "_magazinesAfterRepackLb", "_playerMagazinesLb", "_repackBtn"];
private["_data", "_selectedMagazineAmmo", "_selectedMagQuantity", "_selectedMagazineClassname", "_tmpData", "_firstSelectedMag", "_firstSelectedMagQuantity"];
private["_magExistInList", "_magToRepackData", "_lbMagToRepackIdx", "_repackInfo", "_magazinesAfterRepack", "_timeToRepack"];
params["", ["_lbSelectedIdx", -1, [0]]];
_display = findDisplay 82000;
if (_display isEqualTo displayNull) exitWith {};
_playerMagazinesLb = _display displayCtrl 82001;
_magazinesToRepackLb = _display displayCtrl 82002;
_magazinesAfterRepackLb = _display displayCtrl 82003;
_repackBtn = _display displayCtrl 82010;
_repackBtn ctrlEnable false;
_repackBtn ctrlSetText format[localize "STR_RepackMagazine_GUI_Btn_Repack", 0];
lbClear _magazinesAfterRepackLb;
_data = parseSimpleArray(_playerMagazinesLb lbData _lbSelectedIdx);
_data params["_selectedMagazineAmmo", "_selectedMagQuantity"];
_selectedMagazineAmmo params["_selectedMagazineClassname", ""];
_magExistInList = [_magazinesToRepackLb, _selectedMagazineAmmo] call Davidovitch_fnc_RepackMagazine_GetMagIdxInLb;
_magExistInList params["_lbMagToRepackIdx", "_magToRepackData"];
if (_lbMagToRepackIdx > -1) then {
    [_magazinesToRepackLb, _lbMagToRepackIdx, [(_magToRepackData # 0), ((_magToRepackData # 1) + _selectedMagQuantity)]] call Davidovitch_fnc_RepackMagazine_LbUpdate;
} else {
    [_magazinesToRepackLb, _data] call Davidovitch_fnc_RepackMagazine_LbAdd;
};
_playerMagazinesLb lbDelete _lbSelectedIdx;
if ((lbSize _playerMagazinesLb) >= 1) then {
    for "_playerMagazinesLbIdx"
    from((lbSize _playerMagazinesLb) - 1) to 0 step - 1 do {
        _tmpData = parseSimpleArray(_playerMagazinesLb lbData _playerMagazinesLbIdx);
        if (((_tmpData select 0) select 0) isNotEqualTo _selectedMagazineClassname) then {
            _playerMagazinesLb lbDelete _playerMagazinesLbIdx;
        };
    };
};
_firstSelectedMag = parseSimpleArray(_magazinesToRepackLb lbData 0);
_firstSelectedMag params["", "_firstSelectedMagQuantity"];
_canRepack = (lbSize _magazinesToRepackLb) >= 2 || (_firstSelectedMagQuantity > 1);
if (_canRepack) then {
    _repackInfo = [] call Davidovitch_fnc_RepackMagazine_GetRepackInfo;
    _repackInfo params["", "", "", "", "", "_magazinesAfterRepack", "_timeToRepack"];
    _repackBtn ctrlEnable true;
    _repackBtn ctrlSetText format[localize "STR_RepackMagazine_GUI_Btn_Repack", _timeToRepack]; {
        [_magazinesAfterRepackLb, _x] call Davidovitch_fnc_RepackMagazine_LbAdd;
    }
    forEach(_magazinesAfterRepack call BIS_fnc_consolidateArray);
};