# define NB_MAG_TO_SWITCH 1
private["_display", "_lbSelectedIdx", "_playerMagazinesLb", "_magazinesToRepackLb", "_magazinesAfterRepackLb", "_repackBtn"];
private["_data", "_selectedMagazineAmmo", "_selectedMagQuantity", "_magExistInList", "_lbPlayerMagIdx", "_playerMagazinesData"];
private["_canRepack", "_magazinesToRepack", "_firstSelectedMag", "_firstSelectedMagQuantity", "_repackInfo", "_magazinesAfterRepack", "_timeToRepack"];
params["", ["_lbSelectedIdx", -1, [0]]];
_display = findDisplay 82000;
if (_display isEqualTo displayNull) exitWith {};
_playerMagazinesLb = _display displayCtrl 82001;
_magazinesToRepackLb = _display displayCtrl 82002;
_magazinesAfterRepackLb = _display displayCtrl 82003;
_repackBtn = _display displayCtrl 82010;
_repackBtn ctrlEnable false;
_repackBtn ctrlSetText format[localize "STR_RepackMagazine_GUI_Btn_Repack", 0];
lbClear _magazinesAfterRepackLb;
_data = parseSimpleArray(_magazinesToRepackLb lbData _lbSelectedIdx);
_data params["_selectedMagazineAmmo", "_selectedMagQuantity"];
_selectedMagazineAmmo params["_selectedMagazineClassname", ""];
_magExistInList = [_playerMagazinesLb, _selectedMagazineAmmo] call Davidovitch_fnc_RepackMagazine_GetMagIdxInLb;
_magExistInList params["_lbPlayerMagIdx", "_playerMagazinesData"];
if (_selectedMagQuantity > NB_MAG_TO_SWITCH) then {
    [_magazinesToRepackLb, _lbSelectedIdx, [_selectedMagazineAmmo, (_selectedMagQuantity - NB_MAG_TO_SWITCH)]] call Davidovitch_fnc_RepackMagazine_LbUpdate;
} else {
    _magazinesToRepackLb lbDelete _lbSelectedIdx;
};
if (_lbPlayerMagIdx > -1) then {
    [_playerMagazinesLb, _lbPlayerMagIdx, [(_playerMagazinesData # 0), ((_playerMagazinesData # 1) + NB_MAG_TO_SWITCH)]] call Davidovitch_fnc_RepackMagazine_LbUpdate;
} else {
    if ((lbSize _magazinesToRepackLb) > 0) then {
        [_playerMagazinesLb, [_selectedMagazineAmmo, NB_MAG_TO_SWITCH]] call Davidovitch_fnc_RepackMagazine_LbAdd;
    };
};
if ((lbSize _magazinesToRepackLb) isEqualTo 0) exitWith {
    _magazinesToRepack = [] call Davidovitch_fnc_RepackMagazine_GetPlayerMags;
    [_magazinesToRepack] call Davidovitch_fnc_RepackMagazine_InitPlayerMagsLb;
};
_firstSelectedMag = parseSimpleArray(_magazinesToRepackLb lbData 0);
_firstSelectedMag params["", "_firstSelectedMagQuantity"];
_canRepack = (lbSize _magazinesToRepackLb) >= 2 || (_firstSelectedMagQuantity > 1);
if (_canRepack) then {
    _repackInfo = [] call Davidovitch_fnc_RepackMagazine_GetRepackInfo;
    _repackInfo params["", "", "", "", "", "_magazinesAfterRepack", "_timeToRepack"];
    _repackBtn ctrlEnable true;
    _repackBtn ctrlSetText format[localize "STR_RepackMagazine_GUI_Btn_Repack", _timeToRepack]; {
        [_magazinesAfterRepackLb, _x] call Davidovitch_fnc_RepackMagazine_LbAdd;
    }
    forEach(_magazinesAfterRepack call BIS_fnc_consolidateArray);
};