if (missionNamespace getVariable["A4L_scnrInUse", false] == true) exitWith {
    [localize "STR_Scenarios_Pompiers_Err_ScriptRun", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
A4L_scnrName = "barn_fire";
A4L_configPath = missionConfigFile >> "Rosenbach_Config_Scenario_Pompiers" >> "scnr" >> A4L_scnrName;
A4L_scnrModelsClassNames = getArray(A4L_configPath >> "whitelistObject");
A4L_scnrProgression = getArray(A4L_configPath >> "objectifs");
A4L_scnrProgressionText = getArray(A4L_configPath >> "objectifsText");
A4L_scnrBuildingPos = selectRandom(getArray(A4L_configPath >> "whitelistPos"));
A4L_scnrBuilding = nearestObjects[A4L_scnrBuildingPos, A4L_scnrModelsClassNames, 20];
if (count A4L_scnrBuilding < 1) exitWith {
    [localize "STR_Scenarios_Pompiers_Err_BuildingNotFound", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
A4L_scnrBuilding = A4L_scnrBuilding select 0;
A4L_scnrLocationName = text([getPos A4L_scnrBuilding] call life_fnc_nearestCity);
A4L_scnrInUse = true;
A4L_scnrUIDOwner = getPlayerUID player;
A4L_scnrParticles = [];
A4L_scnrObjects = [];
A4L_scnrActions = [];
A4L_scnrEvent = nil;
A4L_scnrShowInfo = false;
A4L_scnrSharedVariables = [false];
A4L_scnrProgressionBackup = +A4L_scnrProgression;
missionNamespace setVariable["A4L_scnrInUse", A4L_scnrInUse, true];
missionNamespace setVariable["A4L_scnrName", A4L_scnrName, true];
missionNamespace setVariable["A4L_scnrSharedVariables", A4L_scnrSharedVariables, true];
missionNamespace setVariable["A4L_scnrUIDOwner", A4L_scnrUIDOwner, true];
missionNamespace setVariable["A4L_scnrBuilding", A4L_scnrBuilding, true];
missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
missionNamespace setVariable["A4L_scnrObjects", A4L_scnrObjects, true];
private _scnrBriefingText = selectRandom(getArray(A4L_configPath >> "scnrTextBriefing"));
hint parseText format["<img size='5' image='\a3\ui_f\data\gui\cfg\hints\Rules_ca.paa'/><br/>
	<t size='2.0' color='#FFB200'>Briefing</t><br/><t size='0.8' color='#FFFFFF'>***************************</t><br/>
	<t color='#FFB200' align='left'>Emplacement : </t><t color='#FFFFFF' align='right'>%1</t><br/>
	<t color='#FFB200' align='left'>Type : </t><t color='#FFFFFF' align='right'>Feu de grange</t><br/>
	<t color='#FFB200' align='left'>Origine : </t><t color='#FFFFFF' align='right'>Inconnu</t><br/>
	<t size='0.8' color='#FFFFFF'>***************************</t><br/>
	<t size='1' align='left'>%2</t><br/>
	<t size='0.8'>***************************</t><br/>
	<t color='#FFB200' align='left'>- </t><t color='#FFFFFF'>Maîtriser les flammes.</t><br/>
	<t color='#FFB200' align='left'>- </t><t color='#FFFFFF'>Mettre en sécurité la bouteille de gaz.</t><br/>", A4L_scnrLocationName, _scnrBriefingText];
A4L_fn_checkProgression = {
    private["_event", "_index", "_finishText", "_destructScnr"];
    _event = _this select 0;
    _finishText = "";
    if (_event in A4L_scnrProgression) then {
        A4L_scnrProgression deleteAt(A4L_scnrProgression find _event);
        ["TaskSucceeded", ["", A4L_scnrProgressionText select(A4L_scnrProgressionBackup find _event)]] call BIS_fnc_showNotification;
        "A4L_scnrProgression";
        if (count A4L_scnrProgression == 0) then {
            _finishText = "<t size='0.8' color='#FFFFFF'>***************************</t><br/>
				<t size='1' align='center'>Vous pouvez maintenant terminer le scénario.<br><br>Attention ! Cette action supprime l'ensemble des objets et effets.</t>";
            _destructScnr = player addAction["<t color='#25CA00'>Terminer scénario</t>", {
                params["_target", "_caller", "_actionId", "_arguments"];
                [A4L_scnrActions, A4L_scnrObjects, A4L_scnrBuilding, A4L_scnrParticles, A4L_scnrEvent] call Rosenbach_fnc_ScnrPompiers_destructScnr;
                _target removeAction _actionId;
            }, nill, 1, true, true, "", "A4L_scnrShowInfo == true"];
            A4L_scnrActions pushBack _destructScnr;
        };
    };
    if (_event == "showHintStatut" || count A4L_scnrProgression == 0) then {
        private["_objectif_1", "_objectif_2", "_objectif_3"];
        if (A4L_scnrProgression find "fire_1" == -1) then {
            _objectif_1 = "<img size='1.3' align='left' color='#25CA00' image='\a3\modules_f\data\icontasksetstate_ca.paa'/>";
        } else {
            _objectif_1 = "<img size='1.3' align='left' color='#7E7E7E' image='\a3\modules_f\data\icontasksetdescription_ca.paa'/>";
        };
        if (A4L_scnrProgression find "fire_2" == -1) then {
            _objectif_2 = "<img size='1.3' align='left' color='#25CA00' image='\a3\modules_f\data\icontasksetstate_ca.paa'/>";
        } else {
            _objectif_2 = "<img size='1.3' align='left' color='#7E7E7E' image='\a3\modules_f\data\icontasksetdescription_ca.paa'/>";
        };
        if (A4L_scnrProgression find "gasTank" == -1) then {
            _objectif_3 = "<img size='1.3' align='left' color='#25CA00' image='\a3\modules_f\data\icontasksetstate_ca.paa'/>";
        } else {
            _objectif_3 = "<img size='1.3' align='left' color='#7E7E7E' image='\a3\modules_f\data\icontasksetdescription_ca.paa'/>";
        };
        hint parseText format["<img size='5' image='\a3\ui_f\data\gui\cfg\hints\Tasks_ca.paa'/><br/>
			<t size='2.0' color='#FFB200'>Update</t><br/><t size='0.8' color='#FFFFFF'>***************************</t><br/>
			<t color='#FFB200' align='left'>Emplacement : </t><t color='#FFFFFF' align='right'>%1</t><br/>
			<t color='#FFB200' align='left'>Type : </t><t color='#FFFFFF' align='right'>Feu de toiture</t><br/>
			<t color='#FFB200' align='left'>Origine : </t><t color='#FFFFFF' align='right'>Inconnu</t><br/>
			<t size='0.8' color='#FFFFFF'>***************************</t><br/>
			%2<t color='#FFFFFF' align='left'>Maîtriser feu n°1</t><br/>
			%3<t color='#FFFFFF' align='left'>Maîtriser feu n°2</t><br/>
			%4<t color='#FFFFFF' align='left'>Mettre en sécurité la bouteille de gaz.</t><br/>%8", A4L_scnrLocationName, _objectif_1, _objectif_2, _objectif_3, A4L_scnrProgressionText select 0, A4L_scnrProgressionText select 1, A4L_scnrProgressionText select 2, _finishText];
    };
};
format["|marker_scnr|%1|mil_warning|ICON|[1,1]|0|Solid|ColorRed|1| Incendie : Tenez vos distances", getPos A4L_scnrBuilding] call BIS_fnc_stringToMarker;
private["_gazPos", "_gazObj", "_fire_1", "_fire_2", "_separator", "_fire_1_act", "_fire_2_act", "_gazTankExplosion_act", "_infoHintOn", "_infoHintOff", "_showInfoHint", "_drawHandler"];
_showInfoHint = false;
_gazPos = getArray(A4L_configPath >> "objects" >> "gazTankObject" >> "position");
_gazObj = "Land_GasTank_01_blue_F"
createVehicle(A4L_scnrBuilding modelToWorld _gazPos);
_gazObj enableSimulation false;
[_gazObj, false] remoteExec["enableSimulationGlobal", 2];
_gazObj setPos(A4L_scnrBuilding modelToWorld _gazPos);
A4L_scnrObjects pushBack _gazObj;
[_gazObj, ["Prendre", {
    params["_target", "_caller", "_actionId", "_arguments"];
    private _sharedVariables = missionNamespace getVariable "A4L_scnrSharedVariables";
    _target attachTo[_caller, [0.07, 0, -0.15], "righthand"];
    _target setDir - 15;
    _target setPos[0.07, 0, -0.15];
    _caller forceWalk true;
    hint "Deplacer la bouteille de gaz hors du batiment.";
    _sharedVariables set[0, true];
    missionNamespace setVariable["A4L_scnrSharedVariables", _sharedVariables, true];
    _target removeAction _actionId;
    _caller addAction["Poser l'objet", {
        params["_target", "_caller", "_actionId", "_arguments"];
        detach _arguments;
        _arguments setPos(_caller modelToWorld[0, 0.75, 0]);
        _caller forceWalk false;
        _caller removeAction _actionId;
    }, _target, 1.5, true, true, "", "(missionNamespace getVariable['A4L_scnrSharedVariables', [false]] select 0) == true && (player distance (missionNamespace getVariable 'A4L_scnrBuilding')) > 15"];
},
nil, 1.5, true, true, "", "(missionNamespace getVariable['A4L_scnrSharedVariables', [false]] select 0) == false", 2]] remoteExec["addAction", 0, true]; {
    private _particleName = _x; {
        [_particleName, A4L_scnrBuilding, [_x select 1, _x select 2, _x select 3], _x select 0] remoteExec["Rosenbach_fnc_ScnrPompiers_createParticleEffect"];
    }
    forEach getArray(A4L_configPath >> "particles" >> _particleName >> "position");
    A4L_scnrParticles pushBackUnique _x;
}
forEach["fire_1", "fire_2", "smoke_1"];
missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
missionNamespace setVariable["A4L_scnrObjects", A4L_scnrObjects, true];
_separator = player addAction[format["<t color='#FFB200'>- [Scénario : %1] -</t>", A4L_scnrLocationName], {
    params["_target", "_caller", "_actionId", "_arguments"];
    ["showHintStatut"] call A4L_fn_checkProgression;
}, nil, 1, true, false];
_infoHintOn = player addAction["[HRP] Commandes : On", {
    params["_target", "_caller", "_actionId", "_arguments"];
    A4L_scnrShowInfo = true;
}, nil, 1, true, true, "", "A4L_scnrShowInfo == false"];
_infoHintOff = player addAction["<t color='#FF0000'>[HRP] Commandes : Off</t>", {
    params["_target", "_caller", "_actionId", "_arguments"];
    A4L_scnrShowInfo = false;
    hintSilent "";
}, nil, 1, true, true, "", "A4L_scnrShowInfo == true"];
_fire_1_act = player addAction["Eteindre n°1", {
    params["_target", "_caller", "_actionId", "_arguments"];
    ["fire_1", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
    ["fire_1"] call A4L_fn_checkProgression;
    A4L_scnrParticles deleteAt(A4L_scnrParticles find "fire_1");
    missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
    _target removeAction _actionId;
}, nil, 1, true, true, "", "A4L_scnrShowInfo == true"];
_fire_2_act = player addAction["Eteindre n°2", {
    params["_target", "_caller", "_actionId", "_arguments"];
    ["fire_2", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
    ["fire_2"] call A4L_fn_checkProgression;
    A4L_scnrParticles deleteAt(A4L_scnrParticles find "fire_2");
    missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
    _target removeAction _actionId;
}, nil, 1, true, true, "", "A4L_scnrShowInfo == true"];
_gazTankExplosion_act = player addAction["[Opt.] Explosion bouteille de gaz", {
    params["_target", "_caller", "_actionId", "_arguments"];
    private _scriptedCharge = createVehicle["Bo_GBU12_LGB", (getPos(A4L_scnrObjects select 0)), [], 0, "CAN_COLLIDE"];
    _scriptedCharge setDamage 1;
    A4L_scnrBuilding setDamage 1;
    A4L_scnrObjects pushBack _scriptedCharge;
    missionNamespace setVariable["A4L_scnrObjects", A4L_scnrObjects, true];
    A4L_scnrProgression deleteAt(A4L_scnrProgression find "gasTank");
    deleteVehicle(A4L_scnrObjects select 0);
    _target removeAction(_arguments select 0);
    _target removeAction(_arguments select 1);
    if ("fire_1" in A4L_scnrParticles) then {
        ["fire_1", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
        A4L_scnrParticles deleteAt(A4L_scnrParticles find "fire_1");
        ["fire_1"] call A4L_fn_checkProgression;
    };
    if ("fire_2" in A4L_scnrParticles) then {
        ["fire_2", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
        A4L_scnrParticles deleteAt(A4L_scnrParticles find "fire_2");
        ["fire_2"] call A4L_fn_checkProgression;
    };
    ["smoke_1", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
    _target removeAction _actionId;
}, [_fire_1_act, _fire_2_act], 1, true, true, "", "A4L_scnrShowInfo == true && (player distance A4L_scnrBuilding) < 90"];
A4L_scnrActions append[_fire_1_act, _fire_2_act, _gazTankExplosion_act, _separator, _infoHintOn, _infoHintOff];
A4L_scnrEvent = addMissionEventHandler["Draw3D", {
    if (A4L_scnrShowInfo == true && player distance2D A4L_scnrBuilding < 200) then {
        if (A4L_scnrProgression find "fire_1" != -1) then {
            drawIcon3D["\a3\ui_f\data\gui\cfg\hints\Injury_ca.paa", [1, 0, 0, 1], A4L_scnrBuilding modelToWorld[3.87939, 2.64966, -0.714195], 1, 1, 0, "Feu n°1", 1, 0.05, "PuristaMedium"];
        };
        if (A4L_scnrProgression find "fire_2" != -1) then {
            drawIcon3D["\a3\ui_f\data\gui\cfg\hints\Injury_ca.paa", [1, 0, 0, 1], A4L_scnrBuilding modelToWorld[7.06055, 2.52417, -0.766692], 1, 1, 0, "Feu n°2", 1, 0.05, "PuristaMedium"];
        };
        if (A4L_scnrProgression find "gasTank" != -1) then {
            drawIcon3D["\a3\ui_f\data\gui\cfg\hints\ActionMenu_ca.paa", [1, 0, 0, 1], ASLToAGL getPosASL(A4L_scnrObjects select 0), 1, 1, 0, "Déplacer", 1, 0.05, "PuristaMedium"];
        };
    };
    if (A4L_scnrProgression find "gasTank" != -1 && (missionNamespace getVariable["A4L_scnrSharedVariables", [false]] select 0) == true) then {
        ["gasTank"] call A4L_fn_checkProgression;
        player removeAction(A4L_scnrActions select 2);
        missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
    };
}];