if (missionNamespace getVariable["A4L_scnrInUse", false] == true) exitWith {
    [localize "STR_Scenarios_Pompiers_Err_ScriptRun", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
A4L_scnrName = "roof_fire";
A4L_configPath = missionConfigFile >> "Rosenbach_Config_Scenario_Pompiers" >> "scnr" >> A4L_scnrName;
A4L_scnrModelsClassNames = getArray(A4L_configPath >> "whitelistObject");
A4L_scnrProgression = getArray(A4L_configPath >> "objectifs");
A4L_scnrProgressionText = getArray(A4L_configPath >> "objectifsText");
A4L_scnrBuildingPos = selectRandom(getArray(A4L_configPath >> "whitelistPos"));
A4L_scnrBuilding = nearestObjects[A4L_scnrBuildingPos, A4L_scnrModelsClassNames, 10];
if (count A4L_scnrBuilding < 1) exitWith {
    [localize "STR_Scenarios_Pompiers_Err_BuildingNotFound", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
A4L_scnrBuilding = A4L_scnrBuilding select 0;
A4L_scnrLocationName = text([getPos A4L_scnrBuilding] call life_fnc_nearestCity);
A4L_scnrInUse = true;
A4L_scnrUIDOwner = getPlayerUID player;
A4L_scnrParticles = [];
A4L_scnrObjects = [];
A4L_scnrActions = [];
A4L_scnrEvent = nil;
A4L_scnrShowInfo = false;
A4L_scnrSharedVariables = [false];
A4L_scnrProgressionBackup = +A4L_scnrProgression;
missionNamespace setVariable["A4L_scnrInUse", A4L_scnrInUse, true];
missionNamespace setVariable["A4L_scnrName", A4L_scnrName, true];
missionNamespace setVariable["A4L_scnrSharedVariables", A4L_scnrSharedVariables, true];
missionNamespace setVariable["A4L_scnrUIDOwner", A4L_scnrUIDOwner, true];
missionNamespace setVariable["A4L_scnrBuilding", A4L_scnrBuilding, true];
missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
missionNamespace setVariable["A4L_scnrObjects", A4L_scnrObjects, true];
private _scnrBriefingText = selectRandom(getArray(A4L_configPath >> "scnrTextBriefing"));
hint parseText format["<img size='5' image='\a3\ui_f\data\gui\cfg\hints\Rules_ca.paa'/><br/>
	<t size='2.0' color='#FFB200'>Briefing</t><br/><t size='0.8' color='#FFFFFF'>***************************</t><br/>
	<t color='#FFB200' align='left'>Emplacement : </t><t color='#FFFFFF' align='right'>%1</t><br/>
	<t color='#FFB200' align='left'>Type : </t><t color='#FFFFFF' align='right'>Feu de toiture</t><br/>
	<t color='#FFB200' align='left'>Origine : </t><t color='#FFFFFF' align='right'>Inconnu</t><br/>
	<t size='0.8' color='#FFFFFF'>***************************</t><br/>
	<t size='1' align='left'>%2</t><br/>
	<t size='0.8'>***************************</t><br/>
	<t color='#FFB200' align='left'>- </t><t color='#FFFFFF'>Maîtriser les flammes.</t><br/>
	<t color='#FFB200' align='left'>- </t><t color='#FFFFFF'>Disjoncter le tableau électrique.</t><br/>", A4L_scnrLocationName, _scnrBriefingText];
A4L_fn_checkProgression = {
    private["_event", "_index", "_finishText", "_destructScnr"];
    _event = _this select 0;
    _finishText = "";
    if (_event in A4L_scnrProgression) then {
        A4L_scnrProgression deleteAt(A4L_scnrProgression find _event);
        ["TaskSucceeded", ["", A4L_scnrProgressionText select(A4L_scnrProgressionBackup find _event)]] call BIS_fnc_showNotification;
        "A4L_scnrProgression";
        if (count A4L_scnrProgression == 0) then {
            _finishText = "<t size='0.8' color='#FFFFFF'>***************************</t><br/>
				<t size='1' align='center'>Vous pouvez maintenant terminer le scénario.<br><br>Attention ! Cette action supprime l'ensemble des objets et effets.</t>";
            _destructScnr = player addAction["<t color='#25CA00'>Terminer scénario</t>", {
                params["_target", "_caller", "_actionId", "_arguments"];
                [A4L_scnrActions, A4L_scnrObjects, A4L_scnrBuilding, A4L_scnrParticles, A4L_scnrEvent] call Rosenbach_fnc_ScnrPompiers_destructScnr;
                _target removeAction _actionId;
            }, nill, 1, true, true, "", "A4L_scnrShowInfo == true"];
            A4L_scnrActions pushBack _destructScnr;
        };
    };
    if (_event == "showHintStatut" || count A4L_scnrProgression == 0) then {
        private["_objectif_1", "_objectif_2", "_objectif_3"];
        if (A4L_scnrProgression find "fire_1" == -1) then {
            _objectif_1 = "<img size='1.3' align='left' color='#25CA00' image='\a3\modules_f\data\icontasksetstate_ca.paa'/>";
        } else {
            _objectif_1 = "<img size='1.3' align='left' color='#7E7E7E' image='\a3\modules_f\data\icontasksetdescription_ca.paa'/>";
        };
        if (A4L_scnrProgression find "fire_2" == -1) then {
            _objectif_2 = "<img size='1.3' align='left' color='#25CA00' image='\a3\modules_f\data\icontasksetstate_ca.paa'/>";
        } else {
            _objectif_2 = "<img size='1.3' align='left' color='#7E7E7E' image='\a3\modules_f\data\icontasksetdescription_ca.paa'/>";
        };
        if (A4L_scnrProgression find "elecBox" == -1) then {
            _objectif_3 = "<img size='1.3' align='left' color='#25CA00' image='\a3\modules_f\data\icontasksetstate_ca.paa'/>";
        } else {
            _objectif_3 = "<img size='1.3' align='left' color='#7E7E7E' image='\a3\modules_f\data\icontasksetdescription_ca.paa'/>";
        };
        hint parseText format["<img size='5' image='\a3\ui_f\data\gui\cfg\hints\Tasks_ca.paa'/><br/>
			<t size='2.0' color='#FFB200'>Update</t><br/><t size='0.8' color='#FFFFFF'>***************************</t><br/>
			<t color='#FFB200' align='left'>Emplacement : </t><t color='#FFFFFF' align='right'>%1</t><br/>
			<t color='#FFB200' align='left'>Type : </t><t color='#FFFFFF' align='right'>Feu de toiture</t><br/>
			<t color='#FFB200' align='left'>Origine : </t><t color='#FFFFFF' align='right'>Inconnu</t><br/>
			<t size='0.8' color='#FFFFFF'>***************************</t><br/>
			%2<t color='#FFFFFF' align='left'>Maîtriser feu n°1</t><br/>
			%3<t color='#FFFFFF' align='left'>Maîtriser feu n°2</t><br/>
			%4<t color='#FFFFFF' align='left'>Disjoncter le tableau électrique.</t><br/>%8", A4L_scnrLocationName, _objectif_1, _objectif_2, _objectif_3, A4L_scnrProgressionText select 0, A4L_scnrProgressionText select 1, A4L_scnrProgressionText select 2, _finishText];
    };
};
format["|marker_scnr|%1|mil_warning|ICON|[1,1]|0|Solid|ColorRed|1| Incendie : Tenez vos distances", getPos A4L_scnrBuilding] call BIS_fnc_stringToMarker;
private["_elecBoxPos", "_elecBoxObj", "_fire_1", "_fire_2", "_lights", "_separator", "_fire_1_act", "_fire_2_act", "_infoHintOn", "_infoHintOff", "_showInfoHint", "_drawHandler"];
_showInfoHint = false;
_elecBoxPos = selectRandom(getArray(A4L_configPath >> "objects" >> "Land_TransferSwitch_01_F" >> "randomPos"));
_elecBoxObj = "Land_TransferSwitch_01_F"
createVehicle(A4L_scnrBuilding modelToWorld[_elecBoxPos select 0, _elecBoxPos select 1, _elecBoxPos select 2]);
_elecBoxObj attachTo[A4L_scnrBuilding];
_elecBoxObj setDir((getDir A4L_scnrBuilding) + (_elecBoxPos select 3));
detach _elecBoxObj;
_elecBoxObj setPos(A4L_scnrBuilding modelToWorld[_elecBoxPos select 0, _elecBoxPos select 1, _elecBoxPos select 2]);
A4L_scnrObjects pushBack _elecBoxObj;
_elecBoxObj animate["switchposition", 1];
_elecBoxObj animate["light", 1];
_elecBoxObj animate["power_1", 1];
_elecBoxObj animate["power_2", 1];
[_elecBoxObj, ["Disjoncter", {
    params["_target", "_caller", "_actionId", "_arguments"];
    private _sharedVariables = missionNamespace getVariable "A4L_scnrSharedVariables";
    _target animate["switchposition", 0];
    sleep 0.6;
    _target animate["light", 0];
    _target animate["power_1", 0];
    _target animate["power_2", 0];
    _sharedVariables set[0, true];
    missionNamespace setVariable["A4L_scnrSharedVariables", _sharedVariables, true];
},
nil, 1.5, true, true, "", "(missionNamespace getVariable['A4L_scnrSharedVariables', [false]] select 0) == false", 1]] remoteExec["addAction", 0, true]; {
    private _particleName = _x; {
        [_particleName, A4L_scnrBuilding, [_x select 1, _x select 2, _x select 3], _x select 0] remoteExec["Rosenbach_fnc_ScnrPompiers_createParticleEffect"];
    }
    forEach getArray(A4L_configPath >> "particles" >> _particleName >> "position");
    A4L_scnrParticles pushBackUnique _x;
}
forEach["fire_1", "fire_2", "lights"];
missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
missionNamespace setVariable["A4L_scnrObjects", A4L_scnrObjects, true];
_separator = player addAction[format["<t color='#FFB200'>- [Scénario : %1] -</t>", A4L_scnrLocationName], {
    params["_target", "_caller", "_actionId", "_arguments"];
    ["showHintStatut"] call A4L_fn_checkProgression;
}, nil, 1, true, false];
_infoHintOn = player addAction["[HRP] Commandes : On", {
    params["_target", "_caller", "_actionId", "_arguments"];
    A4L_scnrShowInfo = true;
}, nil, 1, true, true, "", "A4L_scnrShowInfo == false"];
_infoHintOff = player addAction["<t color='#FF0000'>[HRP] Commandes : Off</t>", {
    params["_target", "_caller", "_actionId", "_arguments"];
    A4L_scnrShowInfo = false;
    hintSilent "";
}, nil, 1, true, true, "", "A4L_scnrShowInfo == true"];
_fire_1_act = player addAction["Eteindre n°1", {
    params["_target", "_caller", "_actionId", "_arguments"];
    ["fire_1", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
    ["fire_1"] call A4L_fn_checkProgression;
    A4L_scnrParticles deleteAt(A4L_scnrParticles find "fire_1");
    missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
    _target removeAction _actionId;
}, nil, 1, true, true, "", "A4L_scnrShowInfo == true"];
_fire_2_act = player addAction["Eteindre n°2", {
    params["_target", "_caller", "_actionId", "_arguments"];
    ["fire_2", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
    ["fire_2"] call A4L_fn_checkProgression;
    A4L_scnrParticles deleteAt(A4L_scnrParticles find "fire_2");
    missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
    _target removeAction _actionId;
}, nil, 1, true, true, "", "A4L_scnrShowInfo == true"];
A4L_scnrActions append[_fire_1_act, _fire_2_act, _separator, _infoHintOn, _infoHintOff];
A4L_scnrEvent = addMissionEventHandler["Draw3D", {
    if (A4L_scnrShowInfo == true && player distance2D A4L_scnrBuilding < 200) then {
        if (A4L_scnrProgression find "fire_1" != -1) then {
            drawIcon3D["\a3\ui_f\data\gui\cfg\hints\Injury_ca.paa", [1, 0, 0, 1], A4L_scnrBuilding modelToWorld[-9.91113, 2.70117, 1.58326], 1, 1, 0, "Feu n°1", 1, 0.05, "PuristaMedium"];
        };
        if (A4L_scnrProgression find "fire_2" != -1) then {
            drawIcon3D["\a3\ui_f\data\gui\cfg\hints\Injury_ca.paa", [1, 0, 0, 1], A4L_scnrBuilding modelToWorld[1.80859, 2.59863, 1.24497], 1, 1, 0, "Feu n°2", 1, 0.05, "PuristaMedium"];
        };
        if (A4L_scnrProgression find "elecBox" != -1) then {
            drawIcon3D["\a3\ui_f\data\gui\cfg\hints\Use_ca.paa", [1, 0, 0, 1], ASLToAGL getPosASL(A4L_scnrObjects select 0), 1, 1, 0, "Disjoncteur", 1, 0.05, "PuristaMedium"];
        };
    };
    if (A4L_scnrProgression find "elecBox" != -1 && (missionNamespace getVariable["A4L_scnrSharedVariables", [false]] select 0) == true) then {
        ["elecBox"] call A4L_fn_checkProgression;
        A4L_scnrParticles deleteAt(A4L_scnrParticles find "lights");
        missionNamespace setVariable["A4L_scnrParticles", A4L_scnrParticles, true];
        ["lights", A4L_scnrBuilding] remoteExec['Rosenbach_fnc_ScnrPompiers_destructParticleEffect'];
    };
}];