#include "..\..\..\script_macros.hpp"
private["_display", "_config", "_destination", "_sound", "_soundCfg", "_execType", "_execOn", "_execOnVar", "_listDestinationSounds", "_listAvailableSounds", "_exit"];
disableSerialization;
_display = findDisplay 72000;
if (isNull _display) exitWith {};
_listDestinationSounds = _display displayCtrl 72011;
_destination = (_listDestinationSounds) lbData(lbCurSel(_listDestinationSounds));
if (isNil '_destination') exitWith {
    [localize "STR_SpeakerManager_Err_SelectDestSound", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_config = missionConfigFile >> "Poltich_Config_SpeakerManager" >> (str playerSide) >> _destination;
if !(isClass _config) exitWith {
    [localize "STR_SpeakerManager_Err_CfgDestSoundNotFound", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_listAvailableSounds = _display displayCtrl 72012;
_sound = (_listAvailableSounds) lbData(lbCurSel(_listAvailableSounds));
if (isNil '_sound') exitWith {
    [localize "STR_SpeakerManager_Err_SelectSoundToPlay", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_exit = false;
_soundCfg = missionConfigFile >> "CfgSounds" >> _sound;
if !(isClass _soundCfg) then {
    _soundCfg = configFile >> "CfgSounds" >> _sound;
    if !(isClass _soundCfg) exitWith {
        _exit = true;
        [localize "STR_SpeakerManager_Err_CfgSoundNotFound", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
};
if (_exit) exitWith {};
_execType = getText(_config >> "executeType");
_execOnVar = getText(_config >> "executeOn");
if (isNil _execOnVar) exitWith {
    [localize "STR_SpeakerManager_Err_DestObjIsNil", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_execOn = call compile _execOnVar;
if (_execType isEqualTo "object") exitWith {
    [_execOn, _sound, 75, 1] remoteExec["life_fnc_say3D", RCLIENT];
};
if (_execType isEqualTo "synchronizedObjects") exitWith {
    {
        [_x, _sound, 75, 1] remoteExec["life_fnc_say3D", RCLIENT];
    }
    forEach synchronizedObjects _execOn;
};