#include "..\..\..\..\..\script_macros.hpp"
private["_resultPlayers", "_resultPlayerNotes"];
params[["_type", 0, [0]], ["_data", [],
    [
        []
    ]
]];
if (_type isEqualTo - 1) exitWith {
    [] spawn Rosenbach_fnc_Tablette_App_Interpol_openApp;
};
_resultPlayers = CONTROL(7847400, 7847411);
_resultPlayerNotes = CONTROL(7847400, 7847413);
switch (_type) do {
    case 1:
        {
            lbClear _resultPlayers;
            lbClear _resultPlayerNotes;
            CONTROL(7847400, 7847412) ctrlSetText localize "STR_TabletteAppInterpol_WaitingForSelection";
            if ((count _data) isEqualTo 0) exitWith {
                _resultPlayers lbAdd localize "STR_TabletteAppInterpol_NoResult";
                _resultPlayers lbSetData[(lbSize _resultPlayers) - 1, ""];
                _resultPlayers lbSetCurSel - 1;
            }; {
                _resultPlayers lbAdd(_x select 1);
                _resultPlayers lbSetData[(lbSize _resultPlayers) - 1, (_x select 0)];
                if ((_x select 2) isEqualTo 1) then {
                    _resultPlayers lbSetColor[(lbSize _resultPlayers) - 1, [1, 0.6, 0, 1]];
                    _resultPlayers lbSetSelectColor[(lbSize _resultPlayers) - 1, [1, 0.6, 0, 1]];
                    _resultPlayers lbSetPictureRight[(lbSize _resultPlayers) - 1, "a3\ui_f\data\gui\rsccommon\rscbuttonsearch\search_start_ca.paa"];
                    _resultPlayers lbSetTooltip[(lbSize _resultPlayers) - 1, localize "STR_TabletteAppInterpol_WantedPlayer"];
                };
            }
            forEach _data;
            _resultPlayers lbSetCurSel - 1;
        };
    case 2:
        {
            CONTROL(7847400, 7847412) ctrlSetText format[localize "STR_TabletteAppInterpol_RecordsOf", _resultPlayers lbText(lbCurSel _resultPlayers)];
            lbClear _resultPlayerNotes;
            if (count _data isEqualTo 0) exitWith {
                _resultPlayerNotes lbAdd localize "STR_TabletteAppInterpol_NoResult";
                _resultPlayerNotes lbSetValue[(lbSize _resultPlayerNotes) - 1, -1];
                _resultPlayerNotes lbAdd localize "STR_TabletteAppInterpol_TipsAddNewRecord";
                _resultPlayerNotes lbSetValue[(lbSize _resultPlayerNotes) - 1, -1];
                _resultPlayerNotes lbSetCurSel - 1;
            }; {
                private _isConfidential = _x select 3;
                private _title = "";
                if (_isConfidential isEqualTo 1) then {
                    _title = format["Fiche n°%1 - CONFIDENTIELLE", _x select 0];
                } else {
                    _title = format[localize "STR_TabletteAppInterpol_RecordTitle", (_x select 0)];
                };
                _resultPlayerNotes lbAdd _title;
                _resultPlayerNotes lbSetValue[(lbSize _resultPlayerNotes) - 1, (_x select 0)];
                _timestamp = _x select 2;
                _date = [_timestamp, false, false] call life_fnc_displayDate;
                if ((_x select 1) isEqualTo 1) then {
                    _resultPlayerNotes lbSetPictureRight[(lbSize _resultPlayerNotes) - 1, "a3\ui_f\data\gui\rsc\rscdisplaydynamicgroups\lock.paa"];
                    _resultPlayerNotes lbSetTooltip[(lbSize _resultPlayerNotes) - 1, format[format["%1 - %2", localize "STR_TabletteAppInterpol_LockRecord", localize "STR_TabletteAppInterpol_CreatedOn"], _date]];
                } else {
                    _resultPlayerNotes lbSetTooltip[(lbSize _resultPlayerNotes) - 1, format[localize "STR_TabletteAppInterpol_CreatedOn", _date]];
                };
            }
            forEach _data;
            _resultPlayerNotes lbSetCurSel - 1;
        };
    case 3:
        {
            private["_treeCtrl", "_codePenalCfg", "_infractionId", "_infractionCatCode", "_listInfactionCat", "_itemInfraction", "_infractionSubId", "_totalInfraction", "_lastNotifText", "_title", "_description", "_controleType", "_fineAmount", "_jailTime", "_infractionCatLastUpdate"];
            if (count(_data) isEqualTo 0) exitWith {
                [localize "STR_TabletteAppInterpol_Err_FailReadData", "Error"] spawn Poltich_fnc_Notification_handleMsg;
            };
            _treeCtrl = CONTROL(7847400, 7847421);
            tvClear _treeCtrl;
            _resultPlayerNotes lbSetData[(lbCurSel _resultPlayerNotes), str(_data select 1)];
            CONTROL(7847400, 7847420) ctrlSetText format[localize "STR_TabletteAppInterpol_RecordOfTitle", (_data select 0), (_data select 4)];
            _infractions = createHashMapFromArray(_data select 1);
            _codePenalCfg = missionConfigFile >> "Life_Cfg_CodePenal";
            _infractionId = 0;
            _infractionCatCode = "";
            _listInfactionCat = [];
            _itemInfraction = "";
            _infractionSubId = -1;
            _totalInfraction = createHashMap;
            _lastNotifText = ""; {
                _infractionId = _forEachIndex;
                _infractionCatCode = _x;
                _listInfactionCat = _y;
                if !(isClass(_codePenalCfg >> _infractionCatCode)) then {
                    continue;
                };
                _title = (getTextRaw(_codePenalCfg >> _infractionCatCode >> "title") regexReplace["&gt;", ">"]) regexReplace["&lt;", "<"];
                _treeCtrl tvAdd[[], _title];
                _infractionCatLastUpdate = getText(_codePenalCfg >> _infractionCatCode >> "lastUpdate");
                if (_infractionCatLastUpdate isNotEqualTo "") then {
                    _treeCtrl tvSetTooltip[[_infractionId], _infractionCatLastUpdate];
                }; {
                    if !(isClass(_codePenalCfg >> _infractionCatCode >> "items" >> _x)) then {
                        continue;
                    };
                    _itemInfraction = _codePenalCfg >> _infractionCatCode >> "items" >> _x;
                    _infractionSubId = _forEachIndex;
                    _title = (getTextRaw(_itemInfraction >> "title") regexReplace["&gt;", ">"]) regexReplace["&lt;", "<"];
                    _description = getTextRaw(_itemInfraction >> "helper");
                    if (_y > 0) then {
                        _title = format["[x%2] %1", _title, _y];
                        _description = format["%1<br/><br/>%2 %3", _description, localize "STR_TabletteAppInterpol_NumberOfOffencesRecorded", _y];
                    };
                    _treeCtrl tvAdd[[_infractionId], _title];
                    _treeCtrl tvSetData[[_infractionId, _infractionSubId], _description];
                    _controleType = getNumber(_itemInfraction >> "controle");
                    _fineAmount = getNumber(_itemInfraction >> "fine");
                    _jailTime = getNumber(_itemInfraction >> "jail");
                    _titleControle = format["STR_TabletteAppInterpol_ControlType_%1", _controleType];
                    _treeCtrl tvAdd[[_infractionId, _infractionSubId], localize _titleControle];
                    _treeCtrl tvAdd[[_infractionId, _infractionSubId], format[localize "STR_TabletteAppInterpol_FineOf", [_fineAmount] call life_fnc_numberText]];
                    if (_jailTime > 0) then {
                        _treeCtrl tvAdd[[_infractionId, _infractionSubId], format[localize "STR_TabletteAppInterpol_MonthsOfJail", _jailTime]];
                    };
                    if (_totalInfraction getOrDefault["controle", 0] < _controleType) then {
                        _totalInfraction set["controle", _controleType];
                    };
                    _totalInfraction set["fine", ((_fineAmount * _y) + (_totalInfraction getOrDefault["fine", 0]))];
                    _totalInfraction set["jail", ((_jailTime * _y) + (_totalInfraction getOrDefault["jail", 0]))];
                }
                forEach createHashMapFromArray _listInfactionCat;
                if ((_treeCtrl tvCount[_infractionId]) isEqualTo 0) then {
                    _treeCtrl tvDelete[_infractionId];
                };
            }
            forEach _infractions;
            _infractionId = _infractionId + 1;
            _infractionSubId = 0;
            _treeCtrl tvAdd[[], localize "STR_TabletteAppInterpol_RecordSummaryTitle"];
            _treeCtrl tvAdd[[_infractionId], localize "STR_TabletteAppInterpol_RelatedNote"];
            _treeCtrl tvSetData[[_infractionId, _infractionSubId], (_data select 2)];
            _treeCtrl tvSetCurSel[_infractionId, _infractionSubId];
            _infractionSubId = _infractionSubId + 1;
            _treeCtrl tvAdd[[_infractionId], localize "STR_TabletteAppInterpol_TotalCalculOfInfringements"];
            _titleControle = format["STR_TabletteAppInterpol_ControlType_%1", (_totalInfraction getOrDefault["controle", 0])];
            _treeCtrl tvAdd[[_infractionId, _infractionSubId], localize _titleControle];
            _treeCtrl tvAdd[[_infractionId, _infractionSubId], format[localize "STR_TabletteAppInterpol_FineOf", [_totalInfraction getOrDefault["fine", 0]] call life_fnc_numberText]];
            if (_totalInfraction getOrDefault["jail", 0] > 0) then {
                _treeCtrl tvAdd[[_infractionId, _infractionSubId], format[localize "STR_TabletteAppInterpol_MonthsOfJail", _totalInfraction getOrDefault["jail", 0]]];
            };
            _treeCtrl tvExpand[_infractionId, _infractionSubId];
            _timestamp = _data select 5;
            _date = [_timestamp, false, false] call life_fnc_displayDate;
            _infractionSubId = _infractionSubId + 1;
            _treeCtrl tvAdd[[_infractionId], localize "STR_TabletteAppInterpol_CreationOfTheRecordTitle"];
            _treeCtrl tvAdd[[_infractionId, _infractionSubId], (_data select 4)];
            _treeCtrl tvAdd[[_infractionId, _infractionSubId], _date];
            _lastNotifText = format[localize "STR_TabletteAppInterpol_CreatedByOn", (_data select 4), _date];
            if ((_data select 6) isEqualTo 1) then {
                _timestamp = _data select 8;
                _date = [_timestamp, false, false] call life_fnc_displayDate;
                _infractionSubId = _infractionSubId + 1;
                _treeCtrl tvAdd[[_infractionId], localize "STR_TabletteAppInterpol_LastEditOfTheRecordTitle"];
                _treeCtrl tvAdd[[_infractionId, _infractionSubId], (_data select 7)];
                _treeCtrl tvAdd[[_infractionId, _infractionSubId], _date];
                _lastNotifText = format[localize "STR_TabletteAppInterpol_ModifiedByOn", (_data select 7), _date];
            };
            if ((_data select 9) isEqualTo 1) then {
                _timestamp = _data select 11;
                _date = [_timestamp, false, false] call life_fnc_displayDate;
                _infractionSubId = _infractionSubId + 1;
                _treeCtrl tvAdd[[_infractionId], localize "STR_TabletteAppInterpol_LockOfTheRecordTitle"];
                _treeCtrl tvAdd[[_infractionId, _infractionSubId], (_data select 10)];
                _treeCtrl tvAdd[[_infractionId, _infractionSubId], _date];
                _lastNotifText = format[localize "STR_TabletteAppInterpol_LockedByOn", (_data select 10), _date];
            };
            CONTROL(7847400, 7847423) ctrlSetStructuredText parseText _lastNotifText;
        };
    default {};
}; _resultPlayers ctrlEnable true;
_resultPlayerNotes ctrlEnable true;