#include "..\..\..\..\..\script_macros.hpp"
private["_resultPlayerNotes", "_resultPlayers", "_lbCurSel", "_isLock", "_noteId", "_title", "_text", "_suspectPid", "_section", "_config", "_action", "_exportInfractions", "_globalNote", "_isConfidential"];
params[["_action", "", [""]]];
switch (_action) do {
    case "lock":
        {
            _resultPlayerNotes = CONTROL(7847400, 7847413);
            _lbCurSel = lbCurSel _resultPlayerNotes;
            if (_lbCurSel isEqualTo - 1) exitWith {
                [localize "STR_TabletteAppInterpol_Err_NoRecordSelectedForLock", "Error"] spawn Poltich_fnc_Notification_handleMsg;
            };
            _isLock = (_resultPlayerNotes lbPictureRight _lbCurSel) isNotEqualTo "";
            _noteId = (_resultPlayerNotes lbValue _lbCurSel);
            if (_noteId < 1) exitWith {
                [localize "STR_TabletteAppInterpol_Err_CantLockRecord", "Error"] spawn Poltich_fnc_Notification_handleMsg;
            };
            _title =
            if (_isLock) then {
                "STR_TabletteAppInterpol_UnlockRecordWithId"
            } else {
                "STR_TabletteAppInterpol_LockRecordWithId"
            };
            _text =
            if (_isLock) then {
                "STR_TabletteAppInterpol_DoYouWantUnlockRecordWithId"
            } else {
                "STR_TabletteAppInterpol_DoYouWantLockRecordWithId"
            };
            _action = [format[localize _text, _noteId], format[localize _title, _noteId], localize "STR_Global_Yes", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
            if (_action) then {
                if (life_HC_isActive) then {
                    [player, _noteId, !_isLock] remoteExec["HC_Rosenbach_fnc_Tablette_App_Interpol_lockNote", HC_Life];
                } else {
                    [_noteId, getPlayerUID player, !_isLock] remoteExec["SRV_Rosenbach_fnc_Tablette_App_Interpol_lockNote", RSERV];
                };
                if (_isLock) then {
                    _resultPlayerNotes lbSetPictureRight[_lbCurSel, "a3\modules_f\data\iconunlock_ca.paa"];
                    _resultPlayerNotes lbSetTooltip[_lbCurSel, ""];
                } else {
                    _resultPlayerNotes lbSetPictureRight[_lbCurSel, "a3\ui_f\data\gui\rsc\rscdisplaydynamicgroups\lock.paa"];
                    _resultPlayerNotes lbSetTooltip[_lbCurSel, localize "STR_TabletteAppInterpol_LockRecord"];
                };
            };
        }; case "delete":
            {
                _resultPlayerNotes = CONTROL(7847400, 7847413);
                _resultPlayers = CONTROL(7847400, 7847411);
                _lbCurSel = lbCurSel _resultPlayerNotes;
                if (_lbCurSel isEqualTo - 1) exitWith {
                    [localize "STR_TabletteAppInterpol_Err_NoRecordSelectedForDelete", "Error"] spawn Poltich_fnc_Notification_handleMsg;
                };
                _noteId = (_resultPlayerNotes lbValue _lbCurSel);
                if (_noteId < 1) exitWith {
                    [localize "STR_TabletteAppInterpol_Err_CantDeleteRecord", "Error"] spawn Poltich_fnc_Notification_handleMsg;
                };
                _action = [format[localize "STR_TabletteAppInterpol_DoYouWantDeleteRecordWithId", _noteId], format[localize "STR_TabletteAppInterpol_DeleteRecordWithId", _noteId], localize "STR_Global_Yes", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
                if (_action) then {
                    if (life_HC_isActive) then {
                        [player, _noteId] remoteExec["HC_Rosenbach_fnc_Tablette_App_Interpol_deleteNote", HC_Life];
                    } else {
                        [_noteId, getPlayerUID player] remoteExec["SRV_Rosenbach_fnc_Tablette_App_Interpol_deleteNote", RSERV];
                    };
                    _resultPlayerNotes lbDelete _lbCurSel;
                    if ((lbSize _resultPlayerNotes) isEqualTo 0) then {
                        _resultPlayerNotes lbAdd localize "STR_TabletteAppInterpol_NoResult";
                        _resultPlayerNotes lbSetValue[(lbSize _resultPlayerNotes) - 1, -1];
                        _resultPlayerNotes lbAdd localize "STR_TabletteAppInterpol_TipsAddNewRecord";
                        _resultPlayerNotes lbSetValue[(lbSize _resultPlayerNotes) - 1, -1];
                        _lbCurSel = lbCurSel _resultPlayers;
                        _resultPlayers lbSetColor[_lbCurSel, [1, 1, 1, 1]];
                        _resultPlayers lbSetSelectColor[_lbCurSel, [1, 1, 1, 1]];
                        _resultPlayers lbSetTooltip[_lbCurSel, ""];
                        CONTROL(7847400, 7847420) ctrlSetText "";
                        tvClear CONTROL(7847400, 7847421);
                        CONTROL(7847400, 7847422) ctrlSetStructuredText parseText "";
                        CONTROL(7847400, 7847423) ctrlSetStructuredText parseText "";
                    };
                    _resultPlayerNotes lbSetCurSel 0;
                };
            };
        case "add":
            {
                if ((count A4L_Tablette_App_Interpol_InfractionsMap) < 1) exitWith {
                    [localize "STR_TabletteAppInterpol_Err_NoOffencesAddedForRecord", "Error"] spawn Poltich_fnc_Notification_handleMsg;
                };
                _isConfidential =
                if (cbChecked((findDisplay 7847401) displayCtrl 270425)) then[{
                    1
                }, {
                    0
                }];
                _globalNote = ctrlText CONTROL(7847401, 7847456);
                if ((count _globalNote) > 1000) exitWith {
                    [localize "STR_TabletteAppInterpol_Err_LimitCharOfNoteReachForRecord", "Error"] spawn Poltich_fnc_Notification_handleMsg;
                };
                _text = localize "STR_TabletteAppInterpol_DoYouWantAddRecordWithOffences";
                _section = "";
                _config = missionConfigFile >> "Life_Cfg_CodePenal"; {
                    _section = _x; {
                        _text = _text + format["<br/>- [x%2] %1", getText(_config >> _section >> "items" >> _x >> "title"), _y];
                    }
                    forEach _y;
                }
                forEach A4L_Tablette_App_Interpol_InfractionsMap;
                _action = [_text, ctrlText CONTROL(7847401, 7847450), localize "STR_Global_Yes", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
                if (_action) then {
                    _exportInfractions = +A4L_Tablette_App_Interpol_InfractionsMap; {
                        _exportInfractions set[_x, (_y toArray false)];
                    }
                    foreach _exportInfractions;
                    _exportInfractions = _exportInfractions toArray false;
                    _suspectPid = ctrlText CONTROL(7847401, 7847460);
                    if (life_HC_isActive) then {
                        [player, _suspectPid, _exportInfractions, _globalNote] remoteExec["HC_Rosenbach_fnc_Tablette_App_Interpol_addNote", HC_Life];
                    } else {
                        [getPlayerUID player, _suspectPid, _exportInfractions, _globalNote, _isConfidential] remoteExec["SRV_Rosenbach_fnc_Tablette_App_Interpol_addNote", RSERV];
                    };
                };
            };
        case "update":
            {
                if ((count A4L_Tablette_App_Interpol_InfractionsMap) < 1) exitWith {
                    [localize "STR_TabletteAppInterpol_Err_NoOffencesAddedForRecord", "Error"] spawn Poltich_fnc_Notification_handleMsg;
                };
                _isConfidential =
                if (cbChecked((findDisplay 7847401) displayCtrl 270425)) then[{
                    1
                }, {
                    0
                }];
                _globalNote = ctrlText CONTROL(7847401, 7847456);
                if ((count _globalNote) > 1000) exitWith {
                    [localize "STR_TabletteAppInterpol_Err_LimitCharOfNoteReachForRecord", "Error"] spawn Poltich_fnc_Notification_handleMsg;
                };
                _text = localize "STR_TabletteAppInterpol_DoYouWantUpdateRecordWithOffences";
                _section = "";
                _config = missionConfigFile >> "Life_Cfg_CodePenal"; {
                    _section = _x; {
                        _text = _text + format["<br/>- [x%2] %1", getText(_config >> _section >> "items" >> _x >> "title"), _y];
                    }
                    forEach _y;
                }
                forEach A4L_Tablette_App_Interpol_InfractionsMap;
                _action = [_text, ctrlText CONTROL(7847401, 7847450), localize "STR_Global_Yes", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
                if (_action) then {
                    _exportInfractions = +A4L_Tablette_App_Interpol_InfractionsMap; {
                        _exportInfractions set[_x, (_y toArray false)];
                    }
                    foreach _exportInfractions;
                    _exportInfractions = _exportInfractions toArray false;
                    _noteId = parseNumber(ctrlText CONTROL(7847401, 7847461));
                    if (life_HC_isActive) then {
                        [_noteId, player, _exportInfractions, _globalNote] remoteExec["HC_Rosenbach_fnc_Tablette_App_Interpol_updateNote", HC_Life];
                    } else {
                        [_noteId, getPlayerUID player, _exportInfractions, _globalNote, _isConfidential] remoteExec["SRV_Rosenbach_fnc_Tablette_App_Interpol_updateNote", RSERV];
                    };
                };
            };
};