_entreprise = player getVariable["current_entreprise", objNull];
_entrepriseId = _entreprise getVariable["entreprise_id", 0];
private _name = CtrlText 2347;
if (isNull _entreprise) exitWith {
    closeDialog 0;
    [(["STR_NO_ENTERPRISE", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_name isEqualTo "") exitWith {
    [(["STR_BAD_NAME_ENTREPRISE", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((ctrlText 2345) isEqualTo "") exitWith {
    [(["STR_BAD_SIGN", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_entrepriseName = _entreprise getVariable["entreprise_name", ""];
_oldNameEntreprise = _entrepriseName;
_entreprisePdgPID = _entreprise getVariable["entreprise_pdg_pid", ""];
if !(_entreprisePdgPID isEqualTo(getPlayerUID player)) exitWith {
    closeDialog 0;
    ["Vous n'êtes pas le propriétaire de l'entreprise ! ", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_config = missionConfigFile >> "Max_Settings_Entreprise";
_name = (_name splitString " ") joinString " ";
_minimumLength = getNumber(_config >> "minimumCompanyName");
if ((count _name) < _minimumLength) exitWith {
    [format[(["STR_COMPANY_NAME_MINIMUM", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), _minimumLength], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_maximumLength = getNumber(_config >> "maximumCompanyName");
if ((count _name) > _maximumLength) exitWith {
    [format[(["STR_COMPANY_NAME_MAXIMUM", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), _maximumLength], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_forbiddenFormated = call compile(toLower str(getArray(_config >> "forbiddenWords")));
_testedName = ((toLower _name) splitString " ");
if (count(_testedName arrayIntersect _forbiddenFormated) > 0) exitWith {
    [(["STR_BAD_NAME_ENTREPRISE", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_newEntrepriseName = toUpper _name;
_newEntrepriseNameArray = toArray _newEntrepriseName;
_allowed = toArray("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789- ");
_badChar = false;
_lastIsSpace = false; {
    if !(_x in _allowed) exitWith {
        _badChar = true;
        _lastIsSpace = false;
    };
    if (_lastIsSpace && (_x isEqualTo 32)) exitWith {
        _badChar = true;
    };
    if (_x isEqualTo 32) then {
        _lastIsSpace = true;
    } else {
        _lastIsSpace = false;
    };
}
forEach _newEntrepriseNameArray;
if (_badChar && _lastIsSpace) exitWith {
    [(["STR_TOO_MUCH_SPACE", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_badChar) exitWith {
    [(["STR_BAD_CHARACTER", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (((_newEntrepriseNameArray select((count _name) - 1)) isEqualTo 32) || ((_newEntrepriseNameArray select 0) isEqualTo 32)) exitWith {
    [(["STR_TOO_MUCH_SPACE", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_valid = true; {
    if (((_x select 1) getVariable["entreprise_name", ""]) == _name) exitWith {
        _valid = false;
    };
}
forEach maxence_all_entreprises;
if !(_valid) exitWith {
    [(["STR_NAME_ALREADY_EXIST", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
private _hasMarker = false;
_status = _entreprise getVariable["entreprise_status", false];
_marker = _entreprise getVariable["entreprise_position", ""];
if !(_marker isEqualTo "") then {
    _hasMarker = true;
};
private _priceToRename = getNumber(missionConfigFile >> "Max_Settings_Entreprise" >> "price_to_rename");
if (_priceToRename > life_cash) exitWith {
    ["Vous n'avez pas assez d'argent !  ", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_action = [format["Voulez-vous renommer votre entreprise en %1 pour %2€?", _name, _priceToRename], "Renommer nom de l'entreprise", "Oui", "Non"] call BIS_fnc_guiMessage;
if !(_action) exitWith {
    closeDialog 0;
    ["Action annulé ! ", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
life_cash = life_cash - _priceToRename;
[1] call SOCK_fnc_updatePartial;
_entreprise setVariable["entreprise_name", _name, true];
[(_entreprise getVariable["entreprise_id", 0]), 13, _name] remoteExecCall["max_entreprise_fnc_updateEntreprise", 2];
if (_hasMarker) then {
    _entreprisePosition = _entreprise getVariable["entreprise_position", ""];
    _entreprisePositionID = _entreprisePosition splitstring "entreprise"
    select 0;
    _marker = format["ENTREP_%1", _entreprisePositionID];
    if (_status) then {
        _marker setMarkerText format[(["STR_OPEN", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), _name];
        _marker setMarkerColor getText(missionConfigFile >> "Max_Settings_Entreprise" >> "open_color");
    } else {
        _marker setMarkerText format[(["STR_CLOSED", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), _name];
        _marker setMarkerColor getText(missionConfigFile >> "Max_Settings_Entreprise" >> "close_color");
    };
};
closeDialog 0;