#include "..\..\script_macros.hpp"
private["_vehicle", "_type", "_time", "_value", "_vehicleData", "_upp", "_ui", "_progress", "_pgText", "_cP", "_filters", "_impoundValue", "_price", "_impoundMultiplier"];
_vehicle = param[0, objNull, [objNull]];
_filters = ["Car", "Bicycle", "Air", "Ship"];
if (!((KINDOF_ARRAY(_vehicle, _filters)))) exitWith {};
if (player distance cursorObject > 10) exitWith {};
if (_vehicle getVariable "NPC") exitWith {
    [localize "STR_NPC_Protected", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_vehicleData = _vehicle getVariable["vehicle_info_owners", []];
if (_vehicleData isEqualTo 0) exitWith {
    deleteVehicle _vehicle
};
_vehicleName = FETCH_CONFIG2(getText, "CfgVehicles", (typeOf _vehicle), "displayName");
_price = M_CONFIG(getNumber, "LifeCfgVehicles", (typeOf _vehicle), "price");
life_action_inUse = true;
_deleteVehicle = [localize "STR_NOTF_ImpoundOrDestroy_Text", localize "STR_NOTF_ImpoundOrDestroy_Title", localize "STR_Global_Destroy", localize "STR_Global_Impound"] call BIS_fnc_guiMessage;
_upp =
if (_deleteVehicle) then {
    localize "STR_NOTF_DestroyingVehicle"
} else {
    localize "STR_NOTF_Impounding"
};
private _bubbleMsg =
if (_deleteVehicle) then {
    localize "STR_Bubble_NOTF_DestroyingVehicle"
} else {
    localize "STR_Bubble_NOTF_ImpoundingVehicle"
};
[player, _bubbleMsg, "Action"] call Rosenbach_fnc_Bubble_Display;
disableSerialization;
"progressBar"
cutRsc["life_progress", "PLAIN"];
_ui = uiNamespace getVariable "life_progress";
_progress = _ui displayCtrl 38201;
_pgText = _ui displayCtrl 38202;
_pgText ctrlSetText format["%2 (1%1)...", "%", _upp];
_progress progressSetPosition 0.01;
_cP = 0.01;
for "_i"
from 0 to 1 step 0 do {
    uiSleep 0.09;
    _cP = _cP + 0.01;
    _progress progressSetPosition _cP;
    _pgText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _upp];
    if (_cP >= 1) exitWith {};
    if (player distance _vehicle > 10) exitWith {};
    if (!alive player) exitWith {};
};
"progressBar" cutText ["", "PLAIN"];
if (player distance _vehicle > 10) exitWith {
    [localize "STR_NOTF_ImpoundingCancelled", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    life_action_inUse = false;
};
if (!alive player) exitWith {
    life_action_inUse = false;
};
if !(_deleteVehicle) then {
    if (count crew _vehicle isEqualTo 0) then {
        if (!(KINDOF_ARRAY(_vehicle, _filters))) exitWith {
            life_action_inUse = false;
        };
        _type = FETCH_CONFIG2(getText, "CfgVehicles", (typeOf _vehicle), "displayName");
        life_impound_inuse = true;
        if (life_HC_isActive) then {
            [_vehicle, true, player] remoteExec["HC_fnc_vehicleStore", HC_Life];
        } else {
            [_vehicle, true, player] remoteExec["TON_fnc_vehicleStore", RSERV];
        };
        waitUntil {
            !life_impound_inuse
        };
        if (playerSide isEqualTo west) then {
            _impoundMultiplier = LIFE_SETTINGS(getNumber, "vehicle_cop_impound_multiplier");
            _value = _price * _impoundMultiplier;
            if (_vehicle in life_vehicles) then {
                [format[localize "STR_NOTF_OwnImpounded", [_value] call life_fnc_numberText, _type], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
                BANK = BANK - _value;
            } else {
                [format[localize "STR_NOTF_Impounded", _type, [_value] call life_fnc_numberText], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
                BANK = BANK + _value;
            };
            if (BANK < 0) then {
                BANK = 0;
            };
            [1] call SOCK_fnc_updatePartial;
        };
    } else {
        [localize "STR_NOTF_ImpoundingCancelled", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
} else {
    if (count crew _vehicle isEqualTo 0) then {
        if (!(KINDOF_ARRAY(_vehicle, _filters))) exitWith {
            life_action_inUse = false;
        };
        _type = FETCH_CONFIG2(getText, "CfgVehicles", (typeOf _vehicle), "displayName");
        life_impound_inuse = true;
        life_action_inUse = false;
        _vehicle setDamage[1, false];
        if (life_HC_isActive) then {
            [player, _vehicle, 0, CASH] remoteExec["HC_fnc_destroyVehicle", HC_Life];
        } else {
            [player, _vehicle, 0, CASH] remoteExec["TON_fnc_destroyVehicle", RSERV];
        };
        waitUntil {
            !life_impound_inuse
        };
        [localize "STR_NOTF_VehicleDestroyed", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
    } else {
        [localize "STR_NOTF_VehicleNotDestroyed", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        life_action_inUse = false;
    };
};
life_action_inUse = false;