#include "..\..\script_macros.hpp"
private["_defaultProcessTime", "_processTime", "_noLicenceMultiplierTime", "_vendor", "_type", "_exit", "_itemInfo", "_oldItem", "_newItemWeight", "_newItem", "_oldItemWeight", "_cost", "_upp", "_hasLicense", "_itemName", "_oldVal", "_ui", "_progress", "_pgText", "_cP", "_coeffXp", "_materialsRequired", "_materialsGiven", "_noLicenseCost", "_text", "_filter", "_totalConversions", "_minimumConversions"];
_vendor = [_this, 0, objNull, [objNull]] call BIS_fnc_param;
_type = [_this, 3, "", [""]] call BIS_fnc_param;
_defaultProcessTime = getNumber(missionConfigFile >> "ProcessAction" >> "DefaultProcessTime");
_processTime = _defaultProcessTime;
_noLicenceMultiplierTime = getNumber(missionConfigFile >> "ProcessAction" >> "NoLicenceMultiplierTime");
if (isNull _vendor || _type isEqualTo "" || (player distance _vendor > 10)) exitWith {};
life_action_inUse = true;
if (isClass(missionConfigFile >> "ProcessAction" >> _type)) then {
    _filter = false;
    _materialsRequired = M_CONFIG(getArray, "ProcessAction", _type, "MaterialsReq");
    _materialsGiven = M_CONFIG(getArray, "ProcessAction", _type, "MaterialsGive");
    _noLicenseCost = M_CONFIG(getNumber, "ProcessAction", _type, "NoLicenseCost");
    _text = M_CONFIG(getText, "ProcessAction", _type, "Text");
    _processTime = M_CONFIG(getNumber, "ProcessAction", _type, "ProcessTime");
    if (_processTime isEqualTo 0) then {
        _processTime = _defaultProcessTime;
    };
} else {
    _filter = true;
};
if (_filter) exitWith {
    life_action_inUse = false;
};
_itemInfo = [_materialsRequired, _materialsGiven, _noLicenseCost, (localize format["%1", _text])];
if (count _itemInfo isEqualTo 0) exitWith {
    life_action_inUse = false;
};
_oldItem = _itemInfo select 0;
_newItem = _itemInfo select 1;
_cost = _itemInfo select 2;
_upp = _itemInfo select 3;
_exit = false;
if (count _oldItem isEqualTo 0) exitWith {
    life_action_inUse = false;
};
_totalConversions = []; {
    _var = ITEM_VALUE(_x select 0);
    if (_var isEqualTo 0) exitWith {
        _exit = true;
    };
    if (_var < (_x select 1)) exitWith {
        _exit = true;
    };
    _totalConversions pushBack(floor(_var / (_x select 1)));
}
forEach _oldItem;
if (_exit) exitWith {
    life_is_processing = false;
    [localize "STR_NOTF_NotEnoughItemProcess", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    life_action_inUse = false;
};
if (_materialsRequired in ["cannabis_unprocessed", "cocaine_unprocessed", "heroin_unprocessed"] || _cost isEqualTo - 1) then {
    _hasLicense = true;
} else {
    _hasLicense = LICENSE_VALUE(_type, "civ");
};
if (_cost isEqualTo - 1) then {
    _cost = 0;
} else {
    _cost = _cost * (count _oldItem);
    _exit = false;
    if !(_hasLicense) then {
        _condition = M_CONFIG(getText, "ProcessAction", _type, "condition");
        if !(_condition isEqualTo "") then {
            if (missionNamespace getVariable[_condition, false]) then {
                _hasLicense = true;
            } else {
                _exit = true;
            };
        };
    };
    if (_exit) exitWith {
        hint "Vous n'avez pas le droit de faire ce traitement !";
        life_is_processing = false;
        life_action_inUse = false;
    };
};
_minimumConversions = _totalConversions call BIS_fnc_lowestNum;
_oldItemWeight = 0; {
    _weight = ([_x select 0] call life_fnc_itemWeight) * (_x select 1);
    _oldItemWeight = _oldItemWeight + _weight;
}
count _oldItem;
_newItemWeight = 0; {
    _weight = ([_x select 0] call life_fnc_itemWeight) * (_x select 1);
    _newItemWeight = _newItemWeight + _weight;
}
count _newItem;
_exit = false;
if (_newItemWeight > _oldItemWeight) then {
    _netChange = _newItemWeight - _oldItemWeight;
    _freeSpace = life_maxWeight - life_carryWeight;
    if (_freeSpace < _netChange) exitWith {
        _exit = true;
    };
    private _estConversions = floor(_freeSpace / _netChange);
    if (_estConversions < _minimumConversions) then {
        _minimumConversions = _estConversions;
    };
};
if (_exit) exitWith {
    [localize "STR_Process_Weight", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    life_is_processing = false;
    life_action_inUse = false;
};
[format["vient de commencer à traiter %1", _upp]] call life_fnc_logs;
disableSerialization;
"progressBar"
cutRsc["life_progress", "PLAIN"];
_ui = uiNamespace getVariable "life_progress";
_progress = _ui displayCtrl 38201;
_pgText = _ui displayCtrl 38202;
_pgText ctrlSetText format["%2 (1%1)...", "%", _upp];
_progress progressSetPosition 0.01;
_cP = 0.01;
_coeffXp = missionNamespace getVariable["xp_system_perk_treatment_multiplicator", 1];
life_is_processing = true;
_exit = false;
if !(_hasLicense) then {
    _processTime = _processTime * _noLicenceMultiplierTime;
    if (CASH < _cost) exitWith {
        [format[localize "STR_Process_License", [_cost] call life_fnc_numberText], "Error"] spawn Poltich_fnc_Notification_handleMsg;
        "progressBar"
        cutText["", "PLAIN"];
        life_is_processing = false;
        life_action_inUse = false;
        _exit = true;
    };
};
if (_exit) exitWith {};
for "_i"
from 0 to 1 step 0 do {
    uiSleep _processTime;
    _cP = _cP + (0.01 * _coeffXp);
    _progress progressSetPosition _cP;
    _pgText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _upp];
    if (_cP >= 1) exitWith {};
    if (player distance _vendor > 10) exitWith {};
    if !(alive player) exitWith {};
    if ((vehicle player) isNotEqualTo player) exitWith {};
}; if !(alive player) exitWith {
    "progressBar"
    cutText["", "PLAIN"];
    life_is_processing = false;
    life_action_inUse = false;
};
if ((vehicle player) isNotEqualTo player) exitWith {
    [localize "STR_NOTF_ActionInVehicle", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    "progressBar"
    cutText["", "PLAIN"];
    life_is_processing = false;
    life_action_inUse = false;
};
if (player distance _vendor > 10) exitWith {
    [localize "STR_Process_Stay", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    "progressBar"
    cutText["", "PLAIN"];
    life_is_processing = false;
    life_action_inUse = false;
};
if !(_hasLicense) then {
    if (CASH < _cost) exitWith {
        [format[localize "STR_Process_License", [_cost] call life_fnc_numberText], "Error"] spawn Poltich_fnc_Notification_handleMsg;
        "progressBar"
        cutText["", "PLAIN"];
        life_is_processing = false;
        life_action_inUse = false;
        _exit = true;
    } else {
        CASH = CASH - _cost;
        [0] call SOCK_fnc_updatePartial;
    };
};
if (_exit) exitWith {}; {
    [false, (_x select 0), ((_x select 1) * (_minimumConversions))] call life_fnc_handleInv;
}
count _oldItem; {
    [true, (_x select 0), ((_x select 1) * (_minimumConversions))] call life_fnc_handleInv;
}
count _newItem;
"progressBar"
cutText["", "PLAIN"];
if (_minimumConversions isEqualTo(_totalConversions call BIS_fnc_lowestNum)) then {
    [localize "STR_NOTF_ItemProcess", "Info"] spawn Poltich_fnc_Notification_handleMsg;
} else {
    [localize "STR_Process_Partial", "Info"] spawn Poltich_fnc_Notification_handleMsg;
};
_inService = player getVariable['inService_global', false];
if !(_inService) then {
    ["treatment"] spawn xp_system_tpfn_addXP;
};
life_is_processing = false;
life_action_inUse = false;