#include "..\..\script_macros.hpp"
params[["_ret", [],
    [
        []
    ]
], ["_bad", false, [false]], ["_time", 0, [0]]];
private _esc = false;
private _bail = false;
private _dead = false;
private _time = time + (_time * 60);
life_end_jail_time = _time;
if (_bad) then {
    _time = _time + 60;
};
[_bad] spawn {
    life_canpay_bail = false;
    if (_this select 0) then {
        sleep(10 * 60);
    } else {
        sleep(5 * 60);
    };
    life_canpay_bail = true;
};
for "_i"
from 0 to 1 step 0 do {
    if (round(_time - time) > 0) then {
        _countDown = [(_time - time), "HH:MM:SS"] call BIS_fnc_secondsToString;
        hintSilent parseText format[(localize "STR_Jail_Time") + "<br/> <t size='2'><t color='#FF0000'>%1</t></t><br/>", _countDown];
    };
    if (!alive player) exitWith {
        _dead = true;
    };
    if ((player getVariable 'Revive') == true) exitWith {
        _dead = true;
    };
    if (LIFE_SETTINGS(getNumber, "jail_forceWalk") isEqualTo 1) then {
        player forceWalk true;
    };
    if (!(player inArea "jail_marker_zone") && alive player) exitWith {
        _esc = true;
    };
    if (life_bail_paid) exitWith {
        _bail = true;
    };
    if (round(_time - time) < 1) exitWith {
        hint ""
    };
    sleep 0.1;
}; switch (true) do {
    case (_bail):
        {
            life_is_arrested = false;
            life_bail_paid = false;
            [localize "STR_Jail_Paid", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
            player setPos(getMarkerPos "jail_release");
            [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]]] call BIS_fnc_loadInventory;
            [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]],
                [], true] call BIS_fnc_saveInventory;
            [5] call SOCK_fnc_updatePartial;
        };
    case (_esc):
        {
            life_is_arrested = false;
            if (alive player) then {
                [localize "STR_Jail_EscapeSelf", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
                [3, "STR_Jail_EscapeNOTF", true, [], "Dispatch"] remoteExec["life_fnc_broadcast", west];
                [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]],
                    [], true] call BIS_fnc_saveInventory;
            } else {
                [3, "STR_Jail_InjuredNOTF", true, [], "Dispatch"] remoteExec["life_fnc_broadcast", west];
                [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]]] call BIS_fnc_loadInventory;
            };
            [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]],
                [], true] call BIS_fnc_saveInventory;
            [5] call SOCK_fnc_updatePartial;
        };
    case (_dead):
        {
            hintSilent "";
            life_is_arrested = false;
            [3, "STR_Jail_InjuredNOTF", true, [], "Dispatch"] remoteExec["life_fnc_broadcast", west];
            [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]]] call BIS_fnc_loadInventory;
            [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]],
                [], true] call BIS_fnc_saveInventory;
            [5] call SOCK_fnc_updatePartial;
        };
    case (alive player && {
        !_esc
    } && {
        !_dead
    } && {
        !_bail
    }):
        {
            life_is_arrested = false;
            [localize "STR_Jail_Released", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
            player setPos(getMarkerPos "jail_release");
            [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]]] call BIS_fnc_loadInventory;
            [player, [missionNamespace, format["A4L_HabitsPrison_%1", getPlayerUID player]],
                [], true] call BIS_fnc_saveInventory;
            [5] call SOCK_fnc_updatePartial;
        };
}; player forceWalk false;