#include "..\..\script_macros.hpp"
params["_laptop", "", "", "_mode"];
private _altisArray = [16019.5, 16952.9, 0];
private _tanoaArray = [11074.2, 11501.5, 0.00137329];
private _maldenArray = [6341.4, 10725.6, 0];
private _viceCityMap = [2692.21, 4719.02, 0.00143909];
private _pos = [
    [
        ["arm4life_vicecity", _viceCityMap],
        ["Altis", _altisArray],
        ["Tanoa", _tanoaArray],
        ["Malden", _maldenArray]
    ]
] call TON_fnc_terrainSort;
private _dome = nearestObject[_pos, "Land_ServiceHangar_01_L_F"];
if (!isPiPEnabled) exitWith {
    hint localize "STR_Cop_EnablePiP";
};
if (isNil "life_fed_scam") then {
    life_fed_scam = "camera"
    camCreate[0, 0, 0];
    life_fed_scam camSetFov 0.5;
    life_fed_scam camCommit 0;
    "rendertarget0"
    setPiPEffect[0];
    life_fed_scam cameraEffect["INTERNAL", "BACK", "rendertarget0"];
    _laptop setObjectTexture[0, "#(argb,256,256,1)r2t(rendertarget0,1.0)"];
};
private _mTwPositions = [
    ["sideSouth", [89, -38, 8],
        [1, 10, -15]
    ],
    ["sideNorth", [90, 85, 8],
        [1, 60, -10]
    ],
    ["indoor", [-9, -1.7, 5.8],
        [12, 18, -4]
    ],
    ["front", [-15, -38, 8],
        [-17, 10, -5]
    ],
    ["entrance", [-95, 23, 3],
        [-25, 56, -31]
    ]
];
private _index = [_mode, _mTwPositions] call TON_fnc_index;
if (_index isEqualTo - 1) then {
    life_fed_scam cameraEffect["terminate", "back"];
    camDestroy life_fed_scam;
    _laptop setObjectTexture[0, ""];
    life_fed_scam = nil;
} else {
    _temp = _mTwPositions select _index;
    life_fed_scam camSetPos(_dome modelToWorld(_temp select 1));
    life_fed_scam camSetTarget(_dome modelToWorld(_temp select 2));
    life_fed_scam camCommit 0;
};