#include "..\..\script_macros.hpp"
_paramValue = _this select 3;
_player = _this select 1;
if (_paramValue isEqualTo nil) exitWith {
    [format[localize "STR_joinLeaveServiceInJob_Err_ParamsNotCorrect", "(params nil)"], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((count _paramValue) < 1) exitWith {
    [format[localize "STR_joinLeaveServiceInJob_Err_ParamsNotCorrect", "(params empty)"], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_licenseClassname = _paramValue select 0;
if (_licenseClassname isEqualTo "") exitWith {
    [format[localize "STR_joinLeaveServiceInJob_Err_ParamsNotCorrect", "(classname empty)"], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_licenseClassname isEqualTo "any") then {
    _licenseClassname = _player getVariable['inService_name', "none"];
};
if (!isClass(missionConfigFile >> "Licenses" >> _licenseClassname)) exitWith {
    [format[localize "STR_joinLeaveServiceInJob_Err_ParamsNotCorrect", format["(classname not found: %1)", _licenseClassname]], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_displayName = M_CONFIG(getText, "Licenses", _licenseClassname, "displayName");
_sideFlag = M_CONFIG(getText, "Licenses", _licenseClassname, "side");
_serviceStatus = _player getVariable['inService_global', false];
if (_serviceStatus && !(_player getVariable['inService_name', "none"] isEqualTo _licenseClassname)) exitWith {
    [localize "STR_joinLeaveServiceInJob_Err_NotGoodQG", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_hasLicense = missionNamespace getVariable[LICENSE_VARNAME(_licenseClassname, _sideFlag), false];
if !(_hasLicense) exitWith {
    [localize "STR_joinLeaveServiceInJob_Err_RequireLicence", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_exit = false;
if !(_serviceStatus) then {
    _hasLicense = missionNamespace getVariable[LICENSE_VARNAME("blocageMetier", "civ"), false];
    if (_hasLicense) then {
        _exit = true;
        [localize "STR_joinLeaveServiceInJob_Err_RestrictJobLicence", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
};
if (_exit) exitWith {};
if (_serviceStatus) then {
    _player setVariable['inService_name', nil, true];
    _player setVariable['inService_global', nil, true];
} else {
    _player setVariable['inService_name', _licenseClassname, true];
    _player setVariable['inService_global', true, true];
};
switch (_licenseClassname) do {
    case "journa":
        {
            _player setVariable['journaliste_bfm', !_serviceStatus];
        }; case "transp_fonds":
            {
                _player setVariable['inService_Brinks', !_serviceStatus];
            };
        case "depa":
            {
                _player setVariable['TP_troubleshooter', !_serviceStatus, true];
                _player setVariable['TP_isAvailable', !_serviceStatus, true];
                missionNamespace setVariable['inDuty_RepairMan', !_serviceStatus];
            };
        case "dir_btp":
            {
                _player setVariable['life_repairMan', !_serviceStatus];
            };
};
[ format ["vient de %1 son service en %2",
if !(_serviceStatus) then[{
    "prendre"
}, {
    "finir"
}], _licenseClassname]] call life_fnc_logs;
_textServiceStatus =
if !(_serviceStatus) then[{
    "Prise"
}, {
    "Fin"
}];
life_paycheck =
if !(_serviceStatus) then[{
    LIFE_SETTINGS(getNumber, "paycheck_civ_job")
}, {
    LIFE_SETTINGS(getNumber, "paycheck_civ")
}];
[format[localize "STR_joinLeaveServiceInJob_TakeOrEndService", _textServiceStatus, localize _displayName], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;