#include "..\..\script_macros.hpp"
private["_broadcastHeader", "_broadcastMessage", "_displayTypeId", "_badCharacter", "_characterByte", "_allowed", "_broadcastHeaderLength", "_broadcastMessageLength", "_allowedHeaderLength", "_allowedMessageLength", "_msgCost"];
disableSerialization;
_broadcastHeader = ctrlText(CONTROL(100100, 100101));
_broadcastMessage = ctrlText(CONTROL(100100, 100102));
_displayTypeId = lbCurSel CONTROL(100100, 100105);
_characterByte = toArray(_broadcastHeader);
_allowed = toArray("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_ ");
_allowedHeaderLength = LIFE_SETTINGS(getNumber, "news_broadcast_header_length");
_allowedMessageLength = LIFE_SETTINGS(getNumber, "news_broadcast_message_length");
_badCharacter = false;
_broadcastHeaderLength = count _broadcastHeader;
_broadcastMessageLength = count _broadcastMessage;
if (_broadcastHeaderLength < 5) exitWith {
    [localize "STR_News_MinHeaderLength", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_broadcastMessageLength < 10) exitWith {
    [localize "STR_News_MinMessageLength", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_broadcastHeaderLength > _allowedHeaderLength) exitWith {
    [format[localize "STR_News_MaxHeaderLength", _allowedHeaderLength], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_broadcastMessageLength > _allowedMessageLength) exitWith {
    [format[localize "STR_News_MaxMessageLength", _allowedMessageLength], "Error"] spawn Poltich_fnc_Notification_handleMsg;
}; {
    if (!(_x in _allowed)) exitWith {
        _badCharacter = true;
    };
}
forEach _characterByte;
if (_badCharacter) exitWith {
    [localize "STR_News_UnsupportedCharacter", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (((player getVariable['inService_name', '']) isEqualTo 'journa') && license_civ_journa) then {
    private _annonces = missionNameSpace getVariable["armaforlife_annoncejournaliste", []];
    _annonces pushBack[_broadcastHeader, _broadcastMessage, _displayTypeId, profileName];
    missionNameSpace setVariable["armaforlife_annoncejournaliste", _annonces, true];
} else {
    private _annonces = missionNameSpace getVariable["armaforlife_annoncejournalisteCIV", []];
    _annonces pushBack[_broadcastHeader, _broadcastMessage, _displayTypeId, profileName];
    missionNameSpace setVariable["armaforlife_annoncejournalisteCIV", _annonces, true];
};
closeDialog 0;
[_broadcastHeader, _broadcastMessage, _displayTypeId, profileName] remoteExec['life_fnc_AAN', -2];
_msgCost =
if (((player getVariable['inService_name', '']) isEqualTo 'journa') && license_civ_journa) then {
    LIFE_SETTINGS(getNumber, "news_broadcast_cost_job")
} else {
    LIFE_SETTINGS(getNumber, "news_broadcast_cost")
};
CASH = CASH - _msgCost;
[0] call SOCK_fnc_updatePartial;
life_broadcastTimer = time;
publicVariable "life_broadcastTimer";