#include "..\..\script_macros.hpp"
if ((getNumber(missionConfigFile >> "The_Programmer_Property_Center" >> "buy_house_only_with_property_center")) isEqualTo 1) exitWith {
    [(["STR_USE_PROPERTY", "The_Programmer_Property_Center", "Property_Center_Localization"] call theprogrammer_core_fnc_localize), "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
};
private["_house", "_uid", "_action", "_houseCfg"];
_house = param[0, objNull, [objNull]];
_uid = getPlayerUID player;
if (isNull _house) exitWith {};
if (!(_house isKindOf "House_F")) exitWith {};
if (_house getVariable["house_owned", false]) exitWith {
    [localize "STR_House_alreadyOwned", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (!isNil {
    (_house getVariable "house_sold")
}) exitWith {
    [localize "STR_House_Sell_Process", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (!license_civ_home) exitWith {
    [localize "STR_House_License", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
private _exit = false;
private _maxPermHouseKey = (LIFE_SETTINGS(getNumber, "house_limit"));
private _keysNb = (count life_houses);
if (['Max_Settings_GiveVehicle'] call theprogrammer_core_fnc_isProductInstalled) then {
    private _config = missionConfigFile >> "Max_Settings_GiveVehicle";
    private _countTempKeysForBuyLimit = getNumber(_config >> "count_house_temporary_keys_for_buy_limit") isEqualTo 1;
    if !(_countTempKeysForBuyLimit) then {
        _keysNb = _keysNb - call max_keytransfer_fnc_getNbTempHousesKeysOwned;
    };
};
_exit = (_keysNb >= _maxPermHouseKey);
if (_exit) exitWith {
    [format[localize "STR_House_Max_House", _maxPermHouseKey], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
closeDialog 0;
_houseCfg = [(typeOf _house)] call life_fnc_houseConfig;
if (count _houseCfg isEqualTo 0) exitWith {};
_action = [format[localize "STR_House_BuyMSG", [(_houseCfg select 0)] call life_fnc_numberText, (_houseCfg select 1)], localize "STR_House_Purchase", localize "STR_Global_Buy", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
if (_action) then {
    if (BANK < (_houseCfg select 0)) exitWith {
        [localize "STR_House_NotEnough", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    BANK = BANK - (_houseCfg select 0);
    [1] call SOCK_fnc_updatePartial;
    if (life_HC_isActive) then {
        [_uid, _house] remoteExec["HC_fnc_addHouse", HC_Life];
    } else {
        [_uid, _house] remoteExec["TON_fnc_addHouse", RSERV];
    };
    [format["vient d'acheter une propriété (pos: %1 - '%2')", (getPosATL _house), (text nearestLocation[getPos _house, "nameCity"])]] call life_fnc_logs;
    [format[localize "STR_House_Success_Buy", [(_houseCfg select 0)] call life_fnc_numberText], "Successful"] spawn Poltich_fnc_Notification_handleMsg;
    _house setVariable["house_owner", [_uid, profileName], true];
    _house setVariable["locked", true, true];
    _house setVariable["containers", [], true];
    _house setVariable["uid", floor(random 99999), true];
    life_vehicles pushBack _house;
    life_houses pushBack[str(getPosATL _house), []];
    _marker = createMarkerLocal[format["house_%1", (_house getVariable "uid")], getPosATL _house];
    _houseName = FETCH_CONFIG2(getText, "CfgVehicles", (typeOf _house), "displayName");
    _marker setMarkerTextLocal _houseName;
    _marker setMarkerColorLocal "ColorBlue";
    _marker setMarkerTypeLocal "loc_Lighthouse";
    _numOfDoors = FETCH_CONFIG2(getNumber, "CfgVehicles", (typeOf _house), "numberOfDoors");
    for "_i"
    from 1 to _numOfDoors do {
        _house setVariable[format["bis_disabled_Door_%1", _i], 1, true];
    };
};