#include "..\..\script_macros.hpp"
private _house = param[0, objNull, [objNull]];
private _uid = getPlayerUID player;
if (isNull _house) exitWith {};
if (_house getVariable["garageBought", false]) exitWith {
    [localize "STR_Garage_alreadyOwned", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_house getVariable "house_owner") select 0 != getPlayerUID player) exitWith {
    [localize "STR_Garage_NotOwner", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_house getVariable["blacklistedGarage", false]) exitWith {};
closeDialog 0;
private _price = LIFE_SETTINGS(getNumber, "houseGarage_buyPrice");
_action = [format[localize "STR_Garage_HouseBuyMSG", [_price] call life_fnc_numberText], localize "STR_House_GaragePurchase", localize "STR_Global_Buy", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
if (_action) then {
    if (!life_use_atm) exitWith {
        [localize "STR_NOTF_recentlyRobbedBank_House", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        ctrlShow[2001, true];
    };
    if (BANK < _price) exitWith {
        [format[localize "STR_House_NotEnough"], "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    BANK = BANK - _price;
    [1] call SOCK_fnc_updatePartial;
    if (life_HC_isActive) then {
        [_uid, _house, 0] remoteExec["HC_fnc_houseGarage", HC_Life];
    } else {
        [_uid, _house, 0] remoteExec["TON_fnc_houseGarage", RSERV];
    };
    _house setVariable["garageBought", true, true];
    [format["vient d'acheter une propriété (pos: %1 - '%2')", (getPosATL _house), (text nearestLocation[getPos _house, "nameCity"])]] call life_fnc_logs;
    [format[localize "STR_House_Success_Buy", [_price] call life_fnc_numberText], "Successful"] spawn Poltich_fnc_Notification_handleMsg;
};