#include "..\..\script_macros.hpp"
private["_house", "_uid", "_exit", "_action", "_houseCfg"];
if (dialog) then {
    closeDialog 0
};
_house = param[0, objNull, [objNull]];
_uid = getPlayerUID player;
if (isNull _house) exitWith {};
if (!(_house isKindOf "House_F")) exitWith {};
if (isNil {
    _house getVariable "house_owner"
}) exitWith {
    [localize "STR_House_noOwner_Online", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
closeDialog 0;
_exit = "";
if !(call life_adminlevel >= 5) then {
    if ((getNumber(missionConfigFile >> "The_Programmer_Property_Center" >> "sell_house_only_with_property_center")) isEqualTo 1) exitWith {
        _exit = (["STR_USE_PROPERTY_SELL", "The_Programmer_Property_Center", "Property_Center_Localization"] call theprogrammer_core_fnc_localize);
    };
    if (((_house getVariable["house_owner", []]) select 0) != (getPlayerUID player)) exitWith {
        _exit = (["STR_CANNOT_SELL_HOUSE", "Max_Settings_GiveVehicle", "KeyTransfer_Localization"] call theprogrammer_core_fnc_localize);
    };
};
if !(_exit isEqualTo "") exitWith {
    [_exit, "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_houseCfg = [(typeOf _house)] call life_fnc_houseConfig;
if (count _houseCfg isEqualTo 0) exitWith {};
_action = [format[localize "STR_House_SellHouseMSG", (round((_houseCfg select 0) / 2)) call life_fnc_numberText, (_houseCfg select 1)], localize "STR_pInAct_SellHouse", localize "STR_Global_Sell", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
if (_action) then {
    if (!isNil {
        (_house getVariable "house_sold")
    }) exitWith {
        [localize "STR_House_Sell_Process", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    [_house] call max_keytransfer_fnc_ownerSellHouse;
    _house setVariable["house_sold", true, true];
    if (life_HC_isActive) then {
        [_house] remoteExecCall["HC_fnc_sellHouse", HC_Life];
    } else {
        [_house] remoteExecCall["TON_fnc_sellHouse", RSERV];
    };
    _house setVariable["locked", false, true];
    deleteMarkerLocal format["house_%1", _house getVariable "uid"];
    _house setVariable["uid", nil, true];
    [format["vient de vendre une propriété (pos: %1 - '%2')", (getPosATL _house), (text nearestLocation[getPos _house, "nameCity"])]] call life_fnc_logs;
    [format[localize "STR_House_Success_Sell", (round((_houseCfg select 0) / 2)) call life_fnc_numberText], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
    _index = life_vehicles find _house;
    if (_index isNotEqualTo - 1) then {
        life_vehicles deleteAt _index;
    };
    _index = [(getPosATL _house), life_houses] call TON_fnc_houseIndex;
    if (_index isNotEqualTo - 1) then {
        life_houses deleteAt _index;
        BANK = BANK + (round((_houseCfg select 0) / 2));
        [1] call SOCK_fnc_updatePartial;
    };
    _numOfDoors = FETCH_CONFIG2(getNumber, "CfgVehicles", (typeOf _house), "numberOfDoors");
    for "_i"
    from 1 to _numOfDoors do {
        _house setVariable[format["bis_disabled_Door_%1", _i], 0, true];
    }; _containers = _house getVariable["containers", []];
    if (count _containers > 0) then {
        {
            _x setVariable["Trunk", nil, true];
            if (life_HC_isActive) then {
                [_x] remoteExecCall["HC_fnc_sellHouseContainer", HC_Life];
            } else {
                [_x] remoteExecCall["TON_fnc_sellHouseContainer", RSERV];
            };
        }
        forEach _containers;
    };
    _house setVariable["containers", nil, true];
};