#include "..\..\script_macros.hpp"
if (dialog) then {
    closeDialog 0
};
private _house = param[0, objNull, [objNull]];
private _uid = getPlayerUID player;
if (isNull _house) exitWith {};
if !(_house getVariable["garageBought", false]) exitWith {
    [localize "STR_Garage_NotOwned", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_house getVariable "house_owner") select 0 != getPlayerUID player) exitWith {
    [localize "STR_Garage_NotOwner", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
closeDialog 0;
private _sellPrice = LIFE_SETTINGS(getNumber, "houseGarage_sellPrice");
_action = [format[localize "STR_House_SellGarageMSG", [_sellPrice] call life_fnc_numberText], localize "STR_House_GarageSell", localize "STR_Global_Sell", localize "STR_Global_Cancel"] call BIS_fnc_guiMessage;
if (_action) then {
    if (life_HC_isActive) then {
        [_uid, _house, 1] remoteExec["HC_fnc_houseGarage", HC_Life];
    } else {
        [_uid, _house, 1] remoteExec["TON_fnc_houseGarage", RSERV];
    };
    BANK = BANK + _sellPrice;
    [1] call SOCK_fnc_updatePartial;
    _house setVariable["garageBought", false, true];
    [format["vient de vendre une propriété (pos: %1 - '%2')", (getPosATL _house), (text nearestLocation[getPos _house, "nameCity"])]] call life_fnc_logs;
    [format[localize "STR_House_Success_Sell", [_sellPrice] call life_fnc_numberText], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
};