#include "..\script_macros.hpp"
_TFenabled = call TFAR_fnc_isTeamSpeakPluginEnabled;
if (!(_TFenabled)) then {
    while {
        !(call TFAR_fnc_isTeamSpeakPluginEnabled)
    }
    do {
        titleText["Merci de rejoindre Teamspeak (ts.mrratsuper.fr) et/ou de réactiver TaskForceRadio.", "BLACK FADED"];
        if (player getvariable "taskfr") then {
            player setvariable["taskfr", false];
        };
    };
};
Dvid_TFEnabled = true;
Dvid_onTsServer = "- TS DU CLAN.SUPER.RAT.FACTION -" == (call TFAR_fnc_getTeamSpeakServerName);
Dvid_onChannel = "ARMA4LIFE" == (call TFAR_fnc_getTeamSpeakChannelName);
titleText["TFR activé.", "BLACK IN"];
["TFAR_ShowVolumeHUD", true, true, "mission"] call CBA_Settings_fnc_set;
[] spawn {
    for "_i"
    from 0 to 1 step 0 do {
        if (!(isNil "life_adminlevel") && {
            (life_adminlevel call BIS_fnc_parseNumber) > 0
        }) exitWith {};
        _TFenabled = call TFAR_fnc_isTeamSpeakPluginEnabled;
        if ((!(_TFenabled)) && (Dvid_TFEnabled)) then {
            titleText["Veuillez activer TaskForceRadio pour rejoindre le canal de jeu (Teamspeak -> Outils -> Compléments)", "BLACK FADED"];
            Dvid_TFEnabled = false;
            if (player getvariable "taskfr") then {
                player setvariable["taskfr", false];
            };
        };
        _onTsServer = "- TS DU CLAN.SUPER.RAT.FACTION -" == (call TFAR_fnc_getTeamSpeakServerName);
        if (!(_onTsServer)) then {
            titleText["Merci de rejoindre Teamspeak (ts.mrratsuper.fr) et/ou de réactiver TaskForceRadio.", "BLACK"];
            Dvid_onTsServer = false;
            if (player getvariable "taskfr") then {
                player setvariable["taskfr", false];
            };
        } else {
            if (!(Dvid_onTsServer)) then {
                titleText["TFR OK. Bienvenue!", "BLACK IN"];
                Dvid_onTsServer = true;
                if (!(player getvariable "taskfr")) then {
                    player setvariable["taskfr", true];
                };
            };
        };
        _onChannel = "ARMA4LIFE" == (call TFAR_fnc_getTeamSpeakChannelName);
        if (!(_onChannel)) then {
            titleText["Veuillez recharger le TaskForceRadio pour rejoindre le canal de jeu (Teamspeak -> Outils -> Compléments -> Tout recharger)", "BLACK FADED"];
            Dvid_onChannel = false;
            if (player getvariable "taskfr") then {
                player setvariable["taskfr", false];
            };
        } else {
            if (!(Dvid_onChannel)) then {
                titleText["Tout est prêt, bienvenue !", "BLACK IN"];
                Dvid_onChannel = true;
                if (!(player getvariable "taskfr")) then {
                    player setvariable["taskfr", true];
                };
            };
        };
        if ((_TFenabled) && (!(Dvid_TFEnabled))) then {
            titleText["TFR Recharger.", "BLACK IN"];
            Dvid_TFEnabled = true;
            if (!(player getvariable "taskfr")) then {
                player setvariable["taskfr", true];
            };
        };
        sleep.14;
    };
};
diag_log "----------------------------------------------------------------------------------------------------";
diag_log "--------------------------------- Starting Altis Life Client Init ----------------------------------";
diag_log format["------------------------------------------ Version %1 -------------------------------------------", (LIFE_SETTINGS(getText, "framework_version"))];
diag_log "----------------------------------------------------------------------------------------------------";
0 cutText[localize "STR_Init_ClientSetup", "BLACK FADED", 99999999];
_timeStamp = diag_tickTime;
waitUntil {
    !isNull(findDisplay 46)
};
waitUntil {
    !isSwitchingWeapon player
};
[] call compile preprocessFileLineNumbers "core\clientValidator.sqf";
enableSentences false;
player removeDiarySubject "Players";
player removeDiarySubject "Units";
diag_log "[Life Client] Initialization Variables";
[] call compile preprocessFileLineNumbers "core\configuration.sqf";
[] call Poltich_fnc_Notification_initMsgHUD;
diag_log "[Life Client] Variables initialized";
diag_log "[Life Client] Setting up Eventhandlers";
[] call life_fnc_setupEVH;
diag_log "[Life Client] Eventhandlers completed";
diag_log "[Life Client] Setting up user actions";
[] call life_fnc_setupActions;
diag_log "[Life Client] User actions completed";
diag_log "[Life Client] Waiting for the server to be ready...";
waitUntil {
    !isNil "life_server_isReady" && {
        !isNil "life_server_extDB_notLoaded"
    }
};
if (life_server_extDB_notLoaded) exitWith {
    0 cutText[localize "STR_Init_ExtdbFail", "BLACK FADED", 99999999];
};
waitUntil {
    life_server_isReady
};
diag_log "[Life Client] Server loading completed ";
0 cutText[localize "STR_Init_ServerReady", "BLACK FADED", 99999999];
private _typeConnection = [_this, 0, 0, [0]] call BIS_fnc_param;
[_typeConnection] call SOCK_fnc_dataQuery;
waitUntil {
    life_session_completed
};
0 cutText[localize "STR_Init_ClientFinish", "BLACK FADED", 99999999];
[] spawn life_fnc_escInterupt;
switch (playerSide) do {
    case west:
        {
            [] call life_fnc_initCop;
        };
    case civilian:
        {
            life_paycheck = LIFE_SETTINGS(getNumber, "paycheck_civ");
            [] call life_fnc_initCiv;
        };
    case independent:
        {
            [] call life_fnc_initMedic;
        };
}; player setVariable["restrained", false, true];
player setVariable["Escorting", false, true];
player setVariable["transporting", false, true];
player setVariable["playerSurrender", false, true];
player setVariable["realname", profileName, true];
player setVariable["steam64id", getPlayerUID player, true];
player setVariable["life_clientID", clientOwner, true];
diag_log "[Life Client] Past Settings Init";
diag_log "[Life Client] Executing client.fsm";
if (isNil "The_programmer_initialised") then {
    (findDisplay 46) displayAddEventHandler["KeyDown", "_this call life_fnc_keyHandler"];
    (findDisplay 46) displayAddEventHandler["KeyUp", {
        if ((_this select 1) == 219 && M3R_fcsModIU == true) then {
            call Rosenbach_fnc_focusMode_Out;
        };
    }];
    (findDisplay 46) displayAddEventHandler["MouseButtonDown", "_this spawn life_fnc_mouseButtonDown"];
};
[player, life_settings_enableSidechannel, playerSide] remoteExecCall["TON_fnc_manageSC", RSERV];
[] spawn life_fnc_survival;
0 cutText["", "BLACK IN"];
[] spawn {
    for "_i"
    from 0 to 1 step 0 do {
        waitUntil {
            (!isNull(findDisplay 49)) && {
                (!isNull(findDisplay 602))
            }
        };
        (findDisplay 49) closeDisplay 2;
        (findDisplay 602) closeDisplay 2;
    };
};
if (LIFE_SETTINGS(getNumber, "enable_fatigue") isEqualTo 0) then {
    player enableFatigue false;
};
life_fnc_RequestClientId = player;
publicVariableServer "life_fnc_RequestClientId"; {
    _x params[["_chan", -1, [0]], ["_noText", "false", [""]], ["_noVoice", "false", [""]]];
    _noText = [false, true] select((["false", "true"] find toLower _noText) max 0);
    _noVoice = [false, true] select((["false", "true"] find toLower _noVoice) max 0);
    _chan enableChannel[!_noText, !_noVoice];
}
forEach getArray(missionConfigFile >> "disableChannels");
if (life_HC_isActive) then {
    [getPlayerUID player, player getVariable["realname", name player]] remoteExec["HC_fnc_wantedProfUpdate", HC_Life];
} else {
    [getPlayerUID player, player getVariable["realname", name player]] remoteExec["life_fnc_wantedProfUpdate", RSERV];
};
[] call life_fnc_hudSetup;
tf_radio_channel_name = LIFE_SETTINGS(getText, "tf_radio_channel_name");
tf_no_auto_long_range_radio = true;
tf_terrain_interception_coefficient = 7;
player setVariable["tf_sendingDistanceMultiplicator", 10.0];
disableMapIndicators[true, true, true, true];
_adjustLight = {
    _brightness =
    if (CHBN_adjustBrightness > 0) then {
        200 * abs(1 - (2 ^ CHBN_adjustBrightness))
    } else {
        0
    };
    CHBN_light setLightAttenuation[10e10, (30000 / (_brightness max 10e-10)), 4.31918e-005, 4.31918e-005];
    CHBN_light setLightAmbient CHBN_adjustColor;
};
CHBN_adjustBrightness = missionNamespace getVariable["CHBN_adjustBrightness", 1.10];
CHBN_adjustColor = missionNamespace getVariable["CHBN_adjustColor", [0.3, 0.5, 1]];
if (!isNil "CHBN_light") then {
    deleteVehicle CHBN_light
};
CHBN_light = "#lightpoint"
createVehicleLocal[0, 0, 0];
CHBN_light setLightBrightness 1;
CHBN_light setLightDayLight false;
call _adjustLight;
if ((call life_adminlevel) < 1) then {
    showChat false;
};
[] spawn theprogrammer_core_fnc_clientInit;
[] spawn The_programmer_Duty_fnc_init_Service;
if (isNil "A4L_Autosave_Script") then {
    A4L_Autosave_Script = [] spawn life_fnc_autosave;
};
[] spawn A4L_Tablette_Metiers_Script_fnc_initAnimHandler;
[] spawn Poltich_fnc_Notification_initSettings;
call Rosenbach_fnc_Bubble_Init;
diag_log "----------------------------------------------------------------------------------------------------";
diag_log format["               End of Altis Life Client Init :: Total Execution Time %1 seconds ", (diag_tickTime - _timeStamp)];
diag_log "----------------------------------------------------------------------------------------------------";
if (life_firstSpawn && (_typeConnection isEqualTo 0)) then {
    life_firstSpawn = false;
    if (life_HC_isActive) then {
        [player] remoteExec["HC_fnc_getWelcomeNotification", HC_Life];
    } else {
        [] remoteExec["TON_fnc_getWelcomeNotification", RSERV];
    };
};
player action["SwitchWeapon", player, player, 100];
TP_Is_Player_Switching_Side = nil; {
    _curObjCheck = (_x select 1); {
        _object = _x;
        if (_object isEqualType objNull) then {
            if ((typeOf _object) isEqualTo "Land_InfoStand_V1_F") then {
                if (_object getVariable["company_object", objNull] isEqualTo objNull) then {
                    _object addAction[(["STR_ACTION_CHECK_STORAGE", "Max_Settings_Entreprise", "Entreprise_Localization"] call theprogrammer_core_fnc_localize), max_entreprise_fnc_openStockageCheck, "", 1.5, true, true, "", "(playerSide isEqualTo west) || (call life_adminlevel >= 5)", 5];
                    _object setVariable["company_object", _curObjCheck];
                };
            };
        };
    }
    forEach(_curObjCheck getVariable["entreprise_objects", []]);
}
forEach maxence_all_entreprises;
[player] remoteExec["SRV_Rosenbach_fnc_Email_initEmail", RSERV];