#include "..\..\script_macros.hpp"
private _cursTarget = param[0, ObjNull, [ObjNull]];
if (isNull _cursTarget) exitWith {};
life_interrupted = false;
if (life_action_inUse) exitWith {};
_distance = ((boundingBox _cursTarget select 1) select 0) + 2;
if (player distance _cursTarget > _distance) exitWith {};
_condition = ["civ_car_transp_fonds"] call life_fnc_getVehiclesInShop;
if (count(_condition) isEqualTo 0 || !(_condition isEqualType[])) exitWith {};
_isVehicle = (toLower(typeOf _cursTarget) in _condition);
if !(_isVehicle) exitWith {
    [localize "STR_ISTR_Blast_ArmoredVeh_Err_NotUseableObject", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_cursTarget in life_vehicles) exitWith {
    [localize "STR_ISTR_Blast_ArmoredVeh_Err_SafeBoxAlreadyOpen", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_title = localize "STR_ISTR_Blast_ArmoredVeh_LayingExplosiveCharge";
life_action_inUse = true;
[player, localize "STR_Bubble_NOTF_BlastingChargeUse", "Action"] call Rosenbach_fnc_Bubble_Display;
disableSerialization;
"progressBar"
cutRsc["life_progress", "PLAIN"];
_ui = uiNamespace getVariable "life_progress";
_progressBar = _ui displayCtrl 38201;
_titleText = _ui displayCtrl 38202;
_titleText ctrlSetText format["%2 (1%1)...", "%", _title];
_progressBar progressSetPosition 0.01;
_cP = 0.01;
for "_i"
from 0 to 1 step 0 do {
    if (animationState player != "AinvPknlMstpSnonWnonDnon_medic_1") then {
        [player, "AinvPknlMstpSnonWnonDnon_medic_1", true] remoteExecCall["life_fnc_animSync", RCLIENT];
        player switchMove "AinvPknlMstpSnonWnonDnon_medic_1";
        player playMoveNow "AinvPknlMstpSnonWnonDnon_medic_1";
    };
    uiSleep 0.26;
    if (isNull _ui) then {
        "progressBar"
        cutRsc["life_progress", "PLAIN"];
        _ui = uiNamespace getVariable "life_progress";
        _progressBar = _ui displayCtrl 38201;
        _titleText = _ui displayCtrl 38202;
    };
    _cP = _cP + 0.01;
    _progressBar progressSetPosition _cP;
    _titleText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _title];
    playSound3D["A3\sounds_f\structures\doors\metalbigdoors\metalbigdoorsslam.wss", player, false, getPosASL player, 1, 1, 250];
    if (_cP >= 1 || !alive player) exitWith {};
    if (life_istazed) exitWith {};
    if (life_isknocked) exitWith {};
    if (life_interrupted) exitWith {};
    if (player getVariable["restrained", false]) exitWith {};
    if (player distance _cursTarget > _distance) exitWith {
        _badDistance = true;
    };
};
"progressBar" cutText ["", "PLAIN"];
player playActionNow "stop";
if (!alive player || life_istazed || life_isknocked) exitWith {
    life_action_inUse = false;
};
if (player getVariable["restrained", false]) exitWith {
    life_action_inUse = false;
};
if (!isNil "_badDistance") exitWith {
    titleText[localize "STR_ISTR_Lock_TooFar", "PLAIN"];
    life_action_inUse = false;
};
if (life_interrupted) exitWith {
    life_interrupted = false;
    titleText[localize "STR_NOTF_ActionCancel", "PLAIN"];
    life_action_inUse = false;
};
if (!([false, "blastingcharge_vehicle", 1] call life_fnc_handleInv)) exitWith {
    life_action_inUse = false;
};
life_action_inUse = false;
_dice = random(100);
if (_dice < 80) then {
    titleText[localize "STR_ISTR_Blast_ArmoredVeh_ExplosiveChargePlanted", "PLAIN"];
    sleep 5;
    playSound3D["A3\sounds_f\weapons\explosion\gr_explosion_4.wss", _cursTarget];
    titleText[localize "STR_ISTR_Blast_ArmoredVeh_SafeBoxIsNowOpen", "PLAIN"];
    life_vehicles pushBack _cursTarget;
} else {
    titleText[localize "STR_ISTR_Blast_ArmoredVeh_ExplosiveChargeFailPlanted", "PLAIN"];
};