#include "..\..\script_macros.hpp"
private["_building", "_door", "_cpRate", "_title", "_progressBar", "_titleText", "_cp", "_ui"];
_building = param[0, objNull, [objNull]];
_boltcutterVirtItemClass = param[1, "", [""]];
private _vaultHouse = [
    [
        ["Altis", "Land_Research_house_V1_F"],
        ["Tanoa", "Land_Medevac_house_V1_F"],
        ["Malden", "Land_Medevac_house_V1_F"]
    ]
] call TON_fnc_terrainSort;
private _altisArray = [16019.5, 16952.9, 0];
private _tanoaArray = [11074.2, 11501.5, 0.00137329];
private _maldenArray = [6341.4, 10725.6, 0];
private _viceCityMap = [2709.52, 4713.18, 0.00143909];
private _pos = [
    [
        ["Altis", _altisArray],
        ["arm4life_vicecity", _viceCityMap],
        ["Tanoa", _tanoaArray],
        ["Malden", _maldenArray]
    ]
] call TON_fnc_terrainSort;
if (isNull _building) exitWith {};
if !(alive _building) exitWith {};
if (!(_building isKindOf "House_F")) exitWith {
    [localize "STR_ISTR_Bolt_NotNear", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (isClass(missionConfigFile >> "Housing" >> worldName >> (typeOf _building))) exitWith {
    [_building, _boltcutterVirtItemClass] call advanced_house_insurance_fnc_houseTheft;
};
if (((nearestObject[_pos, "Land_Dome_Big_F"]) == _building || (nearestObject[_pos, _vaultHouse]) == _building) && (west countSide playableUnits < (LIFE_SETTINGS(getNumber, "minimum_cops")))) exitWith {
    [format[localize "STR_Civ_NotEnoughCops", (LIFE_SETTINGS(getNumber, "minimum_cops"))], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((typeOf _building) == _vaultHouse && (nearestObject[_pos, "Land_Dome_Big_F"]) getVariable["locked", true]) exitWith {
    [localize "STR_ISTR_Bolt_Exploit", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (isNil "life_boltcutter_uses") then {
    life_boltcutter_uses = 0;
};
_door = [_building] call life_fnc_nearestDoor;
if (_door isEqualTo 0) exitWith {
    [localize "STR_Cop_NotaDoor", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_building getVariable[format["bis_disabled_Door_%1", _door], 0]) isEqualTo 0) exitWith {
    [localize "STR_House_Raid_DoorUnlocked", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((nearestObject[_pos, "Land_Dome_Big_F"]) == _building || (nearestObject[_pos, _vaultHouse]) == _building) then {
    [3, "STR_ISTR_Bolt_AlertFed", true, [], "Dispatch"] remoteExecCall["life_fnc_broadcast", west];
} else {};
_probaSon = random(100);
if (_probaSon >= 50) then {
    alarmSound = "#lightpoint"
    createVehicle(position player);
    [alarmSound, "alarme", 200, 1] remoteExec["life_fnc_say3D", 0];
};
life_action_inUse = true;
disableSerialization;
_title = localize "STR_ISTR_Bolt_Process";
"progressBar"
cutRsc["life_progress", "PLAIN"];
_ui = uiNamespace getVariable "life_progress";
_progressBar = _ui displayCtrl 38201;
_titleText = _ui displayCtrl 38202;
_titleText ctrlSetText format["%2 (1%1)...", "%", _title];
_progressBar progressSetPosition 0.01;
_cP = 0.01;
[player, localize "STR_Bubble_NOTF_Lockpick", "Action"] call Rosenbach_fnc_Bubble_Display;
switch (typeOf _building) do {
    case "Land_Dome_Big_F":
        {
            _cpRate = 0.003;
        }; case "Land_Medevac_house_V1_F";
    case "Land_Research_house_V1_F":
        {
            _cpRate = 0.0015;
        };
    default {
        _cpRate = 0.01;
    }
}; for "_i"
from 0 to 1 step 0 do {
    if (animationState player != "AinvPknlMstpSnonWnonDnon_medic_1") then {
        [player, "AinvPknlMstpSnonWnonDnon_medic_1", true] remoteExecCall["life_fnc_animSync", RCLIENT];
        player switchMove "AinvPknlMstpSnonWnonDnon_medic_1";
        player playMoveNow "AinvPknlMstpSnonWnonDnon_medic_1";
    };
    uiSleep 0.26;
    if (isNull _ui) then {
        "progressBar"
        cutRsc["life_progress", "PLAIN"];
        _ui = uiNamespace getVariable "life_progress";
        _progressBar = _ui displayCtrl 38201;
        _titleText = _ui displayCtrl 38202;
    };
    _cP = _cP + _cpRate;
    _progressBar progressSetPosition _cP;
    _titleText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _title];
    if (_cP >= 1 || !alive player) exitWith {};
    if (life_istazed) exitWith {};
    if (life_isknocked) exitWith {};
    if (life_interrupted) exitWith {};
};
"progressBar" cutText ["", "PLAIN"];
player playActionNow "stop";
if (!alive player || life_istazed || life_isknocked) exitWith {
    life_action_inUse = false;
};
if (player getVariable["restrained", false]) exitWith {
    life_action_inUse = false;
};
if (life_interrupted) exitWith {
    life_interrupted = false;
    titleText[localize "STR_NOTF_ActionCancel", "PLAIN"];
    life_action_inUse = false;
};
life_boltcutter_uses = life_boltcutter_uses + 1;
life_action_inUse = false;
if (life_boltcutter_uses >= 1) then {
    [false, "lockpick", 1] call life_fnc_handleInv;
    life_boltcutter_uses = 0;
};
_building setVariable[format["bis_disabled_Door_%1", _door], 0, true];
_building setVariable["locked", false, true];