#include "..\..\script_macros.hpp"
private["_startPos", "_kindOf", "_badDistance", "_title", "_ui", "_progress", "_pgText", "_cP", "_action", "_exit", "_fuelStationPump", "_fuelCost", "_fuelQuantity", "_isStealingFuel", "_titleConfirmAction", "_messageConfirmAction"];
params[["_cursObj", objNull, [objNull]]];
life_interrupted = false;
if (life_inv_fuelEmpty isEqualTo 0) exitWith {};
_exit = false;
_isStealingFuel = false;
_isNotEmpty = true;
_fuelCost = 0;
_fuelQuantity = 0;
_fuelStationPump = getArray(missionConfigFile >> "Life_Settings" >> "fuelStationPumps");
_titleConfirmAction = "";
_messageConfirmAction = "";
_kindOf = ""; {
    if (_cursObj isKindOf(configName _x)) exitWith {
        _kindOf = configName _x;
    };
}
forEach("true"
configClasses(missionConfigFile >> "Life_Cfg_Jerrycan"));
if (_kindOf isNotEqualTo "") then {
    if (player distance _cursObj > 4) exitWith {
        [localize "STR_ISTR_Lock_TooFar", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        _exit = true;
    };
    if (count(nearestObjects[_cursObj, _fuelStationPump, 22]) > 0) exitWith {
        [localize "STR_ISTR_Jerry_VehicleNearestOfFuelStation", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        _exit = true;
    };
    _fuelQuantity = M_CONFIG(getNumber, "Life_Cfg_Jerrycan", _kindOf, "fuelRequiredForSiphoning");
    if ((fuel _cursObj) < (_fuelQuantity)) exitWith {
        [localize "STR_ISTR_Jerry_VehicleNeedMoreFuel", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        _exit = true;
    };
    _isStealingFuel = true;
    _titleConfirmAction = localize "STR_ISTR_Jerry_StealFuel";
    _messageConfirmAction = localize "STR_ISTR_Jerry__StealFuel_PopUp";
} else {
    _cursObj = nearestObjects[player, _fuelStationPump, 3.5];
    if (count(_cursObj) isEqualTo 0) exitWith {
        [localize "STR_ISTR_Jerry_Distance", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        _exit = true;
    };
    _cursObj = _cursObj select 0;
    _fuelCost = LIFE_SETTINGS(getNumber, "fuelCan_refuel"); {
        _variable = _cursObj getVariable[_x, 0];
        if (((_x splitString "_") select 0) == "fuel") then {
            if (_variable > 0) exitWith {
                _isNotEmpty = false;
            };
        };
    }
    forEach(allVariables _cursObj);
    _titleConfirmAction = localize "STR_ISTR_Jerry_StationPump";
    _messageConfirmAction = format[localize "STR_ISTR_Jerry_PopUp", [_fuelCost] call life_fnc_numberText];
};
if (_isNotEmpty) exitWith {};
if (_exit) exitWith {};
if (life_action_inUse) exitWith {};
if !(isNull objectParent player) exitWith {};
if (player getVariable "restrained") exitWith {
    [localize "STR_NOTF_isrestrained", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (player getVariable "playerSurrender") exitWith {
    [localize "STR_NOTF_surrender", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
life_action_inUse = true;
_action = [_messageConfirmAction, _titleConfirmAction, localize "STR_Global_Yes", localize "STR_Global_No"] call BIS_fnc_guiMessage;
if (_action) then {
    if (CASH < _fuelCost) exitWith {
        [localize "STR_NOTF_NotEnoughMoney", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        life_action_inUse = false;
    };
    _startPos = getPos player;
    disableSerialization;
    "progressBar"
    cutRsc["life_progress", "PLAIN"];
    _title =
    if (_isStealingFuel) then {
        localize "STR_ISTR_Jerry_Steal_Refuel"
    } else {
        localize "STR_ISTR_Jerry_Refuel"
    };
    _ui = uiNamespace getVariable "life_progress";
    _progress = _ui displayCtrl 38201;
    _pgText = _ui displayCtrl 38202;
    _pgText ctrlSetText format["%2 (1%1)...", "%", _title];
    _progress progressSetPosition 0.01;
    _cP = 0.01;
    [player, localize "STR_Bubble_NOTF_JerryRefuel_JerryCan", "Action"] call Rosenbach_fnc_Bubble_Display;
    for "_i"
    from 0 to 1 step 0 do {
        if (animationState player != "AinvPknlMstpSnonWnonDnon_medic_1") then {
            [player, "AinvPknlMstpSnonWnonDnon_medic_1", true] remoteExecCall["life_fnc_animSync", RCLIENT];
            player switchMove "AinvPknlMstpSnonWnonDnon_medic_1";
            player playMoveNow "AinvPknlMstpSnonWnonDnon_medic_1";
        };
        uiSleep 0.2;
        if (isNull _ui) then {
            "progressBar"
            cutRsc["life_progress", "PLAIN"];
            _ui = uiNamespace getVariable "life_progress";
            _progressBar = _ui displayCtrl 38201;
            _titleText = _ui displayCtrl 38202;
        };
        _cP = _cP + 0.01;
        _progress progressSetPosition _cP;
        _pgText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _title];
        if (_cP >= 1) exitWith {};
        if (!alive player) exitWith {};
        if (life_interrupted) exitWith {};
        if ((_startPos distance _cursObj) > 4) exitWith {
            _badDistance = true;
        };
    };
    "progressBar" cutText ["", "PLAIN"];
    player playActionNow "stop";
    if (!alive player || life_istazed || life_isknocked) exitWith {
        life_action_inUse = false;
    };
    if (player getVariable["restrained", false]) exitWith {
        life_action_inUse = false;
    };
    if (!isNil "_badDistance") exitWith {
        titleText[localize "STR_ISTR_Lock_TooFar", "PLAIN"];
        life_action_inUse = false;
    };
    if (life_interrupted) exitWith {
        life_interrupted = false;
        titleText[localize "STR_NOTF_ActionCancel", "PLAIN"];
        life_action_inUse = false;
    };
    if (_isStealingFuel && (fuel _cursObj) < (_fuelQuantity)) exitWith {
        [localize "STR_ISTR_Jerry_VehicleNeedMoreFuel", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        life_action_inUse = false;
    };
    if (!([false, "fuelEmpty", 1] call life_fnc_handleInv)) exitWith {
        life_action_inUse = false;
    };
    life_action_inUse = false;
    CASH = CASH - _fuelCost;
    [true, "fuelFull", 1] call life_fnc_handleInv;
    [localize "STR_ISTR_Jerry_Refueled", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
    if (_isStealingFuel) then {
        _fuelQuantity = M_CONFIG(getNumber, "Life_Cfg_Jerrycan", _kindOf, "fuelSiphoning");
        if (!local _cursObj) then {
            [_cursObj, (fuel _cursObj) - _fuelQuantity] remoteExecCall["life_fnc_setFuel", _cursObj];
        } else {
            _cursObj setFuel((fuel _cursObj) - _fuelQuantity);
        };
    };
} else {
    [localize "STR_NOTF_ActionCancel", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
    closeDialog 0;
    life_action_inUse = false;
};