#include "..\..\script_macros.hpp"
private["_curTarget", "_distance", "_isVehicle", "_title", "_progressBar", "_cP", "_titleText", "_dice", "_badDistance"];
_curTarget = param[0, objNull, [objNull]];
life_interrupted = false;
if (life_action_inUse) exitWith {};
if (isNull _curTarget) exitWith {};
_distance = ((boundingBox _curTarget select 1) select 0) + 2;
if (player distance _curTarget > _distance) exitWith {};
_isVehicle =
if ((_curTarget isKindOf "LandVehicle") || (_curTarget isKindOf "Bicycle") || (_curTarget isKindOf "Ship") || (_curTarget isKindOf "Air")) then {
    true
} else {
    false
};
if (_isVehicle && _curTarget in life_vehicles) exitWith {
    [localize "STR_ISTR_Lock_AlreadyHave", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_transpFondsCondition = ["civ_car_transp_fonds"] call life_fnc_getVehiclesInShop;
if (toLower(typeOf _curTarget) in _transpFondsCondition) exitWith {
    [localize "STR_ISTR_Blast_ArmoredVeh_Err_NotGoodToolToForceIt", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (!_isVehicle && !isPlayer _curTarget) exitWith {};
if (!_isVehicle && !(_curTarget getVariable["restrained", false])) exitWith {};
if (_curTarget getVariable "NPC") exitWith {
    [localize "STR_NPC_Protected", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_title = format[localize "STR_ISTR_Lock_Process",
if (!_isVehicle) then {
    "Handcuffs"
} else {
    getText(configFile >> "CfgVehicles" >> (typeOf _curTarget) >> "displayName")
}];
life_action_inUse = true;
disableSerialization;
"progressBar"
cutRsc["life_progress", "PLAIN"];
_ui = uiNamespace getVariable "life_progress";
_progressBar = _ui displayCtrl 38201;
_titleText = _ui displayCtrl 38202;
_titleText ctrlSetText format["%2 (1%1)...", "%", _title];
_progressBar progressSetPosition 0.01;
_cP = 0.01;
[player, localize "STR_Bubble_NOTF_Lockpick", "Action"] call Rosenbach_fnc_Bubble_Display;
for "_i"
from 0 to 1 step 0 do {
    if (animationState player != "AinvPknlMstpSnonWnonDnon_medic_1") then {
        [player, "AinvPknlMstpSnonWnonDnon_medic_1", true] remoteExecCall["life_fnc_animSync", RCLIENT];
        player switchMove "AinvPknlMstpSnonWnonDnon_medic_1";
        player playMoveNow "AinvPknlMstpSnonWnonDnon_medic_1";
    };
    uiSleep 0.26;
    if (isNull _ui) then {
        "progressBar"
        cutRsc["life_progress", "PLAIN"];
        _ui = uiNamespace getVariable "life_progress";
        _progressBar = _ui displayCtrl 38201;
        _titleText = _ui displayCtrl 38202;
    };
    _cP = _cP + 0.01;
    _progressBar progressSetPosition _cP;
    _titleText ctrlSetText format["%3 (%1%2)...", round(_cP * 100), "%", _title];
    if (_isVehicle) then {
        playSound3D["A3\sounds_f\structures\doors\metalolddoors\metalolddoorsslam.wss", player, false, getPosASL player, 1, 1, 250];
    };
    if (_cP >= 1 || !alive player) exitWith {};
    if (life_istazed) exitWith {};
    if (life_isknocked) exitWith {};
    if (life_interrupted) exitWith {};
    if (player getVariable["restrained", false]) exitWith {};
    if (player distance _curTarget > _distance) exitWith {
        _badDistance = true;
    };
};
"progressBar" cutText ["", "PLAIN"];
player playActionNow "stop";
if (!alive player || life_istazed || life_isknocked) exitWith {
    life_action_inUse = false;
};
if (player getVariable["restrained", false]) exitWith {
    life_action_inUse = false;
};
if (!isNil "_badDistance") exitWith {
    titleText[localize "STR_ISTR_Lock_TooFar", "PLAIN"];
    life_action_inUse = false;
};
if (life_interrupted) exitWith {
    life_interrupted = false;
    titleText[localize "STR_NOTF_ActionCancel", "PLAIN"];
    life_action_inUse = false;
};
if (!([false, "lockpick", 1] call life_fnc_handleInv)) exitWith {
    life_action_inUse = false;
};
life_action_inUse = false;
if (!_isVehicle) then {
    [player, localize "STR_Bubble_NOTF_Unrestrain", "Action"] call Rosenbach_fnc_Bubble_Display;
    _curTarget setVariable["restrained", false, true];
    _curTarget setVariable["Escorting", false, true];
    _curTarget setVariable["transporting", false, true];
    _curTarget setVariable["tf_unable_to_use_radio", false, true];
    [] remoteExecCall["max_restrain_fnc_unrestrainAction", _curTarget];
} else {
    _dice = random(100);
    if (_dice < 30) then {
        titleText[localize "STR_ISTR_Lock_Success", "PLAIN"];
        _dbInfo = _curTarget getVariable["dbInfo", ["", "Location", 0]];
        [format["a lockpick un véhicule (%1 - %2 - %3).", _curTarget getVariable["vehicle_info_plate", getPlateNumber _curTarget], getText(configFile >> "CfgVehicles" >> typeOf _curTarget >> "displayName"), (_dbInfo # 1)]] call life_fnc_logs;
        life_vehicles pushBack _curTarget;
    } else {
        titleText[localize "STR_ISTR_Lock_Failed", "PLAIN"];
        [] call advanced_insurance_fnc_carAlarm;
    };
};