#include "..\..\script_macros.hpp"
if (dialog || life_action_inUse || life_is_processing) exitWith {};
private _vehicleList = []; {
    _vehicleList append(nearestObjects[player, [(_x select 0)], (_x select 1)]);
}
forEach[["Car", 10], ["Air", 25], ["Ship", 50]];
if (_vehicleList isEqualTo[]) exitWith {
    [localize "STR_NOTF_VehicleNear", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
disableSerialization;
createDialog "Life_FuelStat";
life_action_inUse = true;
private _fuelCost = LIFE_SETTINGS(getNumber, "fuel_cost");
uiNamespace setVariable["fuel_cost", _fuelCost];
ctrlSetText[20301, "Fuel Station"];
private _vehicleFuelList = []; {
    private _fuel = fuel _x;
    _vehicleFuelList pushBack[_x, _fuel];
}
forEach _vehicleList;
uiNamespace setVariable["fuel_list", _vehicleFuelList];
private _control = (findDisplay 20300) displayCtrl 20302;
lbClear _control;
ctrlSetText[20322, format[localize "STR_Price_Fuel_Pump", _fuelCost]];
ctrlSetText[20323, format["Total : %1€", _fuelCost * 0.1]]; {
    _x params["_vehicle", "_fuelLeft"];
    private _className = typeOf _vehicle;
    private _vehicleInfo = [_className] call life_fnc_fetchVehInfo;
    _control lbAdd((_x select 0) getVariable["vehicle_info_plate", getPlateNumber(_x select 0)]);
    _control lbSetPicture[_forEachIndex, (_vehicleInfo select 2)];
    _control lbSetData[_forEachIndex, _className];
}
forEach _vehicleFuelList;