#include "..\..\script_macros.hpp"
params[["_mode", true, [true]]];
if ((lbCurSel 2302) isEqualTo - 1) exitWith {
    [localize "STR_Shop_Veh_DidntPick", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    closeDialog 0;
};
if ((time - life_action_delay) < 0.2) exitWith {
    [localize "STR_NOTF_ActionDelay", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
life_action_delay = time;
private _className = lbData[2302, (lbCurSel 2302)];
private _vIndex = lbValue[2302, (lbCurSel 2302)];
private _shopSide = M_CONFIG(getText, "CarShops", (life_veh_shop select 0), "side");
switch (_shopSide) do {
    case "civ":
        {
            _shopSide = civilian;
        }; case "cop":
            {
                _shopSide = west;
            };
        case "med":
            {
                _shopSide = independent;
            };
}; if (_className isEqualTo "classname_not_exist") exitWith {
    [localize "STR_Shop_Veh_Disable_CfgVehicle_Not_found", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (!isClass(missionConfigFile >> "LifeCfgVehicles" >> _className)) exitWith {
    [localize "STR_Shop_Veh_Disable_LifeCfgVehicles_Not_found", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
private _initalPrice = M_CONFIG(getNumber, "LifeCfgVehicles", _className, "price");
if (M_CONFIG(getNumber, "LifeCfgVehicles", _className, "blocked_by_admin") isEqualTo 1) exitWith {
    [localize "STR_Shop_Veh_Disable_Blocked_by_Administrator", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
private _vehicleLimit_shop = M_CONFIG(getNumber, "CarShops", (life_veh_shop select 0), "vehicleLimit");
if (isNil "_vehicleLimit_shop") then {
    _vehicleLimit_shop = 20;
};
private _vehicleLimit_var = format["life_vehicleLimit_%1", (life_veh_shop select 0)];
private _vehicleLimit_player = player getVariable[_vehicleLimit_var, 0];
if (_vehicleLimit_player >= _vehicleLimit_shop) exitWith {
    [localize "STR_Shop_Veh_LimitReach", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (!life_use_atm) exitWith {
    [localize "STR_NOTF_recentlyRobbedBank_CarDealer", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    ctrlShow[2001, true];
};
private "_buyMultiplier";
private "_rentMultiplier";
switch (_shopSide) do {
    case civilian:
        {
            _buyMultiplier = LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_CIVILIAN");
            _rentMultiplier = LIFE_SETTINGS(getNumber, "vehicle_rental_multiplier_CIVILIAN");
        };
    case west:
        {
            _buyMultiplier = LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_COP");
            _rentMultiplier = LIFE_SETTINGS(getNumber, "vehicle_rental_multiplier_COP");
        };
    case independent:
        {
            _buyMultiplier = LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_MEDIC");
            _rentMultiplier = LIFE_SETTINGS(getNumber, "vehicle_rental_multiplier_MEDIC");
        };
    case east:
        {
            _buyMultiplier = LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_OPFOR");
            _rentMultiplier = LIFE_SETTINGS(getNumber, "vehicle_rental_multiplier_OPFOR");
        };
}; private "_purchasePrice";
if (_mode) then {
    _purchasePrice = round(_initalPrice * _buyMultiplier);
} else {
    _purchasePrice = round(_initalPrice * _rentMultiplier);
};
private _conditions = M_CONFIG(getText, "LifeCfgVehicles", _className, "conditions");
if !([_conditions] call life_fnc_levelCheck) exitWith {
    [localize "STR_Shop_Veh_NoLicense", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
private _colorIndex = lbValue[2304, (lbCurSel 2304)];
if (_purchasePrice < 0) exitWith {
    closeDialog 0;
};
private _spawnPoints = life_veh_shop select 1;
private _spawnPoint = "";
private _spawnPointUser = "";
if ((life_veh_shop select 0) isEqualTo "med_air_hs") then {
    if (nearestObjects[(getMarkerPos _spawnPoints), ["Air"], 5] isEqualTo[]) then {
        _spawnPoint = _spawnPoints
    };
    if (nearestObjects[(getMarkerPos _spawnPoints), ["CAManBase"], 5] isEqualTo[]) then {
        _spawnPointUser = _spawnPoints
    };
} else {
    if (_spawnPoints isEqualType[]) then {
        {
            if ((nearestObjects[(getMarkerPos _x), ["Car", "Bicycle", "Ship", "Air"], 5]) isEqualTo[]) then {
                _spawnPoint = _x
            };
            if ((nearestObjects[(getMarkerPos _x), ["CAManBase"], 5]) isEqualTo[]) then {
                _spawnPointUser = _x
            };
            if ((_spawnPoint isNotEqualTo "") && (_spawnPointUser isNotEqualTo "")) exitWith {};
            true
        }
        count _spawnPoints;
    } else {
        if (nearestObjects[(getMarkerPos _spawnPoints), ["Car", "Bicycle", "Ship", "Air"], 5] isEqualTo[]) then {
            _spawnPoint = _spawnPoints
        };
        if (nearestObjects[(getMarkerPos _spawnPoints), ["CAManBase"], 5] isEqualTo[]) then {
            _spawnPointUser = _spawnPoints
        };
    };
};
if (_spawnPoint isEqualTo "") exitWith {
    [] spawn the_programmer_bank_system_fnc_refundLastPaymentType;
    [localize "STR_Shop_Veh_Block", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    closeDialog 0;
};
if (_spawnPointUser isEqualTo "") exitWith {
    [] spawn the_programmer_bank_system_fnc_refundLastPaymentType;
    [localize "STR_Shop_Unit_Block", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    closeDialog 0;
};
_vehicleLimit_player = _vehicleLimit_player + 1;
player setVariable[_vehicleLimit_var, _vehicleLimit_player];
_handle = [_purchasePrice] spawn the_programmer_bank_system_fnc_paymentType;
waitUntil {
    scriptDone _handle
};
if (no_money) exitWith {};
if (_mode) then {
    [format[localize "STR_Shop_Veh_Bought", getText(configFile >> "CfgVehicles" >> _className >> "displayName"), [_purchasePrice] call life_fnc_numberText], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
} else {
    [format[localize "STR_Shop_Veh_Rented", getText(configFile >> "CfgVehicles" >> _className >> "displayName"), [_purchasePrice] call life_fnc_numberText], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
};
private "_vehicle";
_vehicle = createVehicle[_className, (getMarkerPos _spawnPoint), [], 0, "NONE"];
waitUntil {
    !isNil "_vehicle" && {
        !isNull _vehicle
    }
};
_vehicle allowDamage false;
_vehicle setPos(getMarkerPos _spawnPoint);
_vehicle setVectorUp(surfaceNormal(getMarkerPos _spawnPoint));
_vehicle setDir(markerDir _spawnPoint);
_vehicle lock 2;
[_vehicle, _colorIndex] call life_fnc_colorVehicle;
[_vehicle] call life_fnc_clearVehicleAmmo;
_vehicle setVariable["trunk_in_use", false, true];
_vehicle setVariable["vehicle_info_owners", [
    [getPlayerUID player, profileName]
], true];
_vehicle setVariable["vehicle_has_keys", [(getPlayerUID player)], true];
_vehicle setVariable["legit_owner", (getPlayerUID player), true];
_vehicle disableTIEquipment true;
switch (playerSide) do {
    case west:
        {
            [_vehicle, "cop_offroad", true] spawn life_fnc_vehicleAnimate;
        };
    case civilian:
        {
            if ((life_veh_shop select 2) isEqualTo "civ" && {
                _className == "B_Heli_Light_01_F"
            }) then {
                [_vehicle, "civ_littlebird", true] spawn life_fnc_vehicleAnimate;
            };
        };
    case independent:
        {
            [_vehicle, "med_offroad", true] spawn life_fnc_vehicleAnimate;
        };
}; _vehicle allowDamage true;
life_vehicles pushBack _vehicle;
[getPlayerUID player, playerSide, _vehicle, 1] remoteExecCall["TON_fnc_keyManagement", RSERV];
if (_mode) then {
    if (life_HC_isActive) then {
        [(getPlayerUID player), playerSide, _vehicle, _colorIndex] remoteExecCall["HC_fnc_vehicleCreate", HC_Life];
    } else {
        [(getPlayerUID player), playerSide, _vehicle, _colorIndex] remoteExecCall["TON_fnc_vehicleCreate", RSERV];
    };
};
if !(_mode) then {
    _vehicle setVariable["vehicle_insure_status", 1, true];
    _vehicle setVariable["vehicle_insurance_contract", (random 999999), true];
    private _currentDate = systemTimeUTC;
    if ((_currentDate select 2) > 28) then {
        _currentDate set[2, ((_currentDate select 2) - 5 - (random 5))];
    };
    private _endDate = +_currentDate;
    _endDate set[1, ((_endDate select 1) + 1)];
    if ((_endDate select 1) > 12) then {
        _endDate set[0, ((_endDate select 0) + 1)];
        _endDate set[1, 1];
    };
    _currentDate = _currentDate apply {
        if (_x < 10) then {
            "0" + str _x
        } else {
            str _x
        }
    };
    _endDate = _endDate apply {
        if (_x < 10) then {
            "0" + str _x
        } else {
            str _x
        }
    };
    _vehicle setVariable["vehicle_insurance_date", format["%1-%2-%3 %4:%5:%6", _currentDate # 0, _currentDate # 1, _currentDate # 2, _currentDate # 3, _currentDate # 4, _currentDate # 5], true];
    _vehicle setVariable["vehicle_insurance_expiration", format["%1-%2-%3 %4:%5:%6", _endDate # 0, _endDate # 1, _endDate # 2, _endDate # 3, _endDate # 4, _endDate # 5], true];
};
if (LIFE_SETTINGS(getNumber, "player_advancedLog") isEqualTo 1) then {
    if (LIFE_SETTINGS(getNumber, "battlEye_friendlyLogging") isEqualTo 1) then {
        advanced_log = format[localize "STR_DL_AL_boughtVehicle_BEF", _className, [_purchasePrice] call life_fnc_numberText, [CASH] call life_fnc_numberText, [BANK] call life_fnc_numberText];
    } else {
        advanced_log = format[localize "STR_DL_AL_boughtVehicle", profileName, (getPlayerUID player), _className, [_purchasePrice] call life_fnc_numberText, [CASH] call life_fnc_numberText, [BANK] call life_fnc_numberText];
    };
    publicVariableServer "advanced_log";
};
if !(_mode) then {
    [false, _vehicle] spawn max_immat_fnc_vehicleBuyImmatriculation;
};
if !(_mode) then {
    _vehicle setVariable["cantAttachTracker", true, true];
};
closeDialog 0;
true;