#include "..\..\script_macros.hpp" (_this select 3) params[["_shop", "", [""]], ["_sideCheck", sideUnknown, [civilian]], ["_spawnPoints", "", ["", []]], ["_shopFlag", "", [""]], ["_shopTitle", "", [""]], ["_disableBuy", false, [true]], ["_shopCategory", "", [""]], ["_isAllAccess", false, [false]]];
disableSerialization;
if (dialog) exitWith {};
if (_shop isEqualTo "") exitWith {};
if (life_action_inUse) exitWith {
    [localize "STR_NOTF_ActionInProc", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (!(_isAllAccess) && !(_sideCheck isEqualTo sideUnknown) && {
    !(playerSide isEqualTo _sideCheck)
}) exitWith {
    [localize "STR_Shop_Veh_NotAllowed", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if !(isClass(missionConfigFile >> "CarShops" >> _shop)) exitWith {
    [localize "STR_Shop_Veh_NoConfig", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
private _isShowroom = M_CONFIG(getNumber, "CarShops", _shop, "isShowroom") isEqualTo 1;
private _conditions = [M_CONFIG(getText, "CarShops", _shop, "conditions")] call life_fnc_levelCheck;
if !(_isShowroom || _conditions) exitWith {
    [localize "STR_Shop_Veh_NotAllowed", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_vehicleCategoriesCfg = missionConfigFile >> "CarShops" >> _shop >> "vehicleCategories";
if (isClass _vehicleCategoriesCfg && _shopCategory isEqualTo "") exitWith {
    [_shop, _sideCheck, _spawnPoints, _shopFlag, _shopTitle, _disableBuy, _shopCategory] spawn life_fnc_vehicleShopCategoryMenu;
};
_vehicleList =
if (_shopCategory isNotEqualTo "") then {
    getArray(_vehicleCategoriesCfg >> _shopCategory >> "vehicles");
} else {
    M_CONFIG(getArray, "CarShops", _shop, "vehicles");
};
if ((count _vehicleList) isEqualTo 0) exitWith {
    [localize "STR_Shop_Veh_NoVeh", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (LIFE_SETTINGS(getNumber, "vehicleShop_3D") isEqualTo 1) then {
    createDialog "Life_Vehicle_Shop_v2_3D";
} else {
    createDialog "Life_Vehicle_Shop_v2";
};
_disableBuy = !(_conditions && (M_CONFIG(getNumber, "CarShops", _shop, "canBuy") isEqualTo 1));
_disableRent = !(_conditions && (M_CONFIG(getNumber, "CarShops", _shop, "canRent") isEqualTo 1));
life_veh_shop = [_shop, _spawnpoints, _shopFlag, _disableBuy, _disableRent, _shopCategory, _isShowroom];
ctrlEnable[2309, _disableBuy];
ctrlEnable[2308, _disableRent];
ctrlSetText[2301, _shopTitle];
private _control = CONTROL(2300, 2302);
lbClear _control;
ctrlShow[2330, true];
ctrlShow[2304, false];
uiNameSpace setVariable["_vehicleList", _vehicleList]; {
    _x params["_className"];
    private _toShow = [_x] call life_fnc_levelCheck;
    if (_toShow) then {
        _classname_exist = isClass(configFile >> "CfgVehicles" >> _classname) && isClass(missionConfigFile >> "LifeCfgVehicles" >> _classname);
        _vehicle_exist = getText(configFile >> "CfgVehicles" >> _classname >> "simulation");
        if (_classname_exist isEqualTo false || _vehicle_exist isEqualTo "") then {
            _control lbAdd localize "STR_Shop_Veh_UI_Unavailable";
            _control lbSetPicture[(lbSize _control) - 1, "\A4L_Textures\mission\icons\ico_red_mark.paa"];
            _control lbSetData[(lbSize _control) - 1, "classname_not_exist"];
        } else {
            _vehicleInfo = [_className] call life_fnc_fetchVehInfo;
            if (M_CONFIG(getNumber, "LifeCfgVehicles", _className, "blocked_by_admin") isEqualTo 1) then {
                _control lbAdd localize "STR_Shop_Veh_UI_Disable";
                _control lbSetPicture[(lbSize _control) - 1, "\A4L_Textures\mission\icons\ico_red_mark.paa"];
            } else {
                _control lbAdd(_vehicleInfo select 3);
                _control lbSetPicture[(lbSize _control) - 1, (_vehicleInfo select 2)];
            };
            _control lbSetData[(lbSize _control) - 1, _className];
        };
        _control lbSetValue[(lbSize _control) - 1, _forEachIndex];
    };
}
forEach _vehicleList;
((findDisplay 2300) displayCtrl 2302) lbSetCurSel 0;
((findDisplay 2300) displayCtrl 2400) ctrlAddEventHandler["EditChanged", {
    _newText = _this select 1;
    _arr = _newText splitString " ";
    _vehicleList = uiNameSpace getVariable["_vehicleList", []];
    if (count(_vehicleList) < 1) exitWith {
        hint "error"
    };
    private _control = (findDisplay 2300) displayCtrl 2302;
    lbClear _control;
    ctrlShow[2330, true];
    ctrlShow[2304, false];
    _allVehiclesAdd = [];
    if (_newText == "") then {
        _allVehiclesAdd = +_vehicleList;
    } else {
        {
            _x params["_className"];
            _vl = _x;
            _displayName = getText(configFile >> "CfgVehicles" >> _className >> "displayName");
            _searchText = toLower(_newText);
            _displayName = toLower(_displayName);
            if (((_displayName find _searchText) != -1) OR((_searchText find _displayName) != -1)) then {
                if (_vl in _allVehiclesAdd) exitWith {};
                _allVehiclesAdd pushBack _vl;
            };
        }
        forEach _vehicleList;
    }; {
        _x params["_className"];
        private _toShow = [_x] call life_fnc_levelCheck;
        if (_toShow) then {
            _classname_exist = isClass(configFile >> "CfgVehicles" >> _classname) && isClass(missionConfigFile >> "LifeCfgVehicles" >> _classname);
            _vehicle_exist = getText(configFile >> "CfgVehicles" >> _classname >> "simulation");
            if (_classname_exist isEqualTo false || _vehicle_exist isEqualTo "") then {
                _control lbAdd localize "STR_Shop_Veh_UI_Unavailable";
                _control lbSetPicture[(lbSize _control) - 1, "\A4L_Textures\mission\icons\ico_red_mark.paa"];
                _control lbSetData[(lbSize _control) - 1, "classname_not_exist"];
            } else {
                _vehicleInfo = [_className] call life_fnc_fetchVehInfo;
                if (M_CONFIG(getNumber, "LifeCfgVehicles", _className, "blocked_by_admin") isEqualTo 1) then {
                    _control lbAdd localize "STR_Shop_Veh_UI_Disable";
                    _control lbSetPicture[(lbSize _control) - 1, "\A4L_Textures\mission\icons\ico_red_mark.paa"];
                } else {
                    _control lbAdd(_vehicleInfo select 3);
                    _control lbSetPicture[(lbSize _control) - 1, (_vehicleInfo select 2)];
                };
                _control lbSetData[(lbSize _control) - 1, _className];
            };
            _control lbSetValue[(lbSize _control) - 1, _forEachIndex];
        };
    }
    forEach _allVehiclesAdd;
}];