#include "..\..\script_macros.hpp"
disableSerialization;
private["_price", "_item", "_itemInfo", "_bad"];
if ((lbCurSel 38403) isEqualTo - 1) exitWith {
    [localize "STR_Shop_Weapon_NoSelect", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_price = lbValue[38403, (lbCurSel 38403)];
if (isNil "_price") then {
    _price = 0;
};
_item = lbData[38403, (lbCurSel 38403)];
_itemInfo = [_item] call life_fnc_fetchCfgDetails;
_bad = "";
_amount = parseNumber(ctrlText 202824);
if (_amount < 1) exitWith {
    ["Oups ! Le caractère attendu doit être un nombre supérieur ou égal à 1", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((_itemInfo select 6) != "CfgVehicles" && (_itemInfo select 4) in [4096, 131072]) then {
    if (!(player canAdd[_item, _amount]) && (uiNamespace getVariable["Weapon_Shop_Filter", 0]) != 1) exitWith {
        _bad = (localize "STR_NOTF_NoRoom")
    };
};
if (_bad != "") exitWith {
    [_bad, "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((uiNamespace getVariable["Weapon_Shop_Filter", 0]) isEqualTo 1) then {
    ((findDisplay 38400) displayCtrl 202824) ctrlEnable false;
    ((findDisplay 38400) displayCtrl 202624) ctrlEnable false;
    CASH = CASH + _price;
    [format["a vendu (%3) un %1 pour %2€", _item, _price, _amount]] call life_fnc_logs;
    [_item, false] call life_fnc_handleItem;
    [format[localize "STR_Shop_Weapon_Sold", _itemInfo select 1, [_price] call life_fnc_numberText], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
    [nil, (uiNamespace getVariable["Weapon_Shop_Filter", 0])] call life_fnc_weaponShopFilter;
} else {
    ((findDisplay 38400) displayCtrl 202824) ctrlEnable true;
    ((findDisplay 38400) displayCtrl 202624) ctrlEnable true;
    private _altisArray = ["Land_u_Barracks_V2_F", "Land_i_Barracks_V2_F"];
    private _maldenArray = ["Land_u_Barracks_V2_F", "Land_i_Barracks_V2_F"];
    private _viceCityArray = ["Land_u_Barracks_V2_F", "Land_i_Barracks_V2_F"];
    private _tanoaArray = ["Land_School_01_F", "Land_Warehouse_03_F", "Land_House_Small_02_F"];
    private _hideoutObjs = [
        [
            ["arm4life_vicecity", _viceCityArray],
            ["Altis", _altisArray],
            ["Tanoa", _tanoaArray],
            ["Malden", _maldenArray]
        ]
    ] call TON_fnc_terrainSort;
    private _hideout = (nearestObjects[getPosATL player, _hideoutObjs, 25]) select 0;
    if (!isNil "_hideout" && {
        !isNil {
            group player getVariable "gang_bank"
        }
    } && {
        (group player getVariable "gang_bank") >= _price
    }) then {
        _action = [format[(localize "STR_Shop_Virt_Gang_FundsMSG") + "<br/><br/>" + (localize "STR_Shop_Virt_Gang_Funds") + " <t color='#8cff9b'>%1€</t><br/>" + (localize "STR_Shop_Virt_YourFunds") + " <t color='#8cff9b'>%2€</t>", [GANG_FUNDS] call life_fnc_numberText, [CASH] call life_fnc_numberText], localize "STR_Shop_Virt_YourorGang", localize "STR_Shop_Virt_UI_GangFunds", localize "STR_Shop_Virt_UI_YourCash"] call BIS_fnc_guiMessage;
        if (_action) then {
            [format[localize "STR_Shop_Weapon_BoughtGang", _itemInfo select 1, [(_price * _amount)] call life_fnc_numberText, _amount], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
            _funds = group player getVariable "gang_bank";
            _funds = _funds - (_price * _amount);
            group player setVariable["gang_bank", _funds, true];
            for "_i"
            from 1 to _amount do {
                [_item, true] call life_fnc_handleItem;
            }; if (life_HC_isActive) then {
                [1, group player] remoteExecCall["HC_fnc_updateGang", HC_Life];
            } else {
                [1, group player] remoteExecCall["TON_fnc_updateGang", RSERV];
            };
        } else {
            if ((_price * _amount) > CASH) exitWith {
                [localize "STR_NOTF_NotEnoughMoney", "Error"] spawn Poltich_fnc_Notification_handleMsg;
            };
            [format[localize "STR_Shop_Weapon_BoughtItem", _itemInfo select 1, [(_price * _amount)] call life_fnc_numberText, _amount], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
            CASH = CASH - (_price * _amount);
            for "_i"
            from 1 to _amount do {
                [_item, true] call life_fnc_handleItem;
            };
        };
    } else {
        if ((_price * _amount) > CASH) exitWith {
            [localize "STR_NOTF_NotEnoughMoney", "Error"] spawn Poltich_fnc_Notification_handleMsg;
        };
        [format["a achete %3 %1 pour %2€", _item, (_price * _amount), _amount]] call life_fnc_logs;
        [format[localize "STR_Shop_Weapon_BoughtItem", _itemInfo select 1, [(_price * _amount)] call life_fnc_numberText, _amount], "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
        CASH = CASH - (_price * _amount);
        for "_i"
        from 1 to _amount do {
            [_item, true] call life_fnc_handleItem;
        };
    };
};
[0] call SOCK_fnc_updatePartial;
[3] call SOCK_fnc_updatePartial;