#include "..\..\script_macros.hpp"
private["_vehicle", "_veh_data"];
if (dialog) exitWith {};
_vehicle = [_this, 0, objNull, [objNull]] call BIS_fnc_param;
_filters = ["Car", "Bicycle", "Air", "Ship", "Box_IND_Grenades_F", "B_supplyCrate_F", "A4L_Lescot_Coffre_Maison1", "A4L_Lescot_Coffre_Maison2"];
if (isNull _vehicle || !((KINDOF_ARRAY(_vehicle, _filters)))) exitWith {};
if ((_vehicle getVariable["trunk_in_use", false])) exitWith {
    [localize "STR_MISC_VehInvUse", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_vehicle setVariable["trunk_in_use", true, true];
_vehicle setVariable["trunk_in_use_by", (getPlayerUID player), true];
if (!createDialog "TrunkMenu") exitWith {
    [localize "STR_MISC_DialogError", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
disableSerialization;
if (_vehicle isKindOf "Box_IND_Grenades_F" || _vehicle isKindOf "B_supplyCrate_F" || _vehicle isKindOf "A4L_Lescot_Coffre_Maison1" || _vehicle isKindOf "A4L_Lescot_Coffre_Maison2") then {
    ctrlSetText[3501, format[(localize "STR_MISC_HouseStorage") + " - %1", getText(configFile >> "CfgVehicles" >> (typeOf _vehicle) >> "displayName")]];
} else {
    ctrlSetText[3501, format[(localize "STR_MISC_VehStorage") + " - %1", getText(configFile >> "CfgVehicles" >> (typeOf _vehicle) >> "displayName")]];
};
_veh_data = [_vehicle] call life_fnc_vehicleWeight;
if (_veh_data select 0 isEqualTo - 1) exitWith {
    closeDialog 0;
    _vehicle setVariable["trunk_in_use", false, true];
    [localize "STR_MISC_NoStorageVeh", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (vehicle player isEqualTo player) then {
    player playMoveNow "AinvPercMstpSnonWnonDnon";
};
ctrlSetText[3504, format[(localize "STR_MISC_Weight") + " %1/%2", _veh_data select 1, _veh_data select 0]];
[_vehicle] call life_fnc_vehInventory;
life_trunk_vehicle = _vehicle;
life_exit_veh = false;
[_vehicle] spawn {
    _vehicle = _this select 0;
    _vehicle setVariable["antiDupe", (getPlayerUID player), true];
    sleep(random 4);
    if ((_vehicle getVariable["antiDupe", -1]) isNotEqualTo(getPlayerUID player)) exitWith {
        life_exit_veh = true;
        closeDialog 0;
    };
};
_vehicle spawn {
    waitUntil {
        isNull(findDisplay 3500)
    };
    if (life_exit_veh) exitWith {};
    _this setVariable["trunk_in_use", false, true];
    if (_this isKindOf "Box_IND_Grenades_F" || _this isKindOf "B_supplyCrate_F" || _this isKindOf "A4L_Lescot_Coffre_Maison1" || _this isKindOf "A4L_Lescot_Coffre_Maison2") then {
        if (life_HC_isActive) then {
            [_this] remoteExecCall["HC_fnc_updateHouseTrunk", HC_Life];
        } else {
            [_this] remoteExecCall["TON_fnc_updateHouseTrunk", 2];
        };
    };
};
if (LIFE_SETTINGS(getNumber, "save_vehicle_virtualItems") isEqualTo 1) then {
    _vehicle spawn {
        waitUntil {
            isNull(findDisplay 3500)
        };
        if (life_exit_veh) exitWith {};
        _this setVariable["trunk_in_use", false, true];
        if ((_this isKindOf "Car") || (_this isKindOf "Bicycle") || (_this isKindOf "Air") || (_this isKindOf "Ship")) then {
            [] call SOCK_fnc_updateRequest;
            if (life_HC_isActive) then {
                [_this, 2] remoteExecCall["HC_fnc_vehicleUpdate", HC_Life];
            } else {
                [_this, 2] remoteExecCall["TON_fnc_vehicleUpdate", 2];
            };
        };
    };
};