#include "..\..\script_macros.hpp"
# define ctrlSelData(ctrl)(lbData[# # ctrl, (lbCurSel # # ctrl)])
private["_ctrl", "_num", "_totalWeight", "_itemWeight", "_veh_data", "_inv", "_index", "_val"];
disableSerialization;
if ((life_trunk_vehicle getVariable["trunk_in_use_by", (getPlayerUID player)]) != (getPlayerUID player)) exitWith {
    closeDialog 0;
    [localize "STR_MISC_VehInvUse", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (life_action_inUse) exitWith {
    closeDialog 0;
};
_ctrl = ctrlSelData(3503);
_num = ctrlText 3506;
if (!([_num] call TON_fnc_isnumber)) exitWith {
    [localize "STR_MISC_WrongNumFormat", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_num = parseNumber(_num);
if (_num < 1) exitWith {
    [localize "STR_MISC_Under1", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_totalWeight = [life_trunk_vehicle] call life_fnc_vehicleWeight;
_itemWeight = ([_ctrl] call life_fnc_itemWeight) * _num;
_veh_data = life_trunk_vehicle getVariable["Trunk", [
    [], 0]];
_inv = _veh_data select 0;
_isBlacklist = false; {
    if (life_trunk_vehicle isKindOf _x) exitWith {
        _isBlacklist = true;
    };
}
forEach M_CONFIG(getArray, "VirtualItems", _ctrl, "blacklistVehicleType");
if (_isBlacklist) exitWith {
    [localize "STR_NOTF_cantStoreInThisKindOfVeh", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (_ctrl == "money") then {
    _index = [_ctrl, _inv] call TON_fnc_index;
    if (CASH < _num) exitWith {
        [localize "STR_NOTF_notEnoughCashToStoreInVeh", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    if (_index isEqualTo - 1) then {
        _inv pushBack[_ctrl, _num];
    } else {
        _val = _inv select _index select 1;
        _inv set[_index, [_ctrl, _val + _num]];
    };
    CASH = CASH - _num;
    [0] call SOCK_fnc_updatePartial;
    life_trunk_vehicle setVariable["Trunk", [_inv, (_veh_data select 1) + _itemWeight], true];
    [life_trunk_vehicle] call life_fnc_vehInventory;
} else {
    if (((_totalWeight select 1) + _itemWeight) > (_totalWeight select 0)) exitWith {
        [localize "STR_NOTF_VehicleFullOrInsufCap", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    if ((time - life_action_delay) < 0.3) exitWith {
        [localize "STR_NOTF_ActionDelay", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    life_action_delay = time;
    if (!([false, _ctrl, _num] call life_fnc_handleInv)) exitWith {
        [localize "STR_CouldNotRemoveItemsToPutInVeh", "Error"] spawn Poltich_fnc_Notification_handleMsg;
    };
    _index = [_ctrl, _inv] call TON_fnc_index;
    if (_index isEqualTo - 1) then {
        _inv pushBack[_ctrl, _num];
    } else {
        _val = _inv select _index select 1;
        _inv set[_index, [_ctrl, _val + _num]];
    };
    [3] call SOCK_fnc_updatePartial;
    life_trunk_vehicle setVariable["Trunk", [_inv, (_veh_data select 1) + _itemWeight], true];
    [life_trunk_vehicle] call life_fnc_vehInventory;
};