#include "..\..\script_macros.hpp"
disableSerialization;
private["_control", "_index", "_className", "_dataArr", "_colors", "_vehicleColor", "_colorVehicle", "_trunk", "_gear", "_immatriculation", "_vehicleInfo", "_trunkSpace", "_sellPrice", "_retrievePrice", "_sellMultiplier", "_price", "_storageFee", "_purchasePrice", "_titleItem", "_textItem", "_iconItem", "_tooltipItem", "_itemInfo", "_tmpIndex", "_tmpList"];
_control = _this select 0;
_index = _this select 1;
_dataArr = CONTROL_DATAI(_control, _index);
ctrlEnable[2808, false];
ctrlEnable[2809, false];
ctrlShow[2810, false];
ctrlShow[2831, false];
lbClear 2810;
_dataArr = parseSimpleArray format["%1", _dataArr];
if ((_dataArr select 0) isEqualTo "classname_not_exist") exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1<br/>Classname : %2<br/>Id : %3</t>", localize "STR_Shop_Veh_Disable_CfgVehicle_Not_found", (_dataArr select 1), (_dataArr select 2)];
    ctrlShow[2803, true];
    if (!isNull life_3dPreview_object) then {
        deleteVehicle life_3dPreview_object;
    };
};
_className = (_dataArr select 0);
if (!isClass(missionConfigFile >> "LifeCfgVehicles" >> _className)) exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1<br/>Classname : %2</t>", localize "STR_Shop_Veh_Disable_LifeCfgVehicles_Not_found", _className];
    ctrlShow[2803, true];
    if (!isNull life_3dPreview_object) then {
        deleteVehicle life_3dPreview_object;
    };
};
_vehicleColor = Nil;
_colorVehicle = (_dataArr select 1);
_colors = M_CONFIG(getArray, "LifeCfgVehicles", _className, "textures");
_customColorVehicle = (_dataArr select 10);
_trunk = (_dataArr select 2);
_gear = (_dataArr select 3);
if (_customColorVehicle isEqualTo[]) then {
    if (((count _colors > 0) && ((_dataArr select 1) <= ((count _colors) - 1)))) then {
        _vehicleColor = ((_colors #(_dataArr select 1)) # 0);
        _colorVehicle = ((_colors #(_dataArr select 1)) # 2);
    } else {
        _vehicleColor = "Par défaut";
        _colorVehicle = "0";
    };
} else {
    _vehicleColor = "Personnalisée";
    _colorVehicle = _customColorVehicle;
};
if (isNil "_vehicleColor") then {
    _vehicleColor = "Par défaut";
    _colorVehicle = "0";
};
_immatriculation = (_dataArr select 4);
if (_immatriculation == "0") then {
    _immatriculation = "Aucune"
};
_fuelQuantity = (_dataArr select 13);
_VehicleDamage = (_dataArr select 12);
_vehicleDamageArr = [];
_vehicleDamageText = "Pas endommagé";
if (!isNil "_VehicleDamage" && {
    typeName _VehicleDamage == "ARRAY"
} && {
    count _VehicleDamage > 0
}) then {
    _parts = getAllHitPointsDamage life_3dPreview_object;
    for "_i"
    from 0 to((count _VehicleDamage) - 1) do {
        if ((_VehicleDamage select _i) != 0) then {
            _vehicleDamageArr pushBack format["%1", ((_parts select 0) select _i), _VehicleDamage select _i];
        };
    }; _vehicleDamageText = format["Endroit(s) ou le véhicule est endommagé : %1", _vehicleDamageArr];
};
_vehicleInfo = [_className] call life_fnc_fetchVehInfo;
_trunkSpace = [_className] call life_fnc_vehicleWeightCfg;
_vehicleInfo pushBack _immatriculation;
_vehicleInfo pushBack _colorVehicle;
[_className, _vehicleInfo] call life_fnc_3dPreviewDisplay;
if ((_dataArr select 9) isEqualTo 1) exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1</t>", localize "STR_Shop_Veh_Disable_InFourriere"];
    ctrlShow[2803, true];
};
_price = M_CONFIG(getNumber, "LifeCfgVehicles", _className, "price");
_storageFee = LIFE_SETTINGS(getNumber, "vehicle_storage_fee_multiplier");
if (M_CONFIG(getNumber, "LifeCfgVehicles", _className, "blocked_by_admin") isEqualTo 1) exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1</t>", localize "STR_Shop_Veh_Disable_Blocked_by_Administrator"];
    ctrlShow[2803, true];
};
switch (playerSide) do {
    case civilian:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_CIVILIAN");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_CIVILIAN");
        };
    case west:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_COP");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_COP");
        };
    case independent:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_MEDIC");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_MEDIC");
        };
    case east:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_OPFOR");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_OPFOR");
        };
}; _retrievePrice = _purchasePrice * _storageFee;
_sellPrice = _purchasePrice * _sellMultiplier;
if (!(_sellPrice isEqualType 0) || _sellPrice < 1) then {
    _sellPrice = 500;
};
if (!(_retrievePrice isEqualType 0) || _retrievePrice < 1) then {
    _retrievePrice = 5;
};
tvClear 2810;
_titleItem =
if !(_trunkSpace isEqualTo - 1) then[{
    format[localize "STR_Garage_VirtualInventory", (_trunk select 1), _trunkSpace]
}, {
    format[localize "STR_Garage_VirtualInventory", 0, 0]
}];
tvAdd[2810, [], _titleItem];
if !(_trunk isEqualTo[[], 0]) then {
    {
        if (isClass(missionConfigFile >> "VirtualItems" >> (_x select 0))) then {
            _textItem = format["%1 (%2)", localize ITEM_NAME((_x select 0)), (_x select 1)];
            _tooltipItem = format[localize "STR_Garage_ItemQuantity", (_x select 1)];
            _iconItem = getText(missionConfigFile >> "VirtualItems" >> (_x select 0) >> "icon");
        } else {
            _textItem = format[localize "STR_Garage_ErrItemClassname", (_x select 0), (_x select 1)];
            _tooltipItem = localize "STR_Global_ErrorPleaseContactStaff";
            _iconItem = "\A4L_Textures\mission\icons\ico_red_mark.paa";
        };
        tvAdd[2810, [0], _textItem];
        tvSetTooltip[2810, [0, _forEachIndex], _tooltipItem];
        if !(_iconItem isEqualTo "") then {
            tvSetPicture[2810, [0, _forEachIndex], _iconItem];
        };
    }
    forEach(_trunk select 0);
} else {
    tvAdd[2810, [0], localize "STR_Garage_NoItemInCar"];
};
tvAdd[2810, [], localize "STR_Garage_PhysicalInventory"];
_tmpIndex = 0;
if !(_gear isEqualTo[]) then {
    {
        _tmpList = (_gear # _forEachIndex);
        if !(_tmpList isEqualTo[[], []]) then {
            tvAdd[2810, [1], localize _x]; {
                if !(_x isEqualTo '') then {
                    _itemInfo = [_x] call life_fnc_fetchCfgDetails;
                    if !(_itemInfo isEqualTo[]) then {
                        _textItem = format["%1 (%2)", (_itemInfo # 1), ((_tmpList # 1) # _forEachIndex)];
                        _tooltipItem = format[localize "STR_Garage_ItemQuantity", ((_tmpList # 1) # _forEachIndex)];
                        _iconItem = (_itemInfo # 2);
                    } else {
                        _textItem = format[localize "STR_Garage_ErrItemClassname", _x, ((_tmpList # 1) # _forEachIndex)];
                        _tooltipItem = localize "STR_Global_ErrorPleaseContactStaff";
                        _iconItem = "\A4L_Textures\mission\icons\ico_red_mark.paa";
                    };
                } else {
                    _textItem = localize "STR_Garage_ErrItemBdd";
                    _tooltipItem = localize "STR_Global_ErrorPleaseContactStaff";
                    _iconItem = "\A4L_Textures\mission\icons\ico_red_mark.paa";
                };
                tvAdd[2810, [1, _tmpIndex], _textItem];
                tvSetTooltip[2810, [1, _tmpIndex, _forEachIndex], _tooltipItem];
                tvSetPicture[2810, [1, _tmpIndex, _forEachIndex], _iconItem];
            }
            forEach(_tmpList # 0);
            _tmpIndex = _tmpIndex + 1;
        };
    }
    forEach["STR_Garage_PhysInvCatItems", "STR_Garage_PhysInvCatMagazines", "STR_Garage_PhysInvCatWeapons", "STR_Garage_PhysInvCatBackpack"];
} else {
    tvAdd[2810, [1], localize "STR_Garage_NoItemInCar"];
};
tvExpandAll 2810;
ctrlShow[2810, true];
ctrlShow[2831, true];
_trackerDate = _dataArr select 14;
_trackerMessage = "";
if (count(_trackerDate) > 0) then {
    _trackerDate = format["%1/%2/%3 à %4h%5", _trackerDate select 2, _trackerDate select 1, _trackerDate select 0, _trackerDate select 3, _trackerDate select 4];
    _trackerMessage = format["Traceur posé le : %1 (Dispo 30J)", _trackerDate];
} else {
    _trackerMessage = "Pas de traceur";
};
(CONTROL(2800, 2803)) ctrlSetStructuredText parseText format[(localize "STR_Shop_Veh_UI_RetrievalP") + " <t color='#8cff9b'>%1€</t><br/>" + (localize "STR_Shop_Veh_UI_SellP") + "<t color='#8cff9b'>%2€</t><br/>" + "Contrôle technique: %9<br/>" + ([(_dataArr select 5), (_dataArr select 6), (_dataArr select 7)] call advanced_insurance_fnc_insuranceStatus) + (localize "STR_Shop_Veh_UI_Color") + " %7<br/>" + "Plaque d'immatriculation: <t color='#8cff9b'>%8</t><br/>" + (localize "STR_Shop_Veh_UI_MaxSpeed") + " %3 km/h<br/>" + (localize "STR_Shop_Veh_UI_HPower") + " %4<br/>" + (localize "STR_Shop_Veh_UI_PSeats") + " %5<br/>" + (localize "STR_Shop_Veh_UI_FuelType") + " %10<br/>Réservoir :  %11 /100<br/>%12<br/>", [_retrievePrice] call life_fnc_numberText, [_sellPrice] call life_fnc_numberText, (_vehicleInfo select 8), (_vehicleInfo select 11), (_vehicleInfo select 10), (_vehicleInfo select 12), _vehicleColor, _immatriculation, [(_dataArr select 8), (_dataArr select 11)] call max_controltech_fnc_inspectionStatus, [_className] call max_fuelstations_fnc_getFuelType, round(_fuelQuantity * 100), _trackerMessage];
ctrlShow[2803, true];
ctrlEnable[2809, true];
true;