#include "..\..\script_macros.hpp"
disableSerialization;
private["_control", "_index", "_className", "_dataArr", "_trunk", "_gear", "_vehicleColor", "_vehicleInfo", "_trunkSpace", "_sellPrice", "_retrievePrice", "_sellMultiplier", "_price", "_storageFee", "_purchasePrice", "_titleItem", "_textItem", "_iconItem", "_tooltipItem", "_itemInfo", "_tmpIndex", "_tmpList"];
_control = _this select 0;
_index = _this select 1;
_dataArr = CONTROL_DATAI(_control, _index);
ctrlEnable[2804, true];
ctrlShow[2805, false];
ctrlShow[2831, false];
if (_dataArr isEqualTo "classname_not_exist") exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1</t>", localize "STR_Shop_Veh_Disable_CfgVehicle_Not_found"];
    ctrlEnable[2804, false];
    (CONTROL(2800, 2803)) ctrlSetPositionH(ctrlTextHeight(CONTROL(2800, 2803)));
    (CONTROL(2800, 2803)) ctrlCommit 0;
};
_dataArr = parseSimpleArray format["%1", _dataArr];
_className = (_dataArr select 0);
_trunk = (_dataArr select 2);
_gear = (_dataArr select 3);
if (!isClass(missionConfigFile >> "LifeCfgVehicles" >> _className)) exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1</t>", localize "STR_Shop_Veh_Disable_LifeCfgVehicles_Not_found"];
    ctrlEnable[2804, false];
    (CONTROL(2800, 2803)) ctrlSetPositionH(ctrlTextHeight(CONTROL(2800, 2803)));
    (CONTROL(2800, 2803)) ctrlCommit 0;
};
if ((_dataArr select 9) isEqualTo 1) exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1</t>", localize "STR_Shop_Veh_Disable_InFourriere"];
    ctrlEnable[2804, false];
    (CONTROL(2800, 2803)) ctrlSetPositionH(ctrlTextHeight(CONTROL(2800, 2803)));
    (CONTROL(2800, 2803)) ctrlCommit 0;
};
_vehicleColor = Nil;
_colors = M_CONFIG(getArray, "LifeCfgVehicles", _className, "textures");
_vehicleColor =
if ((count _colors > 0) && ((_dataArr select 1) <= ((count _colors) - 1))) then[{
    ((_colors #(_dataArr select 1)) # 0)
}, {
    "Par défaut"
}];
if (isNil "_vehicleColor") then {
    _vehicleColor = "Par défaut";
};
_vehicleInfo = [_className] call life_fnc_fetchVehInfo;
_trunkSpace = [_className] call life_fnc_vehicleWeightCfg;
_price = M_CONFIG(getNumber, "LifeCfgVehicles", _className, "price");
_storageFee = LIFE_SETTINGS(getNumber, "vehicle_storage_fee_multiplier");
if (M_CONFIG(getNumber, "LifeCfgVehicles", _className, "blocked_by_admin") isEqualTo 1) exitWith {
    (CONTROL(2800, 2803)) ctrlSetStructuredText parseText format["<t color='#e74c3c'>%1</t>", localize "STR_Shop_Veh_Disable_Blocked_by_Administrator"];
    ctrlEnable[2804, false];
    (CONTROL(2800, 2803)) ctrlSetPositionH(ctrlTextHeight(CONTROL(2800, 2803)));
    (CONTROL(2800, 2803)) ctrlCommit 0;
};
switch (playerSide) do {
    case civilian:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_CIVILIAN");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_CIVILIAN");
        };
    case west:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_COP");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_COP");
        };
    case independent:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_MEDIC");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_MEDIC");
        };
    case east:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_OPFOR");
            _sellMultiplier = LIFE_SETTINGS(getNumber, "vehicle_sell_multiplier_OPFOR");
        };
}; _retrievePrice = round(_purchasePrice * _storageFee);
_sellPrice = _purchasePrice * _sellMultiplier;
if (!(_sellPrice isEqualType 0) || _sellPrice < 1) then {
    _sellPrice = 500;
};
if (!(_retrievePrice isEqualType 0) || _retrievePrice < 1) then {
    _retrievePrice = 5;
};
_immatriculation = (_dataArr select 4);
if (_immatriculation == "0") then {
    _immatriculation = "Aucune"
};
tvClear 2805;
_titleItem =
if !(_trunkSpace isEqualTo - 1) then[{
    format[localize "STR_Garage_VirtualInventory", (_trunk select 1), _trunkSpace]
}, {
    format[localize "STR_Garage_VirtualInventory", 0, 0]
}];
tvAdd[2805, [], _titleItem];
if !(_trunk isEqualTo[[], 0]) then {
    {
        if (isClass(missionConfigFile >> "VirtualItems" >> (_x select 0))) then {
            _textItem = format["%1 (%2)", localize ITEM_NAME((_x select 0)), (_x select 1)];
            _tooltipItem = format[localize "STR_Garage_ItemQuantity", (_x select 1)];
            _iconItem = getText(missionConfigFile >> "VirtualItems" >> (_x select 0) >> "icon");
        } else {
            _textItem = format[localize "STR_Garage_ErrItemClassname", (_x select 0), (_x select 1)];
            _tooltipItem = localize "STR_Global_ErrorPleaseContactStaff";
            _iconItem = "\A4L_Textures\mission\icons\ico_red_mark.paa";
        };
        tvAdd[2805, [0], _textItem];
        tvSetTooltip[2805, [0, _forEachIndex], _tooltipItem];
        if !(_iconItem isEqualTo "") then {
            tvSetPicture[2805, [0, _forEachIndex], _iconItem];
        };
    }
    forEach(_trunk select 0);
} else {
    tvAdd[2805, [0], localize "STR_Garage_NoItemInCar"];
};
tvAdd[2805, [], localize "STR_Garage_PhysicalInventory"];
_tmpIndex = 0;
if !(_gear isEqualTo[]) then {
    {
        _tmpList = (_gear # _forEachIndex);
        if !(_tmpList isEqualTo[[], []]) then {
            tvAdd[2805, [1], localize _x]; {
                if !(_x isEqualTo '') then {
                    _itemInfo = [_x] call life_fnc_fetchCfgDetails;
                    if !(_itemInfo isEqualTo[]) then {
                        _textItem = format["%1 (%2)", (_itemInfo # 1), ((_tmpList # 1) # _forEachIndex)];
                        _tooltipItem = format[localize "STR_Garage_ItemQuantity", ((_tmpList # 1) # _forEachIndex)];
                        _iconItem = (_itemInfo # 2);
                    } else {
                        _textItem = format[localize "STR_Garage_ErrItemClassname", _x, ((_tmpList # 1) # _forEachIndex)];
                        _tooltipItem = localize "STR_Global_ErrorPleaseContactStaff";
                        _iconItem = "\A4L_Textures\mission\icons\ico_red_mark.paa";
                    };
                } else {
                    _textItem = localize "STR_Garage_ErrItemBdd";
                    _tooltipItem = localize "STR_Global_ErrorPleaseContactStaff";
                    _iconItem = "\A4L_Textures\mission\icons\ico_red_mark.paa";
                };
                tvAdd[2805, [1, _tmpIndex], _textItem];
                tvSetTooltip[2805, [1, _tmpIndex, _forEachIndex], _tooltipItem];
                tvSetPicture[2805, [1, _tmpIndex, _forEachIndex], _iconItem];
            }
            forEach(_tmpList # 0);
            _tmpIndex = _tmpIndex + 1;
        };
    }
    forEach["STR_Garage_PhysInvCatItems", "STR_Garage_PhysInvCatMagazines", "STR_Garage_PhysInvCatWeapons", "STR_Garage_PhysInvCatBackpack"];
} else {
    tvAdd[2805, [1], localize "STR_Garage_NoItemInCar"];
};
tvExpandAll 2805;
ctrlShow[2805, true];
ctrlShow[2831, true];
(CONTROL(2800, 2803)) ctrlSetStructuredText parseText format[(localize "STR_Shop_Veh_UI_RetrievalP") + " <t color='#8cff9b'>%1€</t><br/>
	" + (localize "STR_Shop_Veh_UI_SellP") + " <t color='#8cff9b'>%2€</t><br/>
	" + "Contrôle technique: %10<br/>
	" + ([(_dataArr select 5), (_dataArr select 6), (_dataArr select 7)] call advanced_insurance_fnc_insuranceStatus) + "
	" + (localize "STR_Shop_Veh_UI_Color") + " %8<br/>
	" + "Plaque d'immatriculation: <t color='#8cff9b'>%9</t><br/>
	" + (localize "STR_Shop_Veh_UI_MaxSpeed") + " %3 km/h<br/>
	" + (localize "STR_Shop_Veh_UI_HPower") + " %4<br/>
	" + (localize "STR_Shop_Veh_UI_PSeats") + " %5<br/>
	" + (localize "STR_Shop_Veh_UI_Trunk") + " %6<br/>
	" + (localize "STR_Shop_Veh_UI_Fuel") + " %7
    " + (localize "STR_Shop_Veh_UI_FuelType") + " %11<br/>", [_retrievePrice] call life_fnc_numberText, [_sellPrice] call life_fnc_numberText, (_vehicleInfo select 8), (_vehicleInfo select 11), (_vehicleInfo select 10),
if (_trunkSpace isEqualTo - 1) then {
    "None"
} else {
    _trunkSpace
}, (_vehicleInfo select 12), _vehicleColor, _immatriculation, [(_dataArr select 8), (_dataArr select 10)] call max_controltech_fnc_inspectionStatus, [_className] call max_fuelstations_fnc_getFuelType];
(CONTROL(2800, 2803)) ctrlSetPositionH(ctrlTextHeight(CONTROL(2800, 2803)));
(CONTROL(2800, 2803)) ctrlCommit 0;