#include "..\..\script_macros.hpp"
private["_nearVehicles", "_vehicle", "_listAllowTypeVehicle", "_canStoreLocation", "_vehData", "_vehDb"];
_listAllowTypeVehicle =
if ((_this select 3) isEqualType[]) then[{
    ((_this select 3) select 0)
}, {
    ["Car", "Bicycle"]
}];
_canStoreLocation =
if ((_this select 3) isEqualType[]) then[{
    ((_this select 3) select 1)
}, {
    false
}];
_radiusToCheck =
if (count(["Air", "Ship"] arrayIntersect _listAllowTypeVehicle) > 0) then[{
    100
}, {
    30
}];
_storeVehGarageList = [];
_nearVehicles = nearestObjects[getPos player, _listAllowTypeVehicle, _radiusToCheck];
if (count _nearVehicles >= 1) then {
    {
        _storeVehGarageList pushBack _x;
    }
    forEach _nearVehicles;
} else {
    [localize "STR_Garage_NoNPC", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((count _storeVehGarageList) isEqualTo 0) exitWith {
    [localize "STR_Garage_NoNPC", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
disableSerialization;
createDialog "listVehiclesFourriere";
_ctrlVehChoice = (findDisplay 48600) displayCtrl 38601; {
    _vehicle = _x;
    _vehClassname = typeOf _vehicle;
    _vehName = getText(configFile >> "CfgVehicles" >> _vehClassname >> "displayName");
    _vehPicture = getText(configFile >> "CfgVehicles" >> _vehClassname >> "picture");
    _vehicleImmatriculation = _vehicle getVariable["vehicle_info_plate", getPlateNumber _vehicle];
    _vehicleImmatriculation =
    if (_vehicleImmatriculation in ["0", ""]) then {
        "Déplaqué"
    } else {
        _vehicleImmatriculation
    };
    _ctrlVehChoice lbAdd format["%1 (%2)", _vehName, _vehicleImmatriculation];
    _ctrlVehChoice lbSetData[(lbSize _ctrlVehChoice) - 1, (netId _vehicle)];
    if !(_vehPicture isEqualTo "") then {
        _ctrlVehChoice lbSetPicture[(lbSize _ctrlVehChoice) - 1, _vehPicture];
        _ctrlVehChoice lbSetPictureColor[(lbSize _ctrlVehChoice) - 1, [1, 1, 1, 1]];
    };
}
forEach _storeVehGarageList;
_ctrlVehChoice lbSetCurSel 0;