#include "..\..\script_macros.hpp"
private["_nearVehicles", "_vehicle", "_listAllowTypeVehicle", "_canStoreLocation", "_vehData", "_vehDb"];
_target = (_this select 0);
_player = (_this select 1);
_listAllowTypeVehicle =
if ((_this select 3) isEqualType[]) then[{
    ((_this select 3) select 0)
}, {
    ["Car", "Bicycle"]
}];
_canStoreLocation =
if ((_this select 3) isEqualType[]) then[{
    ((_this select 3) select 1)
}, {
    false
}];
_radiusToCheck =
if (count(["Air", "Ship"] arrayIntersect _listAllowTypeVehicle) > 0) then[{
    100
}, {
    30
}];
_storeVehGarageList = [];
_isPrivateGarage = isClass(missionConfigFile >> "Garages" >> worldName >> (typeOf _target));
_tryToStoreTruckInGarage = false;
if !(isNull objectParent player) then {
    _storeVehGarageList pushBack(vehicle player);
} else {
    _nearVehicles = nearestObjects[getPos _target, _listAllowTypeVehicle, _radiusToCheck];
    if (count _nearVehicles > 0) then {
        {
            _vehData = _x getVariable["vehicle_info_owners", []];
            if (count _vehData > 0) then {
                _vehOwners = _x getVariable["vehicle_has_keys", []];
                if ((getPlayerUID player) in _vehOwners) then {
                    _vehDb = _x getVariable["dbInfo", []];
                    if (!(count _vehDb isEqualTo 0) || _canStoreLocation) then {
                        _poids_lourds = M_CONFIG(getText, "LifeCfgVehicles", (typeOf _x), "conditions");
                        if ((["license_civ_trucking", _poids_lourds] call BIS_fnc_inString) && _isPrivateGarage) then {
                            _tryToStoreTruckInGarage = true;
                            continue;
                        };
                        _storeVehGarageList pushBack _x;
                    };
                };
            };
        }
        forEach _nearVehicles;
    };
};
if (_tryToStoreTruckInGarage) then {
    [localize "STR_Garage_Store_CantStoreTruck", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if ((count _storeVehGarageList) isEqualTo 0) exitWith {
    [localize "STR_Garage_NoNPC", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
disableSerialization;
createDialog "storeVehGarage";
_ctrlVehChoice = (findDisplay 38600) displayCtrl 38601; {
    _vehicle = _x;
    _vehClassname = typeOf _vehicle;
    _vehName = getText(configFile >> "CfgVehicles" >> _vehClassname >> "displayName");
    _vehPicture = getText(configFile >> "CfgVehicles" >> _vehClassname >> "picture");
    _vehicleImmatriculation = _vehicle getVariable["vehicle_info_plate", getPlateNumber _vehicle];
    _vehicleImmatriculation =
    if (_vehicleImmatriculation in ["0", ""]) then {
        "Déplaqué"
    } else {
        _vehicleImmatriculation
    };
    _ctrlVehChoice lbAdd format["%1 (%2)", _vehName, _vehicleImmatriculation];
    _ctrlVehChoice lbSetData[(lbSize _ctrlVehChoice) - 1, (netId _vehicle)];
    if !(_vehPicture isEqualTo "") then {
        _ctrlVehChoice lbSetPicture[(lbSize _ctrlVehChoice) - 1, _vehPicture];
        _ctrlVehChoice lbSetPictureColor[(lbSize _ctrlVehChoice) - 1, [1, 1, 1, 1]];
    };
}
forEach _storeVehGarageList;
_ctrlVehChoice lbSetCurSel 0;