#include "..\..\script_macros.hpp"
private["_vehicle", "_className", "_vid", "_pid", "_unit", "_price", "_price", "_storageFee", "_purchasePrice"];
disableSerialization;
if ((lbCurSel 2802) isEqualTo - 1) exitWith {
    [localize "STR_Global_NoSelection", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_vehicle = lbData[2802, (lbCurSel 2802)];
if (_vehicle isEqualTo "classname_not_exist") exitWith {
    [localize "STR_Shop_Veh_Disable_CfgVehicle_Not_found", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_className = (call compile format["%1", _vehicle]) select 0;
if (isNil "_className") exitWith {
    [localize "STR_Garage_Selection_Error", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (!isClass(missionConfigFile >> "LifeCfgVehicles" >> _className)) exitWith {
    [localize "STR_Shop_Veh_Disable_LifeCfgVehicles_Not_found", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_vid = lbValue[2802, (lbCurSel 2802)];
_pid = getPlayerUID player;
_unit = player;
_spawntext = localize "STR_Garage_spawn_Success";
_price = M_CONFIG(getNumber, "LifeCfgVehicles", _className, "price");
_storageFee = LIFE_SETTINGS(getNumber, "vehicle_storage_fee_multiplier");
if (M_CONFIG(getNumber, "LifeCfgVehicles", _className, "blocked_by_admin") isEqualTo 1) exitWith {
    [localize "STR_Shop_Veh_Disable_Blocked_by_Administrator", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
switch (playerSide) do {
    case civilian:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_CIVILIAN");
        };
    case west:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_COP");
        };
    case independent:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_MEDIC");
        };
    case east:
        {
            _purchasePrice = _price * LIFE_SETTINGS(getNumber, "vehicle_purchase_multiplier_OPFOR");
        };
}; _price = round(_purchasePrice * _storageFee);
if (!(_price isEqualType 0) || _price < 1) then {
    _price = 5;
};
if (BANK < _price) exitWith {
    [format[(localize "STR_Garage_CashError"), [_price] call life_fnc_numberText], "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
_poids_lourds = M_CONFIG(getText, "LifeCfgVehicles", _className, "conditions");
if ((life_garage_sp isEqualType[]) && (["license_civ_trucking", _poids_lourds] call BIS_fnc_inString)) exitWith {
    [localize "STR_Garage_TruckError", "Error"] spawn Poltich_fnc_Notification_handleMsg;
};
if (life_garage_sp isEqualType[]) then {
    if (life_HC_isActive) then {
        [_vid, _pid, (life_garage_sp select 0), _unit, _price, (life_garage_sp select 1), _spawntext] remoteExec["HC_fnc_spawnVehicle", HC_Life];
    } else {
        [_vid, _pid, (life_garage_sp select 0), _unit, _price, (life_garage_sp select 1), _spawntext] remoteExec["TON_fnc_spawnVehicle", RSERV];
    };
} else {
    if (life_HC_isActive) then {
        [_vid, _pid, (getMarkerPos life_garage_sp), _unit, _price, markerDir life_garage_sp, _spawntext] remoteExec["HC_fnc_spawnVehicle", HC_Life];
    } else {
        [_vid, _pid, (getMarkerPos life_garage_sp), _unit, _price, markerDir life_garage_sp, _spawntext] remoteExec["TON_fnc_spawnVehicle", RSERV];
    };
};
[localize "STR_Garage_SpawningVeh", "InfoWithSound"] spawn Poltich_fnc_Notification_handleMsg;
BANK = BANK - _price;
[1] call SOCK_fnc_updatePartial;
closeDialog 0;
[format["vient de sortir un %1 (id: %2) de son garage", _className, _vid]] call life_fnc_logs;