[] call compile preprocessFileLineNumbers "\life_server\init.sqf";
MSN_messages = [];
publicVariable "MSN_messages";
[] spawn {
    if ((getNumber(missionConfigFile >> "Life_Cfg_RandomEnvironment" >> "enableSystem")) isEqualTo 0) exitWith {};
    _objectsToRandomPlace = []; {
        _objectsToRandomPlace pushBack(configName _x);
    }
    forEach("true"
    configClasses(missionConfigFile >> "Life_Cfg_RandomEnvironment")); {
        _is2DZone = getNumber(missionConfigFile >> "Life_Cfg_RandomEnvironment" >> _x >> "is2DZone");
        _allLocations = getArray(missionConfigFile >> "Life_Cfg_RandomEnvironment" >> _x >> "possibleLocations");
        _selectLocation = selectRandom _allLocations;
        _objIdConfig = _x; {
            if (isNil(_x select 0)) then {
                continue;
            };
            _objPosition = call compile(_x select 0);
            if (_x isEqualTo _selectLocation) then {
                _marker = _selectLocation select 1;
                if (_is2DZone isEqualTo 1) then {
                    _objIdConfig setMarkerPos(getPos _objPosition);
                } else {
                    _obj = call compile _objIdConfig;
                    _obj setPosATL(getPosATL _objPosition);
                    _obj setDir(getDir _objPosition);
                };
                if (_marker != "") then {
                    _marker setMarkerPos(getPos _objPosition);
                    _marker setMarkerDir 0;
                };
            };
            deleteVehicle _objPosition;
        }
        forEach _allLocations;
    }
    forEach _objectsToRandomPlace;
};
private _classnames = ["Land_Atm_01_F", "Land_Atm_02_F", "Land_ATM_01_malden_F", "Land_ATM_02_malden_F", "Land_Mattaust_ATM", "Land_A4L_ATM_PayEasy_F"];
private _i = 1; {
    _pos = position _x;
    _marker = format["A4LDAB_%1", _i];
    createMarker[_marker, _pos];
    _marker setMarkerType "hellbz_marker_poi_atm";
    _i = _i + 1;
}
forEach nearestObjects[[worldSize / 2, worldSize / 2], _classnames, worldSize]; {
    if ((["atm_", str(_x)] call BIS_fnc_inString)) then {
        _pos = position _x;
        _marker = format["A4LDAB_%1", _i];
        createMarker[_marker, _pos];
        _marker setMarkerType "hellbz_marker_poi_atm";
        _i = _i + 1;
    };
}
forEach nearestTerrainObjects[[worldSize / 2, worldSize / 2], ["HIDE"], worldSize * sqrt 2 / 2, false];
[] spawn theprogrammer_markers_filter_fnc_sortMarkers;
[] spawn {
    while {
        true
    }
    do {
        {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_vert.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 0];
            _x animateSource["orange", 0];
            _x animateSource["green", 1];
        } forEach synchronizedObjects Logic_Feux_Circulations_1; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_2;
        uiSleep 15; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_orange.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 0];
            _x animateSource["orange", 1];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_1; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_2;
        uiSleep 3; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_1; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_2;
        uiSleep 2; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_1; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_vert.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 0];
            _x animateSource["orange", 0];
            _x animateSource["green", 1];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_2;
        uiSleep 15; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_1; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_orange.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 0];
            _x animateSource["orange", 1];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_2;
        uiSleep 3; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_1; {
            _x setObjectTextureGlobal[0, "\A4L_Textures\feu_tricolor\FT_rouge.paa"];
            _x setObjectMaterialGlobal[0, "\armaforlife_sundae_base_textures\rvmats\car_panels.rvmat"];
            _x animateSource["red", 1];
            _x animateSource["orange", 0];
            _x animateSource["green", 0];
        }
        forEach synchronizedObjects Logic_Feux_Circulations_2;
        uiSleep 2;
        [] spawn TON_fnc_broadcastMessageFromPanelToIG;
    };
};
addMissionEventHandler["EntityKilled", {
    params["_entity", "_killer", "_instigator"];
    if (_entity isKindOf "LandVehicle" || _entity isKindOf "Ship") then {
        {
            moveOut _x;
            unassignVehicle _x;
            private _pp = getPosATL _x;
            _x setPosATL[_pp select 0, _pp select 1, (_pp select 2) + 1];
            _x setVelocity[0, 0, 5];
        }
        forEach crew _entity;
    };
}];
_bitcoinPrice = getNumber(missionConfigFile >> "The_Programmer_Darknet" >> "bitcoin_default_price");
_newBitcoinPrice = (1 + (random[-0.1, 0, 0.1])) * _bitcoinPrice;
missionNameSpace setVariable["armaforlife_bitcoin_price", _newBitcoinPrice, true];